# 画面設計書 49-デフォルト受信者設定

## 概要

本ドキュメントは、Ghost管理画面の「デフォルト受信者設定」画面の設計仕様を定義する。この画面は新規投稿時のデフォルトのニュースレター配信対象を設定する機能を提供する。

### 本画面の処理概要

この画面では、新しいコンテンツを公開する際に、デフォルトでどの対象にメール配信するかを設定できる。5つのプリセットオプションと、カスタムセグメント指定が可能。

**業務上の目的・背景**：Ghostでは投稿をメールで配信できるが、毎回対象を手動選択するのは手間がかかる。デフォルトの配信対象を設定することで、投稿作成時の操作を効率化し、意図しない配信ミスを防ぐことができる。

**画面へのアクセス方法**：管理画面のサイドバーから「Settings」→「Email」セクション→「Default recipients」カードにアクセスする。URLは`/ghost/#/settings`でnavid: `default-recipients`となる。

**主要な操作・処理内容**：
1. デフォルト配信対象のプリセット選択（5種類）
2. 「Specific people」選択時のカスタムセグメント指定
3. 設定の保存

**画面遷移**：設定画面のEmailセクションに直接表示される。編集後は「Save」ボタンで保存、「Cancel」で変更を破棄できる。

**権限による表示制御**：Administrator以上のロールを持つユーザーのみがデフォルト受信者設定にアクセスできる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 20 | ニュースレター管理 | 主機能 | デフォルト配信対象の設定 |

## 画面種別

設定画面（インライン編集型）

## URL/ルーティング

- 画面URL: `/ghost/#/settings` (navid: `default-recipients`)

## 入出力項目

| 項目名 | 種別 | データ型 | 必須 | 説明 |
|--------|------|---------|------|------|
| Default Newsletter recipients | 入力 | string | 必須 | デフォルト配信対象の選択 |
| Filter (segments) | 入力 | string[] | 条件付き | カスタムセグメント（Specific people選択時のみ） |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| Select dropdown | Select | 5つのプリセットオプション |
| MultiSelect (segments) | MultiSelect | ティア/ラベル/オファーの複数選択 |

## 選択オプション仕様

### Default Newsletter recipients オプション

| オプション | 値 | 内部設定値 | 説明 |
|-----------|-----|-----------|------|
| Whoever has access to the post | visibility | editor_default_email_recipients='visibility' | 無料投稿は全員、有料投稿は有料メンバーのみ |
| All members | all-members | filter='status:free,status:-free' | 無料・有料問わず全メンバー |
| Paid-members only | paid-only | filter='status:-free' | 有料メンバーのみ |
| Specific people | segment | filter=(カスタム値) | 選択したティア/ラベル/オファー |
| Usually nobody | none | filter=null | デフォルトはオフ、必要時に有効化 |

### セグメントオプション（Specific people選択時）

| グループ | オプション | フィルター値 |
|---------|----------|-------------|
| - | Free members | status:free |
| - | Paid members | status:-free |
| Active Tiers | (ティア名) | (tier_id) |
| Archived Tiers | (ティア名) | (tier_id) |
| Labels | (ラベル名) | label:(slug) |
| Offers | (オファー名) | offer_redemptions:(offer_id) |

## イベント仕様

### 1-配信対象選択

Selectドロップダウンで選択を変更すると：

1. `setDefaultRecipientValue`関数が呼び出される
2. `editor_default_email_recipients`設定を更新
   - visibility/disabled: そのまま設定
   - その他: `'filter'`に設定
3. `editor_default_email_recipients_filter`設定を更新
   - all-members: `'status:free,status:-free'`
   - paid-only: `'status:-free'`
   - none: `null`
   - visibility: `null`
4. 編集モードを開始

### 2-セグメント選択

MultiSelectでセグメントを選択/解除すると：

1. `updateSelectedSegments`関数が呼び出される
2. 選択されたセグメントをカンマ区切りで結合
3. `editor_default_email_recipients_filter`を更新
4. セグメントが空になった場合は`'none'`に切り替え

### 3-保存

「Save」ボタンをクリックすると：

1. `handleSave`で設定をAPIに送信
2. 成功時は編集モードを終了

### 4-キャンセル

「Cancel」ボタンをクリックすると：

1. `handleCancel`で変更を破棄
2. 設定を元の値に戻す
3. useEffectで`selectedOption`をリセット

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 配信対象選択 | settings | UPDATE | editor_default_email_recipients更新 |
| セグメント選択 | settings | UPDATE | editor_default_email_recipients_filter更新 |

### テーブル別更新項目詳細

#### settings

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | key='editor_default_email_recipients' | 'visibility'/'filter'/'disabled' | 配信モード |
| UPDATE | key='editor_default_email_recipients_filter' | フィルター文字列/null | セグメント指定 |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|----------|
| 説明 | When you publish new content, who do you usually want to send it to? | 常時表示（グループ説明） |
| ヒント | Who should receive your posts by default? | Selectの下部 |
| 各オプションのヒント | Free posts to everyone, premium posts sent to paid members | visibility選択時 |
| 各オプションのヒント | Everyone who is subscribed to newsletter updates, whether free or paid members | all-members選択時 |
| 各オプションのヒント | People who have a premium subscription | paid-only選択時 |
| 各オプションのヒント | Only people with any of the selected tiers or labels | segment選択時 |
| 各オプションのヒント | Newsletters are off for new posts, but can be enabled when needed | none選択時 |

## 例外処理

| 状態 | 処理内容 |
|------|----------|
| 保存エラー | エラートーストを表示 |
| セグメント全解除 | 自動的に'none'に切り替え |

## 備考

- 配信対象は投稿エディタで個別に変更可能（ここはあくまでデフォルト値）
- `editor_default_email_recipients`が`'filter'`の場合、`filter`の内容で配信対象を決定
- セグメントは非同期で読み込まれる（ティア、ラベル、オファーのAPIを並列呼び出し）
- 編集ボタンは非表示（hideEditButton=true）で、直接編集モードで操作
- セグメント選択にはdebounce（500ms）が適用されている

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、デフォルト受信者設定に関連する設定値を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | default-recipients.tsx | `apps/admin-x-settings/src/components/settings/email/default-recipients.tsx` | RECIPIENT_FILTER_OPTIONS定数（14-34行目） |
| 1-2 | default-recipients.tsx | 同上 | getDefaultRecipientValue関数（36-53行目） |

**読解のコツ**: `editor_default_email_recipients`と`editor_default_email_recipients_filter`の組み合わせでUIの選択状態を決定する。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | default-recipients.tsx | `apps/admin-x-settings/src/components/settings/email/default-recipients.tsx` | DefaultRecipientsコンポーネントの構造（55-169行目） |

**主要処理フロー**:
1. **56-64行目**: `useSettingGroup`でローカル設定を管理
2. **66-68行目**: 現在の設定値を取得
3. **70-73行目**: 選択オプションの初期化
4. **75行目**: `useDefaultRecipientsOptions`でセグメント選択機能を初期化

#### Step 3: セグメント選択機能を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | use-default-recipients-options.tsx | `apps/admin-x-settings/src/components/settings/email/use-default-recipients-options.tsx` | フック全体（1-99行目） |

**主要処理フロー**:
- **10-18行目**: SIMPLE_SEGMENT_OPTIONS（Free/Paid members）
- **21-23行目**: useFilterableApiでティア/ラベル/オファーを取得
- **31-61行目**: `loadOptions`でセグメントオプションを動的に読み込み
- **63-84行目**: `initSelectedSegments`で初期選択を復元

#### Step 4: 設定更新処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | default-recipients.tsx | `apps/admin-x-settings/src/components/settings/email/default-recipients.tsx` | setDefaultRecipientValue（86-110行目） |
| 4-2 | default-recipients.tsx | 同上 | updateSelectedSegments（112-125行目） |

**主要処理フロー**:
- **86-110行目**: プリセット選択時の設定更新ロジック
- **112-125行目**: セグメント選択時の設定更新ロジック

### プログラム呼び出し階層図

```
DefaultRecipients (default-recipients.tsx)
    │
    ├─ useSettingGroup()
    │      ├─ localSettings
    │      │      ├─ editor_default_email_recipients
    │      │      └─ editor_default_email_recipients_filter
    │      │
    │      ├─ updateSetting(key, value)
    │      ├─ handleSave()
    │      │      └─ PUT /settings/
    │      ├─ handleCancel()
    │      └─ handleEditingChange()
    │
    ├─ useState(selectedOption)
    │      └─ プリセット選択状態
    │
    ├─ useDefaultRecipientsOptions()
    │      ├─ useFilterableApi('/tiers/')
    │      ├─ useFilterableApi('/labels/')
    │      ├─ useFilterableApi('/offers/')
    │      │
    │      ├─ loadOptions()
    │      │      └─ Promise.all([tiers, labels, offers])
    │      │
    │      ├─ initSelectedSegments()
    │      │      └─ フィルター文字列→選択オプション変換
    │      │
    │      └─ selectedSegments (state)
    │
    └─ Form UI
           ├─ Select (プリセット選択)
           │      └─ onSelect: setDefaultRecipientValue()
           │
           └─ MultiSelect (セグメント選択)
                  └─ onChange: updateSelectedSegments()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

                    ┌─────────────────┐
Settings DB ────────┤ getSettingValues │
                    │                  │
                    └────────┬─────────┘
                             │
                    ┌────────▼─────────┐
                    │getDefaultRecipient│
                    │Value()            │
                    └────────┬─────────┘
                             │
              ┌──────────────┼──────────────┐
              │              │              │
    ┌─────────▼────┐  ┌──────▼─────┐       │
    │ Select       │  │ MultiSelect │       │
    │ (プリセット)  │  │ (セグメント) │       │
    └──────┬───────┘  └──────┬─────┘       │
           │                 │              │
プリセット変更─┘        セグメント変更─┘        │
           │                 │              │
    ┌──────▼───────┐  ┌──────▼─────────┐   │
    │setDefaultReci│  │updateSelectedSeg│   │
    │pientValue()  │  │ments()          │   │
    └──────┬───────┘  └──────┬─────────┘   │
           │                 │              │
           └────────┬────────┘              │
                    │                       │
           ┌────────▼────────┐              │
           │ updateSetting() │              │
           └────────┬────────┘              │
                    │                       │
           ┌────────▼────────┐              │
handleSave ─┤PUT /settings/  │──────────────┘
           └─────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| default-recipients.tsx | `apps/admin-x-settings/src/components/settings/email/default-recipients.tsx` | ソース | メイン設定コンポーネント |
| use-default-recipients-options.tsx | `apps/admin-x-settings/src/components/settings/email/use-default-recipients-options.tsx` | ソース | セグメント選択フック |
| settings.ts | `apps/admin-x-framework/src/api/settings.ts` | ソース | 設定API定義 |
| use-setting-group.ts | `apps/admin-x-settings/src/hooks/use-setting-group.ts` | ソース | 設定グループ管理フック |
| top-level-group.tsx | `apps/admin-x-settings/src/components/top-level-group.tsx` | ソース | 設定グループUIコンポーネント |
