# 画面設計書 51-Mailgun設定

## 概要

本ドキュメントは、Ghost管理画面における「Mailgun設定」画面の設計仕様を記述するものである。

### 本画面の処理概要

Mailgun設定画面は、Ghost CMSからニュースレターを一括配信するためのメールサービス「Mailgun」との連携設定を行う画面である。

**業務上の目的・背景**：Ghostは大規模なニュースレター配信においてMailgun APIを使用する設計となっている。デフォルトのメールサービスでは配信量に制限があるため、Mailgunとの連携によって大量のメールを確実に配信できる環境を整備する必要がある。この画面により、管理者はMailgunのAPIキーとドメイン設定を行い、プロフェッショナルなニュースレター配信環境を構築できる。

**画面へのアクセス方法**：管理画面のサイドメニューから「Settings」を選択し、「Email」セクション内の「Mailgun」項目をクリックしてアクセスする。URLパスは`#/settings/mailgun`となる。

**主要な操作・処理内容**：
1. Mailgunリージョン（US/EU）の選択
2. Mailgunドメイン名の入力
3. Mailgun Private APIキーの入力
4. 設定の保存とキャンセル

**画面遷移**：設定画面のEmailセクションからアクセスし、保存またはキャンセル後は設定画面に戻る。他のEmail設定（ニュースレター有効化、デフォルト受信者設定、ニュースレター設定）との間で相互に遷移可能である。

**権限による表示制御**：Administrator（管理者）およびOwner（オーナー）ロールのみがこの設定にアクセス・編集可能である。Editorおよび下位ロールは設定画面自体にアクセスできない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 67 | メール配信管理 | 主機能 | Mailgun APIキー・ドメインの設定 |
| 20 | ニュースレター管理 | 補助機能 | ニュースレター配信時のメール送信基盤 |
| 35 | 一般設定 | 遷移先機能 | 設定画面全体のナビゲーション |

## 画面種別

編集

## URL/ルーティング

- 管理画面URL: `/ghost/#/settings/mailgun`
- 内部ルーティング: `navid='mailgun'`
- ReactコンポーネントID: `TopLevelGroup` with `testId='mailgun'`

## 入出力項目

| 項目名 | 項目ID | データ型 | 入力/出力 | 必須 | 最大長 | 説明 |
|--------|--------|----------|-----------|------|--------|------|
| Mailgunリージョン | mailgun_base_url | string | 入力 | - | - | US（api.mailgun.net/v3）またはEU（api.eu.mailgun.net/v3）を選択 |
| Mailgunドメイン | mailgun_domain | string | 入力 | - | 255 | Mailgunで設定したドメイン名 |
| Mailgun Private APIキー | mailgun_api_key | string | 入力 | - | 255 | Mailgunから発行されたプライベートAPIキー（パスワード形式で表示） |

## 表示項目

| 項目名 | 表示条件 | 説明 |
|--------|----------|------|
| ステータス（設定完了時） | mailgun_domain && mailgun_api_key が設定済み | 緑色チェックアイコンと「Mailgun is set up」メッセージを表示 |
| ステータス（未設定時） | mailgun_domain または mailgun_api_key が未設定 | 「Mailgun is not set up」メッセージを表示 |
| 説明リンク | 常時 | 「Why is this required?」リンク（ghost.org/docs/faq/mailgun-newsletters）を表示 |
| APIキーヘルプリンク | 編集モード時 | 「Find your Mailgun API keys here」リンク（app.mailgun.com/settings/api_security）を表示 |

## イベント仕様

### 1-編集モード開始

TopLevelGroupコンポーネントのonEditingChange呼び出しにより編集モードに遷移する。編集モードではリージョン選択、ドメイン入力フィールド、APIキー入力フィールドが表示される。

### 2-リージョン変更

Selectコンポーネントでリージョンを選択すると、updateSetting関数が呼ばれ、`mailgun_base_url`設定値がローカル状態に反映される。選択肢はUS（https://api.mailgun.net/v3）とEU（https://api.eu.mailgun.net/v3）の2つ。

### 3-設定保存

保存ボタン押下時にonSaveハンドラが実行される。リージョンが未設定の場合は自動的にUS（デフォルト）が設定される。その後handleSave関数によりPUT `/settings/` APIが呼び出され、設定値がサーバーに永続化される。

### 4-設定キャンセル

キャンセルボタン押下時にhandleCancel関数が呼ばれ、ローカル状態がリセットされ編集モードを終了する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 設定保存 | settings | UPDATE | mailgun_base_url, mailgun_domain, mailgun_api_keyの3設定を更新 |

### テーブル別更新項目詳細

#### settings

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | key='mailgun_base_url' の value | 選択されたリージョンURL（未選択時はデフォルトUS） | |
| UPDATE | key='mailgun_domain' の value | 入力されたドメイン名 | |
| UPDATE | key='mailgun_api_key' の value | 入力されたAPIキー | 暗号化して保存 |

## メッセージ仕様

| メッセージID | 種類 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG-001 | 成功 | Saved | 設定保存成功時 |
| MSG-002 | 情報 | Mailgun is set up | ドメインとAPIキーが設定済みの場合 |
| MSG-003 | 情報 | Mailgun is not set up | 設定未完了の場合 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| API通信エラー | handleError関数によりエラーメッセージを表示、設定は保存されない |
| 無効なAPIキー | サーバー側でバリデーションエラーが発生し、エラートーストを表示 |
| セッション切れ | 認証画面へリダイレクト |

## 備考

- Mailgunは無料プランでも一定量のメール配信が可能だが、大規模配信には有料プランが必要
- APIキーはパスワードフィールドとしてマスク表示される
- リージョン選択はGDPRコンプライアンスに関連し、EUリージョンを選択することでデータのEU内保持が可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Mailgun設定で扱う設定値の構造と、Settings APIの型定義を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | settings.ts | `apps/admin-x-framework/src/api/settings.ts` | Setting型の定義（8-12行目）、getSettingValues関数（85-87行目）でキーから値を取得する仕組み |
| 1-2 | use-setting-group.tsx | `apps/admin-x-settings/src/hooks/use-setting-group.tsx` | LocalSetting型（8-10行目）、dirty状態の管理方法 |

**読解のコツ**: Settings APIは汎用的な設計で、keyとvalueのペアで全設定を管理している。Mailgun関連のキーは`mailgun_base_url`、`mailgun_domain`、`mailgun_api_key`の3つ。

#### Step 2: エントリーポイントを理解する

Mailgun設定コンポーネントのメインファイルを読み解く。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | mailgun.tsx | `apps/admin-x-settings/src/components/settings/email/mailgun.tsx` | コンポーネント全体の構造、状態管理の仕組み |

**主要処理フロー**:
1. **13-24行目**: useSettingGroupフックで設定の状態管理を初期化
2. **26-28行目**: getSettingValuesで現在の設定値を取得（mailgun_base_url, mailgun_domain, mailgun_api_key）
3. **30行目**: isMailgunSetupで設定完了状態を判定
4. **107-121行目**: onSave時のリージョンデフォルト設定処理

#### Step 3: 設定管理フックを理解する

useSettingGroupカスタムフックの内部実装を読み解く。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | use-setting-group.tsx | `apps/admin-x-settings/src/hooks/use-setting-group.tsx` | 設定の編集・保存・キャンセルのロジック |

**主要処理フロー**:
- **38-46行目**: useFormフックで状態管理を初期化、onSaveでeditSettingsを呼び出し
- **68-76行目**: changedSettings関数でdirtyな設定のみ抽出
- **90-100行目**: updateSetting関数で個別設定を更新、dirty=trueを設定

#### Step 4: UIコンポーネント層を理解する

TopLevelGroupとSettingGroupContentの構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | top-level-group.tsx | `apps/admin-x-settings/src/components/top-level-group.tsx` | 設定グループの共通レイアウト、検索との連携 |

**主要処理フロー**:
- **12-18行目**: TopLevelGroupPropsの定義、キーワード検索との連携
- **50-58行目**: BaseコンポーネントへのProps受け渡し

### プログラム呼び出し階層図

```
MailGun (mailgun.tsx)
    │
    ├─ useSettingGroup()
    │      ├─ useGlobalData() ... 現在の設定を取得
    │      ├─ useEditSettings() ... 設定更新API
    │      └─ useForm() ... フォーム状態管理
    │
    ├─ getSettingValues() ... 設定値の抽出
    │
    └─ TopLevelGroup
           ├─ SettingGroupContent ... 表示/入力コンテンツ
           │      ├─ Select (Mailgun region)
           │      └─ TextField (domain, api_key)
           │
           └─ onSave → editSettings() → PUT /settings/
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ユーザー入力 ───▶ updateSetting() ───▶ localSettings (dirty)
    │
    ▼
保存ボタン押下 ───▶ onSave()
    │              │
    │              ├─ リージョン未設定チェック
    │              │      └─ editSettings(デフォルト値)
    │              │
    │              └─ handleSave()
    │                     └─ editSettings(changedSettings)
    │
    ▼
PUT /settings/ ───▶ サーバー側処理 ───▶ settingsテーブル更新
    │
    ▼
APIレスポンス ───▶ React Query ───▶ UI更新（成功/エラー表示）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| mailgun.tsx | `apps/admin-x-settings/src/components/settings/email/mailgun.tsx` | ソース | Mailgun設定画面のメインコンポーネント |
| use-setting-group.tsx | `apps/admin-x-settings/src/hooks/use-setting-group.tsx` | ソース | 設定グループ共通のカスタムフック |
| settings.ts | `apps/admin-x-framework/src/api/settings.ts` | ソース | Settings API定義とユーティリティ |
| top-level-group.tsx | `apps/admin-x-settings/src/components/top-level-group.tsx` | ソース | 設定グループのラッパーコンポーネント |
| global-data-provider.tsx | `apps/admin-x-settings/src/components/providers/global-data-provider.tsx` | ソース | グローバル設定データのProvider |
