# 画面設計書 52-ネットワーク設定

## 概要

本ドキュメントは、Ghost管理画面における「ネットワーク設定」画面の設計仕様を記述するものである。

### 本画面の処理概要

ネットワーク設定画面は、GhostサイトのActivityPub（ソーシャルウェブ）連携を有効化・無効化するための設定画面である。この機能により、投稿をフェディバース（BlueSky、Threads、Mastodon、Flipboard、WordPress等）に配信し、より広いオーディエンスにコンテンツを届けることができる。

**業務上の目的・背景**：従来のSNS（Twitter/X、Facebook等）に加えて、分散型ソーシャルネットワーク（フェディバース）への対応が求められている。ActivityPubプロトコルを活用することで、GhostサイトをMastodon等のフェディバースクライアントからフォロー可能にし、投稿を自動配信できる。これにより、特定のプラットフォームに依存しないコンテンツ配信が実現する。

**画面へのアクセス方法**：管理画面のサイドメニューから「Settings」を選択し、「Growth」セクション内の「Network」項目をクリックしてアクセスする。URLパスは`#/settings/network`となる。

**主要な操作・処理内容**：
1. ソーシャルウェブ（ActivityPub）機能のON/OFF切り替え
2. 機能の説明・対応プラットフォームの確認
3. 無効化の理由（プライベートモード、不正なホスティング環境）の確認

**画面遷移**：設定画面のGrowthセクションからアクセスする。プライベートモード警告からはサイトロック設定（locksite）へ遷移可能。外部ヘルプリンクからはGhostのヘルプページへ遷移する。

**権限による表示制御**：Administrator（管理者）およびOwner（オーナー）ロールのみがこの設定にアクセス・編集可能である。機能自体は、ホスティング環境やサイトモードによって自動的に無効化される場合がある。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 57 | ActivityPub | 主機能 | ActivityPub連携の有効化・設定 |
| 35 | 一般設定 | 補助機能 | プライベートモード設定との連携 |

## 画面種別

設定（トグル形式）

## URL/ルーティング

- 管理画面URL: `/ghost/#/settings/network`
- 内部ルーティング: `navid='network'`
- ReactコンポーネントID: `TopLevelGroup` with `testId='network'`

## 入出力項目

| 項目名 | 項目ID | データ型 | 入力/出力 | 必須 | 最大長 | 説明 |
|--------|--------|----------|-----------|------|--------|------|
| ソーシャルウェブ有効化 | social_web | boolean | 入力 | - | - | ActivityPub機能のON/OFF |

## 表示項目

| 項目名 | 表示条件 | 説明 |
|--------|----------|------|
| Networkトグル | 常時 | ソーシャルウェブ機能のON/OFFを切り替えるトグルスイッチ |
| 説明テキスト | 常時 | 対応プラットフォーム（BlueSky、Threads、Mastodon、Flipboard、WordPress）の説明 |
| プライベートモード警告 | isPrivate=true | プライベートモード時は自動無効化される旨のメッセージとリンク |
| カスタムドメイン警告 | isDisabledByHosting=true | サブディレクトリ/localhost/IP接続時の警告とヘルプリンク |
| 説明画像 | 常時 | network.png - ソーシャルウェブのイメージ画像 |

## イベント仕様

### 1-トグル切り替え

Toggleコンポーネントの変更イベントでtoggleSocialWebSetting関数が呼び出される。この関数はeditSettings APIを使用して`social_web`設定を即座に更新する。編集モードの概念はなく、トグル操作が直接設定の永続化を行う。

### 2-プライベートモードリンク押下

プライベートモード警告内のリンク押下時、updateRoute('locksite')により、サイトロック設定画面へ遷移する。

### 3-ヘルプリンク押下

カスタムドメイン警告内のヘルプリンク押下時、外部URL（ghost.org/help/social-web/#custom-domain-required）が新規タブで開かれる。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| トグル切り替え | settings | UPDATE | social_web設定値を更新 |

### テーブル別更新項目詳細

#### settings

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | key='social_web' の value | true/false（トグルの状態） | |

## メッセージ仕様

| メッセージID | 種類 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG-001 | 警告 | Network is automatically disabled while your site is in private mode | プライベートモード時 |
| MSG-002 | 警告 | You need to configure a supported custom domain to use this feature. | ホスティング環境が非対応時 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| API通信エラー | handleError関数によりエラーメッセージを表示 |
| 機能が無効化されている | トグルがdisabled状態となり操作不可 |
| セッション切れ | 認証画面へリダイレクト |

## 備考

- 機能が無効化される条件：
  1. Ghost (Pro)で機能が設定により無効化されている場合（limitSocialWeb）
  2. サブディレクトリでホストされている場合（本番環境）
  3. localhost/127.0.0.1/::1でホストされている場合（本番環境）
  4. IPアドレスでホストされている場合（本番環境）
  5. サイトがプライベートモードの場合
- 無効化状態ではトグルがOFF表示となり、操作できない
- 開発環境（NODE_ENV !== 'production'）ではホスティング環境の制限が適用されない

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ネットワーク設定で使用される設定値と制限フラグの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | settings.ts | `apps/admin-x-framework/src/api/settings.ts` | Setting型の定義、getSettingValues関数 |
| 1-2 | use-limiter.ts | `apps/admin-x-settings/src/hooks/use-limiter.ts` | Ghost Proの機能制限チェック |

**読解のコツ**: `social_web`設定値はboolean型。機能制限は複数条件のOR判定で決定される。

#### Step 2: エントリーポイントを理解する

ネットワーク設定コンポーネントのメインファイルを読み解く。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | network.tsx | `apps/admin-x-settings/src/components/settings/growth/network.tsx` | コンポーネント全体の構造、無効化判定ロジック |

**主要処理フロー**:
1. **14-17行目**: useGlobalData/useEditSettings/useHandleError/useRoutingフックの初期化
2. **23-34行目**: 無効化条件の判定（isDisabledByConfig、isHostedOnSubdirectory、isHostedOnLocalhost、isHostedOnIP）
3. **35行目**: isDisabled = isDisabledByHosting || isDisabledByPrivateMode
4. **40-41行目**: isChecked = socialWebSetting && !isDisabled
5. **44-54行目**: toggleSocialWebSetting関数でeditSettingsを直接呼び出し

#### Step 3: 無効化条件の詳細を理解する

各種無効化条件の判定ロジックを読み解く。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | network.tsx | `apps/admin-x-settings/src/components/settings/growth/network.tsx` | 26-34行目の条件判定 |

**主要処理フロー**:
- **26行目**: getGhostPaths()からsubdirを取得
- **27行目**: process.env.NODE_ENV === 'production'で本番環境判定
- **28行目**: getSettingValuesでis_private設定を取得
- **29行目**: isProduction && !!subdirでサブディレクトリ判定
- **30行目**: isProduction && hostname in [localhost, 127.0.0.1, ::1]
- **31行目**: isProduction && validator.isIP(hostname)でIP接続判定

#### Step 4: UI構成を理解する

画面表示の条件分岐とコンポーネント構成を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | network.tsx | `apps/admin-x-settings/src/components/settings/growth/network.tsx` | 56-97行目のJSX構成 |

**主要処理フロー**:
- **57-65行目**: customButtonsとしてToggleを配置、isDisabled状態を適用
- **73-91行目**: SettingGroupContent内で条件分岐メッセージを表示
- **92-94行目**: 説明画像（network.png）の表示

### プログラム呼び出し階層図

```
Network (network.tsx)
    │
    ├─ useGlobalData() ... settings取得
    │
    ├─ useLimiter() ... Ghost Pro制限チェック
    │      └─ isDisabled('limitSocialWeb')
    │
    ├─ getGhostPaths() ... subdir取得
    │
    ├─ getSettingValues() ... is_private, social_web取得
    │
    ├─ 無効化判定ロジック
    │      ├─ isDisabledByConfig (Pro制限)
    │      ├─ isHostedOnSubdirectory
    │      ├─ isHostedOnLocalhost
    │      ├─ isHostedOnIP
    │      └─ isDisabledByPrivateMode
    │
    ├─ toggleSocialWebSetting
    │      └─ editSettings([{key: 'social_web', value: boolean}])
    │
    └─ TopLevelGroup
           ├─ Toggle (customButtons)
           ├─ SettingGroupContent (警告メッセージ)
           └─ img (network.png)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

初期表示
settings ───▶ getSettingValues ───▶ social_web, is_private
    │
環境チェック ───▶ 無効化判定 ───▶ isDisabled
    │                                  │
    │                                  ▼
    │                           Toggle disabled状態
    │
トグル操作
ユーザー操作 ───▶ toggleSocialWebSetting
    │
    ▼
editSettings ───▶ PUT /settings/ ───▶ settingsテーブル更新
    │
    ▼
React Query ───▶ settings再取得 ───▶ UI更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| network.tsx | `apps/admin-x-settings/src/components/settings/growth/network.tsx` | ソース | ネットワーク設定画面のメインコンポーネント |
| settings.ts | `apps/admin-x-framework/src/api/settings.ts` | ソース | Settings API定義 |
| use-limiter.ts | `apps/admin-x-settings/src/hooks/use-limiter.ts` | ソース | Ghost Pro機能制限チェック |
| helpers.ts | `apps/admin-x-framework/src/helpers.ts` | ソース | getGhostPaths関数 |
| network.png | `apps/admin-x-settings/src/assets/images/network.png` | アセット | 説明画像 |
| global-data-provider.tsx | `apps/admin-x-settings/src/components/providers/global-data-provider.tsx` | ソース | グローバル設定データのProvider |
