# 画面設計書 53-Explore設定

## 概要

本ドキュメントは、Ghost管理画面における「Explore設定」画面の設計仕様を記述するものである。

### 本画面の処理概要

Explore設定画面は、GhostサイトをGhost Exploreディレクトリへ掲載するための設定を行う画面である。Ghost Exploreは、Ghostを使用しているサイトを集めたディレクトリサービスであり、掲載によりサイトの露出を高めることができる。

**業務上の目的・背景**：コンテンツパブリッシャーにとって、新規読者の獲得は重要な課題である。Ghost Exploreへの掲載により、Ghost公式サイトや関連サービス上でサイトが紹介され、潜在的な読者にリーチできる。また、成長データを共有することでランキングが向上し、より多くの露出が得られる仕組みとなっている。

**画面へのアクセス方法**：管理画面のサイドメニューから「Settings」を選択し、「Growth」セクション内の「Ghost Explore」項目をクリックしてアクセスする。URLパスは`#/settings/explore`となる。

**主要な操作・処理内容**：
1. Ghost Exploreへの掲載のON/OFF切り替え
2. 成長データ共有のON/OFF切り替え（ランキング向上のため）
3. 掲載プレビューの確認
4. 推薦文（Testimonial）の送信

**画面遷移**：設定画面のGrowthセクションからアクセスする。「Send testimonial」ボタンからはテスティモニアル送信モーダル（explore/testimonial）へ遷移する。

**権限による表示制御**：Administrator（管理者）およびOwner（オーナー）ロールのみがこの設定にアクセス・編集可能である。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 91 | Explore連携 | 主機能 | Ghost Exploreディレクトリへの掲載設定 |
| 35 | 一般設定 | 補助機能 | タイトル・説明文・アクセントカラーの取得 |

## 画面種別

設定（トグル形式 + プレビュー）

## URL/ルーティング

- 管理画面URL: `/ghost/#/settings/explore`
- 内部ルーティング: `navid='explore'`
- ReactコンポーネントID: `TopLevelGroup` with `testId='explore'`

## 入出力項目

| 項目名 | 項目ID | データ型 | 入力/出力 | 必須 | 最大長 | 説明 |
|--------|--------|----------|-----------|------|--------|------|
| Explore掲載有効化 | explore_ping | boolean | 入力 | - | - | Ghost Exploreへの掲載ON/OFF |
| 成長データ共有 | explore_ping_growth | boolean | 入力 | - | - | 成長データ共有によるランキング向上ON/OFF |

## 表示項目

| 項目名 | 表示条件 | 説明 |
|--------|----------|------|
| Exploreトグル | 常時 | Ghost Explore掲載のON/OFFを切り替えるトグルスイッチ |
| 成長データ共有トグル | exploreEnabled=true | 成長データ共有のON/OFFを切り替えるトグルスイッチ（ヒント付き） |
| プレビューカード | exploreEnabled=true | Exploreでの表示プレビュー（アイコン、タイトル、説明、URL、メンバー数） |
| メンバー数バッジ | exploreEnabled=true && shareGrowthData=true | メンバー数を表示するバッジ |
| 矢印アイコン | exploreEnabled=true && shareGrowthData=false | 外部リンクを示す矢印アイコン |
| Testimonialバナー | exploreEnabled=true | Ghost.orgホームページへの掲載を促すバナーとボタン |
| 説明画像 | exploreEnabled=false | ghost-explore.png - Ghost Exploreの紹介画像 |

## イベント仕様

### 1-Exploreトグル切り替え

Toggleコンポーネントの変更イベントでtoggleSetting関数が呼び出される。引数として'explore_ping'キーと新しい値が渡され、editSettings APIで即座に設定が永続化される。

### 2-成長データ共有トグル切り替え

Toggleコンポーネントの変更イベントでtoggleSetting関数が呼び出される。引数として'explore_ping_growth'キーと新しい値が渡され、editSettings APIで即座に設定が永続化される。

### 3-Testimonial送信ボタン押下

「Send testimonial」ボタン押下時にupdateRoute('explore/testimonial')が呼び出され、テスティモニアル送信モーダルへ遷移する。

### 4-プレビューカードのURL押下

プレビューカード内のサイトURL部分をクリックすると、サイトのホームページが新規タブで開かれる。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| Exploreトグル切り替え | settings | UPDATE | explore_ping設定値を更新 |
| 成長データ共有トグル切り替え | settings | UPDATE | explore_ping_growth設定値を更新 |

### テーブル別更新項目詳細

#### settings

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | key='explore_ping' の value | true/false（トグルの状態） | |
| UPDATE | key='explore_ping_growth' の value | true/false（トグルの状態） | |

## メッセージ仕様

| メッセージID | 種類 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG-001 | ヒント | Enabling this will use your revenue/member growth data to rank your site more highly on Ghost Explore. Total member count will be displayed publicly, other data will be kept private. | 成長データ共有トグルのヒント |
| MSG-002 | 説明 | Get featured on the Ghost.org homepage | Testimonialバナーのタイトル |
| MSG-003 | 説明 | Send us a quote we can use to highlight your site | Testimonialバナーの補足説明 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| API通信エラー | handleError関数によりエラーメッセージを表示 |
| メンバー数取得失敗 | デフォルト値0を使用 |
| セッション切れ | 認証画面へリダイレクト |

## 備考

- プレビューカードにはサイトのアイコン（設定済みの場合）またはデフォルトロゴが表示される
- アイコン未設定時はアクセントカラーを背景にしたデフォルトロゴが使用される
- メンバー数は実際のメンバー数をabbreviateNumber関数で省略形式（1K、10Kなど）に変換して表示
- 成長データ共有時のみメンバー数が公開される点を明示している

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Explore設定で使用される設定値とメンバー情報の取得方法を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | settings.ts | `apps/admin-x-framework/src/api/settings.ts` | Setting型の定義、getSettingValues関数 |
| 1-2 | members.ts | `apps/admin-x-framework/src/api/members.ts` | useBrowseMembersフックでメンバー数を取得 |

**読解のコツ**: `explore_ping`と`explore_ping_growth`はboolean型。メンバー数はpaginationのtotalから取得。

#### Step 2: エントリーポイントを理解する

Explore設定コンポーネントのメインファイルを読み解く。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | explore.tsx | `apps/admin-x-settings/src/components/settings/growth/explore.tsx` | コンポーネント全体の構造、プレビュー表示ロジック |

**主要処理フロー**:
1. **14-18行目**: useGlobalData/useEditSettings/useHandleError/useRoutingフックの初期化
2. **21-33行目**: useBrowseMembersでメンバー数を取得（limit: '1'で件数のみ取得）
3. **35-42行目**: getSettingValuesで各設定値を取得（accent_color, icon, title, description, explore_ping, explore_ping_growth）
4. **47-57行目**: toggleSetting関数で設定をトグル

#### Step 3: プレビュー表示ロジックを理解する

プレビューカードの条件分岐と表示内容を読み解く。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | explore.tsx | `apps/admin-x-settings/src/components/settings/growth/explore.tsx` | 74-132行目のJSX構造 |

**主要処理フロー**:
- **74行目**: exploreEnabled ? でプレビュー表示を分岐
- **88-100行目**: アイコン表示（設定済み/デフォルト）の分岐
- **106-117行目**: メンバー数バッジ/矢印アイコンの分岐（shareGrowthData条件）
- **120-127行目**: Testimonialバナー表示

#### Step 4: Shadeライブラリのユーティリティを理解する

abbreviateNumber関数によるメンバー数のフォーマットを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | abbreviate-number関連 | `apps/shade/src/` | 数値の省略表示ロジック |

### プログラム呼び出し階層図

```
Explore (explore.tsx)
    │
    ├─ useGlobalData() ... settings取得
    │
    ├─ useBrowseMembers() ... メンバー数取得
    │      └─ refetch → members.meta.pagination.total
    │
    ├─ useSettingGroup() ... localSettings, siteData取得
    │
    ├─ getSettingValues() ... 各設定値抽出
    │      ├─ accent_color, icon
    │      ├─ title, description
    │      ├─ explore_ping
    │      └─ explore_ping_growth
    │
    ├─ toggleSetting(key, event)
    │      └─ editSettings([{key, value}])
    │
    └─ TopLevelGroup
           ├─ Toggle (Explore有効化 - customButtons)
           │
           ├─ exploreEnabled=true時
           │      ├─ Toggle (成長データ共有)
           │      ├─ プレビューカード
           │      │      ├─ アイコン (icon or デフォルト)
           │      │      ├─ title, description
           │      │      ├─ siteDomain
           │      │      └─ メンバー数 or 矢印アイコン
           │      │
           │      └─ Testimonialバナー
           │             └─ Button → updateRoute('explore/testimonial')
           │
           └─ exploreEnabled=false時
                  └─ 説明画像 (ghost-explore.png)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

初期表示
settings ───▶ getSettingValues ───▶ explore_ping, explore_ping_growth
    │                                 accent_color, icon, title, description
    │
members API ───▶ useBrowseMembers ───▶ membersCount
    │
    ▼
条件判定 ───▶ プレビュー表示/非表示

トグル操作
ユーザー操作 ───▶ toggleSetting(key, event)
    │
    ▼
editSettings ───▶ PUT /settings/ ───▶ settingsテーブル更新
    │
    ▼
React Query ───▶ settings再取得 ───▶ UI更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| explore.tsx | `apps/admin-x-settings/src/components/settings/growth/explore.tsx` | ソース | Explore設定画面のメインコンポーネント |
| settings.ts | `apps/admin-x-framework/src/api/settings.ts` | ソース | Settings API定義 |
| members.ts | `apps/admin-x-framework/src/api/members.ts` | ソース | Members API定義（メンバー数取得用） |
| use-setting-group.tsx | `apps/admin-x-settings/src/hooks/use-setting-group.tsx` | ソース | 設定グループ共通フック |
| ghost-explore.png | `apps/admin-x-settings/src/assets/images/ghost-explore.png` | アセット | 説明画像 |
| explore-default-logo.png | `apps/admin-x-settings/src/assets/images/explore-default-logo.png` | アセット | デフォルトロゴ画像 |
| global-data-provider.tsx | `apps/admin-x-settings/src/components/providers/global-data-provider.tsx` | ソース | グローバル設定データのProvider |
