# 画面設計書 55-埋め込みフォーム設定

## 概要

本ドキュメントは、Ghost管理画面における「埋め込みフォーム設定」画面の設計仕様を記述するものである。

### 本画面の処理概要

埋め込みフォーム設定画面は、外部サイトに設置可能なサインアップフォームの生成と設定を行う画面である。このフォームをウェブサイトやブログに埋め込むことで、訪問者をGhostサイトのメンバーとして獲得できる。

**業務上の目的・背景**：メンバー獲得は複数のタッチポイントから行うことが効果的である。Ghost本体のサイト以外にも、ランディングページ、他のブログ、企業サイトなどにサインアップフォームを設置することで、より広いオーディエンスにリーチできる。この埋め込みフォームにより、技術的な知識がなくてもHTMLコードをコピー&ペーストするだけで外部サイトにフォームを設置できる。

**画面へのアクセス方法**：管理画面のサイドメニューから「Settings」を選択し、「Growth」セクション内の「Signup forms」項目をクリックしてアクセスする。URLパスは`#/settings/embed-signup-form`となる。「Embed」ボタンをクリックするとプレビュー・設定モーダルが開く。

**主要な操作・処理内容**：
1. 埋め込みフォームのプレビュー表示（モーダル）
2. フォームのカスタマイズ（色、スタイル等）
3. 埋め込みコードの取得

**画面遷移**：設定画面のGrowthセクションからアクセスする。「Embed」ボタンからはプレビューモーダル（embed-signup-form/show）へ遷移する。

**権限による表示制御**：Administrator（管理者）およびOwner（オーナー）ロールのみがこの設定にアクセス・編集可能である。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 73 | Signup Form | 主機能 | 埋め込みサインアップフォームのカスタマイズ |
| 8 | メンバー登録 | 補助機能 | フォーム経由でのメンバー登録処理 |

## 画面種別

設定（シンプルなエントリーポイント）

## URL/ルーティング

- 管理画面URL: `/ghost/#/settings/embed-signup-form`
- 内部ルーティング: `navid='embed-signup-form'`
- ReactコンポーネントID: `TopLevelGroup` with `testId='embed-signup-form'`
- モーダルルート: `/ghost/#/settings/embed-signup-form/show`

## 入出力項目

| 項目名 | 項目ID | データ型 | 入力/出力 | 必須 | 最大長 | 説明 |
|--------|--------|----------|-----------|------|--------|------|
| （この画面自体には入力項目なし - モーダルで設定） | - | - | - | - | - | - |

## 表示項目

| 項目名 | 表示条件 | 説明 |
|--------|----------|------|
| タイトル | 常時 | 「Signup forms」のタイトル |
| 説明文 | 常時 | 「Grow your audience from anywhere on the web」 |
| Embedボタン | 常時 | プレビューモーダルを開くボタン |

## イベント仕様

### 1-Embedボタン押下

ButtonコンポーネントのクリックイベントでopenPreviewModal関数が呼び出される。この関数はupdateRoute('embed-signup-form/show')を実行し、プレビュー・設定モーダルが表示される。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| （この画面からは直接DB更新なし） | - | - | モーダルでの設定変更時にsettingsテーブルが更新される |

## メッセージ仕様

| メッセージID | 種類 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| （この画面にはメッセージ表示なし） | - | - | - |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| セッション切れ | 認証画面へリダイレクト |

## 備考

- この画面はシンプルなエントリーポイントであり、実際の設定・カスタマイズはモーダル（embed-signup-form/show）で行われる
- 埋め込みフォームはUMDバンドルとして提供され、外部サイトでJavaScriptとして読み込まれる
- フォームのスタイルはGhostサイトのブランディング設定（アクセントカラー等）に連動する

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

埋め込みフォームに関連する設定値を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | settings.ts | `apps/admin-x-framework/src/api/settings.ts` | Setting型の定義 |

**読解のコツ**: 埋め込みフォームの設定はサイト全体のブランディング設定（accent_color等）を参照する。

#### Step 2: エントリーポイントを理解する

埋め込みフォーム設定画面のメインファイルを読み解く。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | embed-signup-form.tsx | `apps/admin-x-settings/src/components/settings/growth/embed-signup/embed-signup-form.tsx` | コンポーネント全体の構造 |

**主要処理フロー**:
1. **6行目**: EmbedSignupFormコンポーネント定義
2. **7行目**: useRoutingフックでルーティング関数を取得
3. **8-10行目**: openPreviewModal関数でupdateRoute('embed-signup-form/show')を呼び出し
4. **12-21行目**: TopLevelGroupでシンプルなUIを構成

#### Step 3: TopLevelGroupの構成を理解する

設定グループの共通レイアウトを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | top-level-group.tsx | `apps/admin-x-settings/src/components/top-level-group.tsx` | 共通ラッパーの実装 |

**主要処理フロー**:
- **12-18行目**: TopLevelGroupProps定義
- customButtonsプロパティでEmbedボタンを配置

### プログラム呼び出し階層図

```
EmbedSignupForm (embed-signup-form.tsx)
    │
    ├─ useRouting() ... ルーティング関数取得
    │
    ├─ openPreviewModal()
    │      └─ updateRoute('embed-signup-form/show')
    │
    └─ TopLevelGroup
           ├─ customButtons: Button 'Embed'
           │      └─ onClick: openPreviewModal
           │
           ├─ title: 'Signup forms'
           ├─ description: 'Grow your audience from anywhere on the web'
           ├─ navid: 'embed-signup-form'
           └─ testId: 'embed-signup-form'
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ユーザー操作
Embed click ───▶ openPreviewModal()
    │
    ▼
updateRoute('embed-signup-form/show') ───▶ モーダルルーティング
    │
    ▼
EmbedSignupFormModal表示 ───▶ プレビュー・設定UI
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| embed-signup-form.tsx | `apps/admin-x-settings/src/components/settings/growth/embed-signup/embed-signup-form.tsx` | ソース | 埋め込みフォーム設定のエントリーポイント |
| top-level-group.tsx | `apps/admin-x-settings/src/components/top-level-group.tsx` | ソース | 設定グループの共通ラッパー |
| signup-form（アプリ） | `apps/signup-form/` | ソース | 埋め込みフォームのReactアプリ本体 |
| form-page.tsx | `apps/signup-form/src/components/pages/form-page.tsx` | ソース | フォームのメインページコンポーネント |
| success-page.tsx | `apps/signup-form/src/components/pages/success-page.tsx` | ソース | 登録成功ページコンポーネント |
