# 画面設計書 59-マイグレーションツール

## 概要

本ドキュメントは、Ghost管理画面における「マイグレーションツール」画面の設計仕様を記述するものである。

### 本画面の処理概要

マイグレーションツール画面は、他のプラットフォームからGhostへのデータ移行（インポート）および、Ghostからのデータエクスポートを行うための画面である。複数のプラットフォーム専用のインポートツールと汎用的なインポート/エクスポート機能を提供する。

**業務上の目的・背景**：新規にGhostを導入する場合、既存のプラットフォーム（Substack、WordPress、Squarespace、Medium、Mailchimp等）からコンテンツやメンバーリストを移行する必要がある。マイグレーションツールにより、これらの移行作業を効率的に行える。また、バックアップ目的やプラットフォーム移転のためのデータエクスポートも可能。

**画面へのアクセス方法**：管理画面のサイドメニューから「Settings」を選択し、「Advanced」セクション内の「Migration tools」項目をクリックしてアクセスする。URLパスは`#/settings/migration`となる。

**主要な操作・処理内容**：
1. プラットフォーム別インポート（Substack、WordPress、Squarespace、Medium、Mailchimp）
2. ユニバーサルインポート（JSON形式）
3. コンテンツ＆設定のエクスポート
4. 投稿アナリティクスのエクスポート

**画面遷移**：設定画面のAdvancedセクションからアクセスする。各インポートボタンは対応するマイグレーションページ（/migrate/{platform}）へ遷移する。Universal importはインポートモーダルを開く。

**権限による表示制御**：Administrator（管理者）およびOwner（オーナー）ロールのみがこの設定にアクセス・編集可能である。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 65 | データベース管理 | 主機能 | データのインポート・エクスポート処理 |

## 画面種別

ツール（タブ切り替え式）

## URL/ルーティング

- 管理画面URL: `/ghost/#/settings/migration`
- 内部ルーティング: `navid='migration'`
- ReactコンポーネントID: `TopLevelGroup` with `testId='migrationtools'`
- マイグレーション遷移先: `/ghost/#/migrate/{platform}`

## 入出力項目

| 項目名 | 項目ID | データ型 | 入力/出力 | 必須 | 最大長 | 説明 |
|--------|--------|----------|-----------|------|--------|------|
| インポートファイル | importfile | file | 入力（モーダル） | Yes | - | JSON形式のGhostエクスポートファイル |

## 表示項目

| 項目名 | 表示条件 | 説明 |
|--------|----------|------|
| Importタブ | 常時 | インポート機能の一覧 |
| Exportタブ | 常時 | エクスポート機能の一覧 |
| Substackボタン | Importタブ | Substackからのインポート |
| WordPressボタン | Importタブ | WordPressからのインポート |
| Squarespaceボタン | Importタブ | Squarespaceからのインポート |
| Mediumボタン | Importタブ | Mediumからのインポート |
| Mailchimpボタン | Importタブ | Mailchimpからのインポート |
| Universal importボタン | Importタブ | 汎用JSONインポート |
| Content & settingsボタン | Exportタブ | 全データのJSONエクスポート |
| Post analyticsボタン | Exportタブ | 投稿分析データのCSVエクスポート |

## イベント仕様

### 1-タブ切り替え

TabViewコンポーネントでタブを選択すると、selectedTab状態が更新され、対応する機能が表示される。初期値は'import'。

### 2-Substackインポート押下

ImportButtonコンポーネントのクリックイベントでupdateRoute({isExternal: true, route: '/migrate/substack'})が呼び出され、Substack専用マイグレーションページへ遷移する。

### 3-WordPressインポート押下

updateRoute({isExternal: true, route: '/migrate/wordpress'})が呼び出され、WordPress専用マイグレーションページへ遷移する。

### 4-Squarespaceインポート押下

updateRoute({isExternal: true, route: '/migrate/squarespace'})が呼び出され、Squarespace専用マイグレーションページへ遷移する。

### 5-Mediumインポート押下

updateRoute({isExternal: true, route: '/migrate/medium'})が呼び出され、Medium専用マイグレーションページへ遷移する。

### 6-Mailchimpインポート押下

updateRoute({isExternal: true, route: '/migrate/mailchimp'})が呼び出され、Mailchimp専用マイグレーションページへ遷移する。

### 7-Universal import押下

handleImportContent関数が呼び出され、NiceModal.show(UniversalImportModal)によりインポートモーダルが表示される。

### 8-Content & settingsエクスポート押下

downloadAllContent関数が呼び出され、GET /db/ APIからJSONデータがダウンロードされる。

### 9-Post analyticsエクスポート押下

exportPosts関数が呼び出され、usePostsExportsでCSVデータを取得し、ブラウザでダウンロードされる。ファイル名は`post-analytics.{日付}.csv`形式。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| Universal import | posts, tags, members, settings等 | INSERT/UPDATE | インポートファイルの内容に基づいて複数テーブルを更新 |
| Content & settings export | - | SELECT | 全データを読み取りJSONを生成 |
| Post analytics export | posts, post_stats等 | SELECT | 投稿分析データを読み取りCSVを生成 |

## メッセージ仕様

| メッセージID | 種類 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG-001 | 説明 | Import content, members and subscriptions from other platforms or export your Ghost data. | 説明文 |
| MSG-002 | エラー | インポート処理中にエラーが発生した場合 | handleError経由 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| インポートファイル形式エラー | エラーメッセージを表示 |
| エクスポートAPI失敗 | handleError関数でエラートーストを表示 |
| セッション切れ | 認証画面へリダイレクト |

## 備考

- プラットフォーム別インポートは各サービス専用のマイグレーションページ（Ember.js側）で処理される
- Universal importはJSON形式のGhostエクスポートファイルを受け付ける
- Post analyticsエクスポートは最大1000件の投稿データをCSV形式でダウンロード
- Content & settingsエクスポートには投稿、ページ、タグ、メンバー、設定等が含まれる
- エクスポートファイルにはパスワードやAPIキー等の機密情報は含まれない

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

データベースAPIの定義を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | db.ts | `apps/admin-x-framework/src/api/db.ts` | useImportContent、downloadAllContent関数 |
| 1-2 | posts.ts | `apps/admin-x-framework/src/api/posts.ts` | usePostsExportsフック |

**読解のコツ**: インポートはFormData形式でファイルを送信、エクスポートはdownloadFromEndpoint関数でファイルをダウンロード。

#### Step 2: エントリーポイントを理解する

マイグレーションツール画面のメインファイルを読み解く。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | migration-tools.tsx | `apps/admin-x-settings/src/components/settings/advanced/migration-tools.tsx` | コンポーネント全体の構造、タブ管理 |

**主要処理フロー**:
1. **9-10行目**: selectedTab状態の管理（'import' | 'export'）
2. **12-23行目**: tabs配列の定義（Import, Export）
3. **25-36行目**: TopLevelGroupでラップ

#### Step 3: インポートコンポーネントを理解する

MigrationToolsImportコンポーネントの実装を読み解く。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | migration-tools-import.tsx | `apps/admin-x-settings/src/components/settings/advanced/migration-tools/migration-tools-import.tsx` | インポート機能の実装 |

**主要処理フロー**:
- **32-33行目**: useRouting取得
- **35-37行目**: handleImportContent関数（UniversalImportModalを開く）
- **40-83行目**: 各プラットフォームのImportButton定義

#### Step 4: エクスポートコンポーネントを理解する

MigrationToolsExportコンポーネントの実装を読み解く。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | migration-tools-export.tsx | `apps/admin-x-settings/src/components/settings/advanced/migration-tools/migration-tools-export.tsx` | エクスポート機能の実装 |

**主要処理フロー**:
- **8-13行目**: usePostsExportsフックの初期化（limit: '1000', enabled: false）
- **16-34行目**: exportPosts関数（CSV生成とダウンロード）
- **38行目**: downloadAllContent関数の呼び出し

### プログラム呼び出し階層図

```
MigrationTools (migration-tools.tsx)
    │
    ├─ selectedTab状態 ('import' | 'export')
    │
    └─ TabView
           ├─ Tab: Import
           │      └─ MigrationToolsImport
           │             ├─ ImportButton (Substack)
           │             │      └─ updateRoute({route: '/migrate/substack'})
           │             ├─ ImportButton (WordPress)
           │             │      └─ updateRoute({route: '/migrate/wordpress'})
           │             ├─ ImportButton (Squarespace)
           │             │      └─ updateRoute({route: '/migrate/squarespace'})
           │             ├─ ImportButton (Medium)
           │             │      └─ updateRoute({route: '/migrate/medium'})
           │             ├─ ImportButton (Mailchimp)
           │             │      └─ updateRoute({route: '/migrate/mailchimp'})
           │             └─ ImportButton (Universal)
           │                    └─ NiceModal.show(UniversalImportModal)
           │
           └─ Tab: Export
                  └─ MigrationToolsExport
                         ├─ Button (Content & settings)
                         │      └─ downloadAllContent() → GET /db/
                         └─ Button (Post analytics)
                                └─ exportPosts() → usePostsExports → CSV
```

### データフロー図

```
[入力]                    [処理]                         [出力]

インポート処理
ファイル選択 ───▶ UniversalImportModal
    │
    ▼
FormData生成 ───▶ POST /db/ ───▶ サーバー側インポート処理
    │
    ▼
posts, tags, members, settings更新

Content & settingsエクスポート
エクスポートボタン ───▶ downloadAllContent()
    │
    ▼
GET /db/ ───▶ JSON生成 ───▶ ブラウザダウンロード

Post analyticsエクスポート
エクスポートボタン ───▶ exportPosts()
    │
    ▼
usePostsExports.refetch()
    │
    ▼
GET /posts/exports/ ───▶ CSV生成
    │
    ▼
Blob作成 ───▶ ブラウザダウンロード
    │
    ▼
post-analytics.{日付}.csv
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| migration-tools.tsx | `apps/admin-x-settings/src/components/settings/advanced/migration-tools.tsx` | ソース | マイグレーションツール画面のメインコンポーネント |
| migration-tools-import.tsx | `apps/admin-x-settings/src/components/settings/advanced/migration-tools/migration-tools-import.tsx` | ソース | インポート機能コンポーネント |
| migration-tools-export.tsx | `apps/admin-x-settings/src/components/settings/advanced/migration-tools/migration-tools-export.tsx` | ソース | エクスポート機能コンポーネント |
| universal-import-modal.tsx | `apps/admin-x-settings/src/components/settings/advanced/migration-tools/universal-import-modal.tsx` | ソース | ユニバーサルインポートモーダル |
| db.ts | `apps/admin-x-framework/src/api/db.ts` | ソース | Database API定義 |
| posts.ts | `apps/admin-x-framework/src/api/posts.ts` | ソース | Posts API定義（エクスポート用） |
| helpers.ts | `apps/admin-x-framework/src/utils/helpers.ts` | ソース | downloadFromEndpoint関数 |
