# 画面設計書 6-セットアップ画面

## 概要

本ドキュメントは、Ghost管理画面のセットアップ画面の設計内容を記載する。

### 本画面の処理概要

セットアップ画面は、Ghostを初めてインストールした後に表示される初期設定画面である。サイトのタイトル、オーナーアカウントの作成など、Ghostを運用開始するために必要な最低限の設定を行う。

**業務上の目的・背景**：Ghostは初回起動時にセットアップが必要であり、この画面でオーナーアカウント（最高権限を持つユーザー）を作成する。セットアップが完了するまで、他の管理画面機能は使用できない。これにより、セキュアな状態でGhostの運用を開始できる。

**画面へのアクセス方法**：
- Ghostインストール直後、管理画面URL（`/ghost/`）にアクセスすると自動的にリダイレクト
- セットアップ未完了状態で認証関連画面にアクセスした場合もリダイレクト

**主要な操作・処理内容**：
1. サイトタイトル入力 - サイトの名前を設定（150文字以内）
2. フルネーム入力 - オーナーの表示名を入力
3. メールアドレス入力 - オーナーのログイン用メールアドレス
4. パスワード入力 - オーナーのログインパスワード（10文字以上）
5. アカウント作成ボタン押下 - セットアップ完了、自動ログイン後にセットアップ完了画面へ

**画面遷移**：
- 遷移元：初回アクセス、未認証ルートからのリダイレクト
- 遷移先：
  - セットアップ成功時：セットアップ完了画面
  - 既にセットアップ済みの場合：サインイン画面
  - 既にログイン済みの場合：ホーム画面

**権限による表示制御**：セットアップ未完了時のみアクセス可能。セットアップ完了済みの場合はサインイン画面にリダイレクトされる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 35 | 一般設定 | 主機能 | サイト名・説明などの初期設定 |
| 40 | スタッフ管理 | 補助機能 | オーナーアカウントの作成 |

## 画面種別

初期設定

## URL/ルーティング

- **URL**: `/ghost/setup`
- **Emberルート名**: `setup`
- **ルートファイル**: `ghost/admin/app/routes/setup.js`

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 入力/出力 | バリデーション | 備考 |
|--------|--------|-----|------|----------|---------------|------|
| サイトタイトル | blogTitle | string | 必須 | 入力 | 1〜150文字 | プレースホルダー: "The Daily Awesome" |
| フルネーム | name | string | 必須 | 入力 | 1文字以上 | プレースホルダー: "Jamie Larson" |
| メールアドレス | email | string | 必須 | 入力 | メール形式 | プレースホルダー: "jamie@example.com" |
| パスワード | password | string | 必須 | 入力 | 10文字以上、複雑性チェック | プレースホルダー: "At least 10 characters" |

## 表示項目

| 項目名 | 表示条件 | データソース | 備考 |
|--------|----------|--------------|------|
| Ghostロゴ | 常時 | SVG | ghost-orb |
| ウェルカムメッセージ | 常時 | 固定値 | "Welcome to Ghost." |
| 説明文 | 常時 | 固定値 | "All over the world, people have started 3,000,000+..." |
| フローエラー | エラー発生時 | flowErrors | 画面下部に赤字表示 |
| 項目別エラー | バリデーションエラー時 | errors | 各入力項目下に表示 |

## イベント仕様

### 1-アカウント作成ボタン押下

**トリガー**: 「Create account & start publishing →」ボタンクリック

**処理フロー**:
1. `setupTask`が実行される
2. クライアント側バリデーション実行（サイトタイトル、名前、メール、パスワード）
3. バリデーション成功時、APIエンドポイント`POST /ghost/api/admin/authentication/setup`にリクエスト送信
4. バックエンドでオーナーアカウント更新、設定更新、フィクスチャ更新
5. オプションでテーマインストール、ウェルカムメール送信
6. セットアップ成功後、自動ログイン実行
7. セットアップ完了画面へ遷移

**遷移先**:
- 成功時: `/ghost/setup/done` (セットアップ完了画面)

### 2-入力欄のフォーカスアウト

**トリガー**: 各入力欄からフォーカスが外れた時

**処理フロー**:
1. `preValidate(property)`アクションが実行される
2. 値が入力されている場合のみバリデーション実行
3. エラーがあれば入力欄下にエラーメッセージ表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| セットアップ | users | UPDATE | オーナーユーザーの情報更新 |
| セットアップ | settings | UPDATE | サイトタイトル、説明の設定 |
| セットアップ | tiers | UPDATE | デフォルトティアの名前更新 |
| セットアップ | newsletters | UPDATE | デフォルトニュースレターの名前更新 |
| セットアップ | posts | UPDATE | フィクスチャ投稿の内容更新 |
| 自動ログイン | sessions | INSERT | セッション作成 |

### テーブル別更新項目詳細

#### users

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | name | フォーム入力値 | オーナーの表示名 |
| UPDATE | email | フォーム入力値 | ログイン用メールアドレス |
| UPDATE | password | フォーム入力値（ハッシュ化） | bcryptでハッシュ化 |
| UPDATE | status | 'active' | inactive → active |

#### settings

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | title | フォーム入力値 | サイトタイトル |
| UPDATE | description | "Thoughts, stories and ideas." | デフォルト説明文 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| M001 | エラー | "Please enter a site title." | サイトタイトル未入力 |
| M002 | エラー | "Title is too long" | サイトタイトル150文字超過 |
| M003 | エラー | "Please enter a name." | 名前未入力 |
| M004 | エラー | "Please enter an email." | メールアドレス未入力 |
| M005 | エラー | "Invalid Email." | メールアドレス形式不正 |
| M006 | エラー | "Password must be at least 10 characters long." | パスワード10文字未満 |
| M007 | エラー | "Sorry, you cannot use an insecure password." | 安全でないパスワード |
| M008 | エラー | "Please fill out every field correctly to set up your site." | バリデーションエラー全般 |
| M009 | エラー | "Setup has already been completed." | 既にセットアップ完了済み |
| M010 | エラー | "There was a problem on the server." | サーバーエラー |

## 例外処理

| 例外ケース | 対応処理 | 表示内容 |
|-----------|----------|----------|
| セットアップ完了済み | サインイン画面へリダイレクト | - |
| 既にログイン済み | ホーム画面へリダイレクト | - |
| バリデーションエラー | エラー表示 | 該当するエラーメッセージ |
| オーナーユーザー不在 | APIエラー通知表示 | "Database missing fixture data. Please reset database and try again." |
| APIエラー | エラー通知表示 | APIエラーメッセージ |

## 備考

- セットアップはGhost初回起動時に1回のみ実行される
- オーナーユーザーはフィクスチャデータとして事前に存在し、セットアップで情報を更新する
- セットアップ完了後、デフォルトの投稿（coming-soon、about）の内容がサイトタイトルと作成者名で更新される
- デフォルトのティアとニュースレターの名前もサイトタイトルで更新される
- 設定ファイル（config）でsendWelcomeEmailがtrueの場合、ウェルカムメールが送信される
- テーマ指定がある場合、GitHubからテーマをインストールして有効化する
- 画面離脱時（deactivate）にパスワードがクリアされる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

セットアップに使用されるデータとバリデーションルールを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | setup.js (Controller) | `ghost/admin/app/controllers/setup.js` | プロパティ定義（blogTitle, name, email, password）、validationType |
| 1-2 | setup.js (Validator) | `ghost/admin/app/validators/setup.js` | blogTitleの追加バリデーション |
| 1-3 | new-user.js | `ghost/admin/app/validators/new-user.js` | name、email、passwordのバリデーション |

**読解のコツ**: setupバリデータはNewUserValidatorを継承し、blogTitleバリデーションを追加している。

#### Step 2: エントリーポイントを理解する

テンプレートとルートの関係を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | setup.hbs | `ghost/admin/app/templates/setup.hbs` | フォーム構造、GhTrimFocusInput/GhTextInputの使用 |
| 2-2 | setup.js (Route) | `ghost/admin/app/routes/setup.js` | beforeModelでのセットアップ状態確認、既存データの事前設定 |

**主要処理フロー**:
- **17-19行目**: 認証済みならホーム画面へリダイレクト
- **24-44行目**: セットアップ状態確認、完了済みならサインイン画面へ、未完了なら既存データをコントローラーに設定
- **47-50行目**: deactivateでパスワードクリア

#### Step 3: コントローラーのタスク処理を理解する

セットアップ処理の実装を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | setup.js (Controller) | `ghost/admin/app/controllers/setup.js` | setupTask、_passwordSetup、_afterAuthenticationの処理フロー |

**主要処理フロー**:
- **89-133行目**: _passwordSetupでバリデーション、API呼び出し、自動ログイン
- **92行目**: blogCreatedフラグでPOST/PUTを切り替え（再試行対応）
- **121行目**: 自動ログイン実行
- **159-163行目**: _afterAuthenticationでセットアップ完了画面へ遷移

#### Step 4: バックエンドAPI処理を理解する

サーバーサイドのセットアップ処理を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | authentication.js | `ghost/core/core/server/api/endpoints/authentication.js` | setup（25-81行目）のエンドポイント定義、処理フロー |
| 4-2 | setup.js | `ghost/core/core/server/services/auth/setup.js` | setupUser、doSettings、doFixtures、sendWelcomeEmailの実装 |

**主要処理フロー**:
- **authentication.js 37-51行目**: setupUser → doFixtures → doProductAndNewsletter → installTheme → doSettings → sendWelcomeEmail
- **setup.js 63-80行目**: setupUserでオーナーユーザーを更新
- **setup.js 82-108行目**: doSettingsでサイトタイトルと説明を設定
- **setup.js 111-143行目**: doTiersAndNewsletterでデフォルトティア・ニュースレターの名前更新

### プログラム呼び出し階層図

```
setup.hbs (テンプレート)
    │
    └─ SetupController.setupTask
           └─ _passwordSetup
                  ├─ ValidationEngine.validate
                  │      ├─ SetupValidator.blogTitle
                  │      └─ NewUserValidator (name, email, password)
                  │
                  ├─ POST /authentication/setup
                  │      └─ AuthenticationController.setup
                  │             ├─ assertSetupCompleted(false)
                  │             ├─ setupUser
                  │             │      └─ User.setup (オーナー更新)
                  │             ├─ doFixtures
                  │             │      └─ Post.edit (coming-soon, about更新)
                  │             ├─ doProductAndNewsletter
                  │             │      ├─ Tiers.edit
                  │             │      └─ Newsletters.edit
                  │             ├─ installTheme
                  │             ├─ doSettings
                  │             │      └─ Settings.edit (title, description)
                  │             └─ sendWelcomeEmail
                  │
                  └─ session.authenticate
                         └─ POST /session
                                └─ _afterAuthentication
                                       └─ router.transitionTo('setup.done')
```

### データフロー図

```
[入力]                      [処理]                              [出力]

blogTitle ────────────┐
name ─────────────────┼──▶ setupTask ──────────────────────▶ セットアップ
email ────────────────┤       │                              完了画面へ
password ─────────────┘       │                              遷移
                              │
                              ▼
                        POST /setup
                              │
                    ┌─────────┼─────────┐
                    │         │         │
                 users    settings    posts
                UPDATE    UPDATE     UPDATE
                    │         │         │
                    │    ┌────┴────┐    │
                    │    │         │    │
                    │  tiers  newsletters
                    │  UPDATE    UPDATE
                    │
                    ▼
              セッション作成
                sessions
                INSERT
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| setup.hbs | `ghost/admin/app/templates/setup.hbs` | テンプレート | セットアップフォームのUI定義 |
| setup.js | `ghost/admin/app/routes/setup.js` | ルート | ルーティング、セットアップ状態確認 |
| setup.js | `ghost/admin/app/controllers/setup.js` | コントローラー | フォーム処理とタスク定義 |
| setup.js | `ghost/admin/app/validators/setup.js` | バリデータ | セットアップ用バリデーション |
| new-user.js | `ghost/admin/app/validators/new-user.js` | バリデータ | ユーザー情報バリデーション |
| password.js | `ghost/admin/app/validators/mixins/password.js` | ミックスイン | パスワード複雑性バリデーション |
| authentication.js | `ghost/core/core/server/api/endpoints/authentication.js` | API | セットアップエンドポイント |
| setup.js | `ghost/core/core/server/services/auth/setup.js` | サービス | セットアップ処理実装 |
| user.js | `ghost/core/core/server/models/user.js` | モデル | ユーザーモデル、setup関数 |
| cookie.js | `ghost/admin/app/authenticators/cookie.js` | 認証 | 自動ログイン処理 |
