# 画面設計書 61-Labs設定

## 概要

本ドキュメントは、Ghost管理画面における「Labs設定」画面の設計仕様を記述したものである。Labs設定画面は、実験的機能やベータ機能のオン/オフを切り替えるための管理画面である。

### 本画面の処理概要

Labs設定画面は、Ghostの新機能や実験的機能を試用するためのフラグ管理を行う画面である。開発者やパワーユーザー向けに、正式リリース前の機能を有効化・無効化できる。

**業務上の目的・背景**：Ghostでは新機能を段階的にリリースするために、Labs（実験室）という仕組みを提供している。これにより、ユーザーは自己責任で新機能を試用でき、開発チームはフィードバックを収集できる。また、リダイレクトやルーティングの設定ファイルをアップロード・ダウンロードする機能も提供し、サイトのURL構造を柔軟に管理できる。

**画面へのアクセス方法**：設定画面（Settings）から「Advanced」セクション内の「Labs」を選択してアクセスする。URL は `/ghost/#/settings` から「Labs」セクションへ遷移。

**主要な操作・処理内容**：
1. Beta機能のトグルによる有効化/無効化（Enhanced Editor role、Show post excerpt inline、Additional payment methods等）
2. Private機能のトグルによる有効化/無効化（開発者実験モード有効時のみ表示）
3. リダイレクトファイル（redirects.yaml/json）のアップロード・ダウンロード
4. ルーティングファイル（routes.yaml）のアップロード・ダウンロード

**画面遷移**：設定画面のAdvancedセクションからアクセス。Labs設定画面からは他の設定項目や管理画面へ遷移可能。

**権限による表示制御**：Private featuresタブは `config.enableDeveloperExperiments` が有効な場合のみ表示される。管理者権限を持つユーザーのみがこの画面にアクセスできる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 35 | 一般設定 | 主機能 | 実験的機能のフラグ管理 |

## 画面種別

設定画面（トグル設定 + ファイルアップロード/ダウンロード）

## URL/ルーティング

- パス: `/ghost/#/settings`
- ナビゲーションID: `labs`
- 設定画面内の「Advanced」セクションに配置

## 入出力項目

### Beta機能トグル

| 項目名 | データ型 | 入力/出力 | 説明 |
|--------|----------|----------|------|
| Enhanced Editor role (beta) | boolean | 入力 | superEditors フラグ。エディターにメンバー・コメント管理権限を付与 |
| Show post excerpt inline | boolean | 入力 | editorExcerpt フラグ。エディタで抜粋入力を表示 |
| Additional payment methods | boolean | 入力 | additionalPaymentMethods フラグ。CashApp、iDEAL等の決済手段を有効化 |
| Redirects file | File | 入力 | リダイレクト設定ファイル（YAML/JSON） |
| Routes file | File | 入力 | ルーティング設定ファイル（YAML） |

### Private機能トグル（開発者モード時のみ）

| 項目名 | データ型 | 入力/出力 | 説明 |
|--------|----------|----------|------|
| Stripe Automatic Tax | boolean | 入力 | stripeAutomaticTax フラグ |
| Email customization | boolean | 入力 | emailCustomization フラグ |
| Import Member Tier | boolean | 入力 | importMemberTier フラグ |
| Explore | boolean | 入力 | explore フラグ |
| Tags X | boolean | 入力 | tagsX フラグ |
| Email Unique ID | boolean | 入力 | emailUniqueid フラグ |
| Welcome Emails | boolean | 入力 | welcomeEmails フラグ |
| Updated theme translation | boolean | 入力 | themeTranslation フラグ |
| Comment Moderation | boolean | 入力 | commentModeration フラグ |
| Comment Permalinks | boolean | 入力 | commentPermalinks フラグ |
| IndexNow | boolean | 入力 | indexnow フラグ |
| Featurebase Feedback | boolean | 入力 | featurebaseFeedback フラグ |
| Transistor | boolean | 入力 | transistor フラグ |
| Disable Member Commenting | boolean | 入力 | disableMemberCommenting フラグ |
| Sniper Links | boolean | 入力 | sniperlinks フラグ |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| Labs タイトル | テキスト | 「Labs」というセクションタイトル |
| Labs 説明文 | テキスト | 実験的機能に関する注意書き |
| Beta features タブ | タブ | ベータ機能一覧を表示 |
| Private features タブ | タブ | プライベート機能一覧（条件付き表示） |
| 各機能タイトル | テキスト | 機能名 |
| 各機能説明 | テキスト | 機能の説明文 |
| トグルスイッチ | Toggle | 機能のオン/オフ切り替え |

## イベント仕様

### 1-Open/Close ボタン押下

Labs設定パネルの開閉を行う。`isOpen` 状態をトグルし、展開時はタブビューを表示、閉じた状態では背景画像を表示。

### 2-機能トグル切り替え

1. トグルスイッチをクリック
2. 現在の `labs` 設定をJSONとして取得
3. 対象フラグの値を反転
4. `editSettings` APIを呼び出して `labs` 設定を更新
5. アナリティクスイベント（Feature Toggled）を送信
6. クエリキャッシュの `config` データを更新

### 3-リダイレクトファイルアップロード

1. ファイル選択ダイアログを開く
2. ファイルを選択
3. `uploadRedirects` APIを呼び出し
4. 成功時：「Redirects uploaded」トースト表示
5. 失敗時：エラーハンドリング

### 4-リダイレクトファイルダウンロード

1. 「Download current redirects」リンクをクリック
2. `downloadRedirects` 関数を実行
3. 現在のリダイレクト設定ファイルをダウンロード

### 5-ルートファイルアップロード

1. ファイル選択ダイアログを開く
2. ファイルを選択
3. `uploadRoutes` APIを呼び出し
4. 成功時：「Routes uploaded」トースト表示
5. 失敗時：エラーハンドリング

### 6-ルートファイルダウンロード

1. 「Download current routes」リンクをクリック
2. `downloadRoutes` 関数を実行
3. 現在のルーティング設定ファイルをダウンロード

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 機能トグル切り替え | settings | UPDATE | labs設定値の更新 |
| リダイレクトアップロード | - | - | ファイルシステムへの保存（DBなし） |
| ルートアップロード | - | - | ファイルシステムへの保存（DBなし） |

### テーブル別更新項目詳細

#### settings

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | value | JSON.stringify({...labs, [flag]: newValue}) | key='labs'の行を更新 |

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|---------------|---------------|----------|
| 成功 | Redirects uploaded | リダイレクトファイルアップロード成功時 |
| 成功 | Routes uploaded | ルートファイルアップロード成功時 |
| エラー | （エラー内容による） | アップロード失敗時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| ファイルアップロード失敗 | handleError関数でエラー処理、エラートースト表示 |
| 設定更新失敗 | handleError関数でエラー処理 |
| 権限不足 | 画面自体にアクセス不可（設定画面レベルで制御） |

## 備考

- Labs機能は「予告なく変更・削除される可能性がある」実験的機能である
- Private featuresタブは `enableDeveloperExperiments` 設定が有効な場合のみ表示
- 一部の機能はホスティングプランの制限（limiter）により非表示になる場合がある
- リダイレクト・ルートファイルの詳細仕様は[Ghostドキュメント](https://ghost.org/tutorials/implementing-redirects/)を参照

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Labs設定は `settings` テーブルの `labs` キーにJSON形式で保存される。各フラグ名がキー、boolean値がバリューとなる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | feature-toggle.tsx | `apps/admin-x-settings/src/components/settings/advanced/labs/feature-toggle.tsx` | labs設定の読み取り・更新ロジック（12-37行目） |

**読解のコツ**: `getSettingValue(settings, 'labs')` でJSON文字列を取得し、`JSON.parse` でオブジェクトに変換している。更新時は `JSON.stringify` で文字列に戻す。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | labs.tsx | `apps/admin-x-settings/src/components/settings/advanced/labs.tsx` | Labs画面のメインコンポーネント（12-67行目） |

**主要処理フロー**:
1. **12-15行目**: 状態管理（selectedTab）とグローバルデータ・自動展開フックの取得
2. **17-28行目**: タブ定義（Beta features、Private features）
3. **30-64行目**: TopLevelGroupコンポーネントでUI構築

#### Step 3: Beta機能コンポーネントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | beta-features.tsx | `apps/admin-x-settings/src/components/settings/advanced/labs/beta-features.tsx` | Beta機能一覧とファイルアップロード（9-84行目） |

**主要処理フロー**:
- **18-29行目**: トグル機能（superEditors、editorExcerpt、additionalPaymentMethods）
- **30-54行目**: リダイレクトファイルアップロード/ダウンロード
- **55-79行目**: ルートファイルアップロード/ダウンロード

#### Step 4: Private機能コンポーネントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | private-features.tsx | `apps/admin-x-settings/src/components/settings/advanced/labs/private-features.tsx` | Private機能一覧（14-116行目） |

**主要処理フロー**:
- **14-74行目**: features配列定義（各機能のtitle、description、flag）
- **76-114行目**: AlphaFeaturesコンポーネント（limiter制御含む）

### プログラム呼び出し階層図

```
Labs (labs.tsx)
    │
    ├─ TopLevelGroup
    │      ├─ SettingGroupHeader
    │      ├─ Button (Open/Close)
    │      └─ TabView
    │             ├─ BetaFeatures (beta-features.tsx)
    │             │      ├─ LabItem + FeatureToggle (superEditors)
    │             │      ├─ LabItem + FeatureToggle (editorExcerpt)
    │             │      ├─ LabItem + FeatureToggle (additionalPaymentMethods)
    │             │      ├─ LabItem + FileUpload (Redirects)
    │             │      └─ LabItem + FileUpload (Routes)
    │             │
    │             └─ PrivateFeatures (private-features.tsx)
    │                    └─ LabItem + FeatureToggle (各Private機能)
    │
    └─ FeatureToggle (feature-toggle.tsx)
           └─ editSettings API
```

### データフロー図

```
[入力]                    [処理]                         [出力]

トグル操作 ───────▶ FeatureToggle
                        │
                        ├─ getSettingValue('labs')
                        │
                        ├─ JSON.parse(labs)
                        │
                        ├─ labs[flag] = !labs[flag]
                        │
                        ├─ editSettings API ──────────▶ settings テーブル更新
                        │
                        └─ trackEvent ─────────────────▶ アナリティクス

ファイル選択 ─────▶ FileUpload
                        │
                        └─ uploadRedirects/uploadRoutes ──▶ ファイルシステム
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| labs.tsx | `apps/admin-x-settings/src/components/settings/advanced/labs.tsx` | ソース | Labs画面メインコンポーネント |
| beta-features.tsx | `apps/admin-x-settings/src/components/settings/advanced/labs/beta-features.tsx` | ソース | Beta機能一覧コンポーネント |
| private-features.tsx | `apps/admin-x-settings/src/components/settings/advanced/labs/private-features.tsx` | ソース | Private機能一覧コンポーネント |
| feature-toggle.tsx | `apps/admin-x-settings/src/components/settings/advanced/labs/feature-toggle.tsx` | ソース | 機能トグルコンポーネント |
| lab-item.tsx | `apps/admin-x-settings/src/components/settings/advanced/labs/lab-item.tsx` | ソース | 機能項目表示コンポーネント |
| redirects.ts | `apps/admin-x-framework/src/api/redirects.ts` | ソース | リダイレクトAPI |
| routes.ts | `apps/admin-x-framework/src/api/routes.ts` | ソース | ルートAPI |
| settings.ts | `apps/admin-x-framework/src/api/settings.ts` | ソース | 設定API |
