# 画面設計書 63-危険ゾーン

## 概要

本ドキュメントは、Ghost管理画面における「危険ゾーン（Danger zone）」画面の設計仕様を記述したものである。この画面では、サイトのすべてのコンテンツ（投稿・タグ）を完全に削除する操作を提供する。

### 本画面の処理概要

危険ゾーン画面は、Ghostサイトのデータベースから全コンテンツを削除するための管理画面である。この操作は不可逆であり、バックアップや復元手段がないため、最大限の注意を要する操作として設計されている。

**業務上の目的・背景**：サイトのリセットやテスト環境のクリーンアップ、サイト閉鎖前のデータ削除など、全コンテンツを一括削除する必要がある場面で使用される。通常の運用では使用されることは稀であり、誤操作を防ぐために確認ダイアログが設けられている。この機能により、開発・テスト目的でのデータリセットや、本番環境での完全なコンテンツクリアが可能になる。

**画面へのアクセス方法**：設定画面（Settings）から「Advanced」セクション内の「Danger zone」を選択してアクセスする。URL は `/ghost/#/settings` から「Danger zone」セクションへ遷移。

**主要な操作・処理内容**：
1. 「Delete all content」ボタンの表示
2. 確認ダイアログの表示
3. 全コンテンツ削除の実行
4. 成功/失敗メッセージの表示

**画面遷移**：設定画面のAdvancedセクションからアクセス。削除完了後は同画面に留まり、全クエリキャッシュがリフレッシュされる。

**権限による表示制御**：管理者（Owner/Administrator）権限を持つユーザーのみがこの画面にアクセスできる。エディターやコントリビューターには表示されない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 65 | データベース管理 | 主機能 | サイト削除等の危険な操作 |

## 画面種別

操作画面（単一アクション実行）

## URL/ルーティング

- パス: `/ghost/#/settings`
- ナビゲーションID: `dangerzone`
- 設定画面内の「Advanced」セクションに配置

## 入出力項目

### 入力項目

この画面には直接の入力項目はない。確認ダイアログでの「Delete」ボタン押下が唯一のユーザー入力となる。

### 出力項目

| 項目名 | データ型 | 入力/出力 | 説明 |
|--------|----------|----------|------|
| 削除成功メッセージ | string | 出力 | トースト通知として表示 |
| エラーメッセージ | string | 出力 | 削除失敗時のエラー表示 |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| Danger zone タイトル | テキスト | セクションタイトル |
| 説明文 | テキスト | 「Permanently delete all posts and tags from the database, a hard reset」 |
| Delete all content ボタン | ボタン（赤） | 全コンテンツ削除を開始するボタン |

### 確認ダイアログ

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| タイトル | テキスト | 「Would you really like to delete all content from your blog?」 |
| 説明文 | テキスト | 「This is permanent! No backups, no restores, no magic undo button. We warned you, k?」 |
| Delete ボタン | ボタン（赤） | 削除実行ボタン |
| Cancel ボタン | ボタン | キャンセルボタン |

## イベント仕様

### 1-Delete all content ボタン押下

1. 「Delete all content」ボタン（赤色）をクリック
2. NiceModal を使用して確認ダイアログ（ConfirmationModal）を表示
3. ダイアログには警告メッセージが表示される

### 2-確認ダイアログでの Delete ボタン押下

1. ダイアログ内の「Delete」ボタン（赤色）をクリック
2. `deleteAllContent(null)` API を呼び出し
3. 成功時：
   - 「All content deleted from database.」トースト表示
   - モーダルを閉じる
   - `client.refetchQueries()` で全クエリキャッシュをリフレッシュ
4. 失敗時：
   - `handleError(e)` でエラーハンドリング
   - エラートースト表示

### 3-確認ダイアログでの Cancel ボタン押下

1. ダイアログ内のキャンセル操作（ボタンまたはモーダル外クリック）
2. ダイアログを閉じる
3. 何も実行されない

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| Delete all content | posts | DELETE | 全投稿の削除 |
| Delete all content | tags | DELETE | 全タグの削除 |
| Delete all content | posts_tags | DELETE | 投稿-タグ関連の削除 |
| Delete all content | posts_authors | DELETE | 投稿-著者関連の削除 |

### テーブル別更新項目詳細

#### posts

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | 全カラム | WHERE 1=1（全件削除） | 投稿データ完全削除 |

#### tags

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | 全カラム | WHERE 1=1（全件削除） | タグデータ完全削除 |

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|---------------|---------------|----------|
| 確認 | Would you really like to delete all content from your blog? | Delete all content ボタン押下時 |
| 警告 | This is permanent! No backups, no restores, no magic undo button. We warned you, k? | 確認ダイアログ表示時 |
| 成功 | All content deleted from database. | 削除成功時（トースト） |
| エラー | （エラー内容による） | 削除失敗時（トースト） |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| API呼び出し失敗 | handleError関数でエラー処理、エラートースト表示 |
| 権限不足 | 画面自体にアクセス不可（設定画面レベルで制御） |
| ネットワークエラー | エラーハンドリングでキャッチ、エラー表示 |

## 備考

- この操作は**完全に不可逆**である。削除されたデータは復元できない
- 削除対象は投稿（posts）とタグ（tags）のみ。メンバー、設定、スタッフユーザーは削除されない
- 確認ダイアログのボタンは赤色（okColor: 'red'）で危険な操作であることを視覚的に示す
- 削除完了後、全クエリキャッシュがリフレッシュされるため、画面全体が最新状態に更新される
- API エンドポイントは `DELETE /ghost/api/admin/db/`

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

この画面で扱うデータは単純で、削除対象となるコンテンツ（posts, tags）とAPI呼び出しのみである。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | db.ts | `apps/admin-x-framework/src/api/db.ts` | deleteAllContent API定義（14-17行目） |

**読解のコツ**: `useDeleteAllContent` は `createMutation` で作成された DELETE リクエストを発行するフック。パスは `/db/` で、ボディはなし（null）。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | danger-zone.tsx | `apps/admin-x-settings/src/components/settings/advanced/danger-zone.tsx` | Danger zone画面コンポーネント（9-52行目） |

**主要処理フロー**:
1. **10-12行目**: フックの取得（deleteAllContent, queryClient, handleError）
2. **14-34行目**: `handleDeleteAllContent` 関数定義
3. **15-33行目**: NiceModal.show による確認ダイアログ表示
4. **21-28行目**: onOk コールバックでの削除実行

#### Step 3: 確認ダイアログの動作を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | danger-zone.tsx | `apps/admin-x-settings/src/components/settings/advanced/danger-zone.tsx` | ConfirmationModal設定（15-33行目） |

**主要処理フロー**:
- **16行目**: title - 確認メッセージ
- **17行目**: prompt - 警告メッセージ
- **18行目**: okColor: 'red' - 削除ボタンを赤色に
- **19行目**: okLabel: 'Delete' - ボタンラベル
- **20-32行目**: onOk - 削除実行ロジック

### プログラム呼び出し階層図

```
DangerZone (danger-zone.tsx)
    │
    └─ TopLevelGroup
           ├─ SettingGroupHeader
           │      └─ title="Danger zone", description="..."
           │
           └─ Button ("Delete all content")
                  │
                  └─ handleDeleteAllContent
                         │
                         └─ NiceModal.show(ConfirmationModal)
                                │
                                └─ onOk
                                       │
                                       ├─ deleteAllContent(null)
                                       │      └─ DELETE /ghost/api/admin/db/
                                       │
                                       ├─ showToast (成功時)
                                       │
                                       ├─ modal.remove()
                                       │
                                       └─ client.refetchQueries()
```

### データフロー図

```
[入力]                     [処理]                          [出力]

Delete all content ───▶ ConfirmationModal表示
ボタン押下
                              │
                              ▼
                        Delete ボタン押下
                              │
                              ▼
                        deleteAllContent API
                              │
                              ├─ DELETE /db/
                              │
                              ▼
                        バックエンド処理
                              │
                              ├─ posts DELETE
                              ├─ tags DELETE
                              └─ 関連テーブル DELETE
                              │
                              ▼
                        レスポンス
                              │
                              ├─ 成功 ───▶ showToast("All content deleted...")
                              │            │
                              │            └─ refetchQueries()
                              │
                              └─ 失敗 ───▶ handleError(e)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| danger-zone.tsx | `apps/admin-x-settings/src/components/settings/advanced/danger-zone.tsx` | ソース | Danger zone画面コンポーネント |
| db.ts | `apps/admin-x-framework/src/api/db.ts` | ソース | DB関連API（delete, import, export） |
| hooks.ts | `apps/admin-x-framework/src/utils/api/hooks.ts` | ソース | createMutation等のAPIフック基盤 |
| ConfirmationModal | `@tryghost/admin-x-design-system` | ライブラリ | 確認ダイアログコンポーネント |
| showToast | `@tryghost/admin-x-design-system` | ライブラリ | トースト通知表示関数 |
