# 画面設計書 7-セットアップ完了画面

## 概要

本ドキュメントは、Ghost管理画面のセットアップ完了画面の設計内容を記載する。

### 本画面の処理概要

セットアップ完了画面は、Ghostの初期セットアップが完了した後に遷移する画面である。専用のUIは持たず、オンボーディングチェックリストを開始し、管理者ユーザーの場合は即座に統計画面（ダッシュボード）へリダイレクトする。

**業務上の目的・背景**：セットアップ完了後、ユーザーがスムーズにGhostの運用を開始できるよう、オンボーディングプロセスを自動的に開始する。オーナーユーザーには4つのステップ（デザインカスタマイズ、初投稿、オーディエンス構築、公開共有）からなるチェックリストが提示され、Ghost活用のガイダンスとなる。

**画面へのアクセス方法**：セットアップ画面でのアカウント作成完了後、自動的に遷移する。直接URLアクセスは想定されていない。

**主要な操作・処理内容**：
1. オンボーディングチェックリストの開始（オーナーユーザーのみ）
2. 統計画面（ダッシュボード）への自動リダイレクト（管理者以上）

**画面遷移**：
- 遷移元：セットアップ画面（セットアップ完了後）
- 遷移先：統計画面（/ghost/stats-x）

**権限による表示制御**：認証済みユーザーのみアクセス可能。未認証の場合はサインイン画面にリダイレクト。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 35 | 一般設定 | 遷移先機能 | セットアップ完了後のダッシュボードへの遷移 |

## 画面種別

処理実行（画面なし）

## URL/ルーティング

- **URL**: `/ghost/setup/done`
- **Emberルート名**: `setup.done`
- **ルートファイル**: `ghost/admin/app/routes/setup/done.js`

## 入出力項目

本画面は専用UIを持たないため、入出力項目は存在しない。

## 表示項目

本画面は専用UIを持たず、即座にリダイレクトするため、表示項目は存在しない。

## イベント仕様

### 1-ルートアクセス時の自動処理

**トリガー**: `/ghost/setup/done`へのルート遷移

**処理フロー**:
1. `AuthenticatedRoute.beforeModel`で認証チェック
2. オーナーユーザーの場合、`onboarding.startChecklist()`を実行
3. ユーザーのaccessibility設定にオンボーディング状態を保存
4. 管理者ユーザーの場合、統計画面（stats-x）へリダイレクト

**遷移先**:
- 管理者以上: `/ghost/stats-x` (統計画面)

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| オンボーディング開始 | users | UPDATE | accessibilityカラムにオンボーディング状態を保存 |

### テーブル別更新項目詳細

#### users

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | accessibility | JSON（onboarding設定） | checklistState: 'started', completedSteps: [] |

## メッセージ仕様

本画面は専用UIを持たないため、メッセージは表示されない。

## 例外処理

| 例外ケース | 対応処理 | 表示内容 |
|-----------|----------|----------|
| 未認証状態でアクセス | サインイン画面へリダイレクト | - |
| オンボーディング保存失敗 | エラーログ出力（UIには影響なし） | - |

## 備考

- セットアップ完了画面は「画面」というよりは「遷移ポイント」としての役割
- オンボーディングチェックリストはオーナーユーザーのみに表示される
- チェックリストの4ステップ：
  1. customize-design：デザインのカスタマイズ
  2. first-post：最初の投稿を作成
  3. build-audience：オーディエンスの構築
  4. share-publication：公開の共有
- オンボーディング状態はユーザーのaccessibility JSON項目に保存される
- チェックリストは完了（completed）または非表示（dismissed）にできる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: ルートの処理を理解する

セットアップ完了ルートの実装を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | done.js | `ghost/admin/app/routes/setup/done.js` | beforeModelでのオンボーディング開始とリダイレクト |

**主要処理フロー**:
- **16-18行目**: オーナーユーザーの場合、オンボーディングチェックリスト開始
- **20-22行目**: 管理者の場合、stats-xへリダイレクト

#### Step 2: オンボーディングサービスを理解する

オンボーディングの状態管理を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | onboarding.js | `ghost/admin/app/services/onboarding.js` | startChecklist、状態管理、ステップ定義 |

**主要処理フロー**:
- **4-7行目**: EMPTY_SETTINGSでデフォルト状態定義
- **12-17行目**: ONBOARDING_STEPSで4つのステップ定義
- **62-70行目**: startChecklistでチェックリスト開始
- **118-125行目**: _saveSettingsでユーザーのaccessibilityに保存

### プログラム呼び出し階層図

```
SetupFinishingTouchesRoute.beforeModel
    │
    ├─ AuthenticatedRoute.beforeModel (認証チェック)
    │
    ├─ [オーナーユーザーの場合]
    │      └─ onboarding.startChecklist
    │             └─ _saveSettings
    │                    └─ session.user.save
    │                           └─ PUT /users/{id}
    │                                  └─ users.accessibility更新
    │
    └─ [管理者の場合]
           └─ router.transitionTo('stats-x')
```

### データフロー図

```
[入力]                      [処理]                              [出力]

セットアップ完了 ──────▶ /ghost/setup/done ────────────────▶ stats-x画面へ
                              │                              リダイレクト
                              │
                              ▼
                    [オーナーユーザー?]
                              │
                        ┌─────┴─────┐
                        │           │
                      Yes          No
                        │           │
                        ▼           ▼
              startChecklist   (スキップ)
                        │
                        ▼
                    users テーブル
                    accessibility UPDATE
                    (onboarding設定)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| done.js | `ghost/admin/app/routes/setup/done.js` | ルート | セットアップ完了処理 |
| onboarding.js | `ghost/admin/app/services/onboarding.js` | サービス | オンボーディング状態管理 |
| authenticated.js | `ghost/admin/app/routes/authenticated.js` | ルート（親） | 認証済みルートの基底クラス |
