# 画面設計書 70-ActivityPub設定画面

## 概要

本ドキュメントは、Ghost管理画面における「ActivityPub設定画面（Preferences）」の設計仕様を記述したものである。この画面では、ActivityPub機能に関する各種設定（プロフィール編集、モデレーション、Bluesky連携等）を管理できる。

### 本画面の処理概要

ActivityPub設定画面は、ソーシャルウェブ機能の各種設定を一元管理するための設定ビューである。プロフィール情報の確認・編集、モデレーション設定、外部サービス連携（Bluesky）、ヘルプリンクへのアクセスが可能。

**業務上の目的・背景**：ActivityPub機能を利用する上で、プロフィールの設定やモデレーションルールの管理は重要である。この画面により、ソーシャルウェブでの活動に必要な各種設定を一か所で行える。Bluesky連携により、コンテンツの自動共有も設定できる。

**画面へのアクセス方法**：Ghost管理画面のサイドバーから「Social」セクションへアクセスし、プロフィール画面などから「Settings」を選択、または直接URLでアクセス。URL は `/ghost/#/activitypub/preferences`。

**主要な操作・処理内容**：
1. プロフィール情報の確認
2. プロフィール編集ダイアログの表示
3. モデレーション設定画面への遷移
4. Bluesky共有設定画面への遷移
5. ヘルプリンクへのアクセス

**画面遷移**：サイドバーからアクセス。各設定項目クリックで詳細設定画面へ遷移。

**権限による表示制御**：ActivityPub機能が有効化されている場合にのみ表示される。スタッフユーザーがアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 57 | ActivityPub | 主機能 | ActivityPub設定の管理 |

## 画面種別

設定画面（ナビゲーションリスト）

## URL/ルーティング

- メインパス: `/ghost/#/activitypub/preferences`
- モデレーション: `/ghost/#/activitypub/preferences/moderation`
- Bluesky共有: `/ghost/#/activitypub/preferences/bluesky-sharing`
- ページタイトル: 「Preferences」

## 入出力項目

この画面はナビゲーション的な役割であり、直接の入力項目はない。各サブ画面（モデレーション、Bluesky共有、プロフィール編集）で具体的な設定を行う。

## 表示項目

### プロフィールセクション

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| アバター | 画像 | 現在のプロフィールアバター |
| 名前 | テキスト | アカウント表示名 |
| ハンドル | テキスト | @username@domain形式 |
| カバー画像 | 画像 | プロフィールのカバー/バナー画像 |

### 設定項目一覧

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| Account | 設定項目 | プロフィール情報の編集 |
| Moderation | 設定項目 | ブロックしたユーザー・ドメインの管理 |
| Bluesky sharing | 設定項目 | Bluesky連携の設定（On/Off表示） |
| Help | 設定項目 | ソーシャルウェブのガイド・サポートリソースへのリンク |

## イベント仕様

### 1-Account設定クリック

1. 「Account」設定項目のEdit profileボタンをクリック
2. `isEditingProfile` を true に設定
3. EditProfileダイアログを開く
4. プロフィール情報を編集
5. 保存でAPIを呼び出し
6. 成功時：ダイアログを閉じ、プロフィールを更新
7. 失敗時：エラートースト表示

### 2-Moderation設定クリック

1. 「Moderation」設定項目をクリック
2. `navigate('/preferences/moderation')` を実行
3. モデレーション設定画面へ遷移

### 3-Bluesky sharing設定クリック

1. 「Bluesky sharing」設定項目をクリック
2. `navigate('/preferences/bluesky-sharing')` を実行
3. Bluesky共有設定画面へ遷移

### 4-Help設定クリック

1. 「Help」設定項目をクリック
2. 外部リンク `https://ghost.org/help/social-web/` を新しいタブで開く

## データベース更新仕様

### 操作別データベース影響一覧

この画面からの直接的なGhostデータベース更新はなし。プロフィール編集時はActivityPub APIを経由。

| 操作（イベント） | 対象 | 操作種別 | 概要 |
|----------------|------|---------|------|
| プロフィール取得 | ActivityPub API | GET | アカウント情報の取得 |
| プロフィール更新 | ActivityPub API | PATCH | プロフィール編集 |

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|---------------|---------------|----------|
| - | - | この画面固有のメッセージはなし |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| API エラー | AppError コンポーネントでエラーコード・ステータスコードを表示 |
| ネットワークエラー | ローディング表示継続 |

## 備考

- この画面はナビゲーションハブとして機能し、詳細設定は各サブ画面で行う
- Bluesky sharing の状態（On/Off）は `account.blueskyEnabled` で判定
- モデレーション、Bluesky共有の各設定画面は `showBackButton: true` で戻るボタンが表示される
- 外部リンク（Help）は新しいタブで開く（`target='_blank'`）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

設定画面では `Account` 型の情報と、関連する設定状態を扱う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | activitypub.ts | `apps/activitypub/src/api/activitypub.ts` | Account型、blueskyEnabledプロパティ |

**読解のコツ**: `Account.blueskyEnabled` でBluesky連携の有効状態を確認できる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | preferences.tsx | `apps/activitypub/src/views/preferences/preferences.tsx` | Preferencesコンポーネント（9-26行目） |

**主要処理フロー**:
1. **10行目**: `useAccountForUser` でアカウント情報取得
2. **12-14行目**: エラーハンドリング
3. **16-25行目**: Layout内にProfile・Settings配置

#### Step 3: 設定一覧コンポーネントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | settings.tsx | `apps/activitypub/src/views/preferences/components/settings.tsx` | Settingsコンポーネント（13-67行目） |

**主要処理フロー**:
- **14-15行目**: 編集状態とナビゲーションの管理
- **20-37行目**: Account設定項目（EditProfileダイアログ付き）
- **39-47行目**: Moderation設定項目（ナビゲーション付き）
- **48-57行目**: Bluesky sharing設定項目（状態表示付き）
- **59-65行目**: Help設定項目（外部リンク）

#### Step 4: プロフィール編集コンポーネントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | edit-profile.tsx | `apps/activitypub/src/views/preferences/components/edit-profile.tsx` | EditProfileコンポーネント |

**主要処理フロー**:
- フォームによるプロフィール情報編集
- アバター・カバー画像のアップロード
- 保存処理とAPI呼び出し

### プログラム呼び出し階層図

```
Preferences (preferences.tsx)
    │
    ├─ useAccountForUser('me')
    │      └─ GET /accounts/me
    │
    ├─ Layout
    │
    ├─ Profile (profile.tsx)
    │      ├─ アバター表示
    │      ├─ 名前・ハンドル表示
    │      └─ カバー画像表示
    │
    └─ Settings (settings.tsx)
           │
           ├─ SettingItem: Account
           │      ├─ Dialog (EditProfile)
           │      │      └─ EditProfile
           │      │             ├─ アバター編集
           │      │             ├─ カバー編集
           │      │             ├─ 名前編集
           │      │             └─ バイオ編集
           │      │
           │      └─ Button: Edit profile
           │
           ├─ SettingItem: Moderation
           │      └─ onClick → navigate('/preferences/moderation')
           │
           ├─ SettingItem: Bluesky sharing
           │      ├─ 状態表示 (On/Off)
           │      └─ onClick → navigate('/preferences/bluesky-sharing')
           │
           └─ SettingItem: Help
                  └─ href → ghost.org/help/social-web/ (外部リンク)
```

### データフロー図

```
[入力]                     [処理]                          [出力]

ページロード ────────▶ useAccountForUser('me')
                            │
                            └─ GET /accounts/me
                                   │
                                   └─ Account ─────────────▶ Profile表示
                                          │
                                          └─ blueskyEnabled ─▶ Bluesky状態表示

Edit profile ───────▶ isEditingProfile = true
                            │
                            └─ EditProfile Dialog表示
                                   │
                                   └─ 保存 ────────────────▶ PATCH /accounts/me

Moderation click ───▶ navigate('/preferences/moderation')

Bluesky click ──────▶ navigate('/preferences/bluesky-sharing')

Help click ─────────▶ window.open('https://ghost.org/help/social-web/')
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| preferences.tsx | `apps/activitypub/src/views/preferences/preferences.tsx` | ソース | Preferencesメインコンポーネント |
| settings.tsx | `apps/activitypub/src/views/preferences/components/settings.tsx` | ソース | 設定一覧コンポーネント |
| profile.tsx | `apps/activitypub/src/views/preferences/components/profile.tsx` | ソース | プロフィール表示コンポーネント |
| edit-profile.tsx | `apps/activitypub/src/views/preferences/components/edit-profile.tsx` | ソース | プロフィール編集コンポーネント |
| moderation.tsx | `apps/activitypub/src/views/preferences/components/moderation.tsx` | ソース | モデレーション設定画面 |
| bluesky-sharing.tsx | `apps/activitypub/src/views/preferences/components/bluesky-sharing.tsx` | ソース | Bluesky共有設定画面 |
| use-activity-pub-queries.ts | `apps/activitypub/src/hooks/use-activity-pub-queries.ts` | ソース | ActivityPub APIフック |
| routes.tsx | `apps/activitypub/src/routes.tsx` | ソース | ルーティング定義 |
