# 画面設計書 75-Explore接続画面

## 概要

本ドキュメントは、Ghost Exploreへの接続画面の設計書です。

### 本画面の処理概要

この画面は、GhostサイトをGhost Exploreディレクトリサービスに接続するための画面です。サイトデータへの読み取り専用アクセスを許可し、Exploreディレクトリへの掲載を開始するプロセスを管理します。

**業務上の目的・背景**：Ghost Exploreへのサイト登録は、Ghostエコシステム全体でサイトの露出を高めるマーケティング手段です。本画面は、サイト管理者がExploreへの接続を承認し、必要な認証情報（トークン）を送信するためのインターフェースを提供します。接続後、サイトはGhost Exploreのディレクトリに掲載され、Ghost全体のユーザーからアクセス可能になります。

**画面へのアクセス方法**：Explore画面から「Connect」アクションを選択、またはURLに直接 `/explore/connect` と入力してアクセスします。

**主要な操作・処理内容**：
1. Exploreへの接続許可の説明表示
2. 「Connect data & edit listing」ボタンでの接続処理
3. 接続完了後のExplore画面への遷移

**画面遷移**：
- 遷移元：Explore画面
- 遷移先：Ghost Explore（外部サービス）、統計画面（/stats-x）

**権限による表示制御**：認証済みユーザーのみがアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 91 | Explore連携 | 主機能 | Ghost Exploreへの接続処理 |

## 画面種別

接続・認可

## URL/ルーティング

- パス: `/explore/connect`
- ルート定義: `ghost/admin/app/routes/explore/connect.js`

## 入出力項目

| 項目名 | 入出力 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| apiUrl | 出力 | string | - | サイトのAPI URL |
| token | 出力 | string | - | ghost-exploreインテグレーションの認証トークン |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| Ghost Orbロゴ | image | Ghostピンクオーブアイコン |
| ヘッドライン | string | "Connect to Ghost Explore." |
| API URL | string | サイトのAPI URL表示 |
| 許可説明1 | string | サイトデータへの読み取り専用アクセス |
| 許可説明2 | string | 公開/非公開データの選択可能 |
| 許可説明3 | string | Ghostエコシステム全体での宣伝 |
| 接続ボタン | - | "Connect data & edit listing" |
| 閉じるボタン | - | 画面を閉じる |

## イベント仕様

### 1-接続画面表示

- トリガー: `/explore/connect` ルートへのアクセス
- 処理:
  1. `beforeModel()` で `explore.toggleExploreWindow(false)` を実行
  2. iframe表示を閉じて接続画面を表示
  3. インテグレーション情報を取得（親ルートから継承）

### 2-サイト接続

- トリガー: 「Connect data & edit listing」ボタンクリック
- 処理（iframe遷移モード）:
  1. ghost-exploreインテグレーションからトークンを取得
  2. クエリパラメータを構築（token, url）
  3. `explore.sendRouteUpdate()` でiframeにルート更新を送信
  4. 500ms後に `explore.toggleExploreWindow(true)` でiframeを表示

- 処理（外部遷移モード）:
  1. ghost-exploreインテグレーションからトークンを取得
  2. Ghost Explore URLを構築（submit route + クエリパラメータ）
  3. `window.location` で外部サイトへ遷移

### 3-画面クローズ

- トリガー: 閉じるボタン（×）クリック
- 処理（iframe遷移モード）:
  1. `explore.sendRouteUpdate({path: '/explore'})` を送信
  2. `/explore` へ遷移

- 処理（外部遷移モード）:
  1. `/stats-x` へ遷移

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | integrations | SELECT | ghost-exploreインテグレーションの取得 |

※ 実際のサイト登録はGhost Exploreサービス側で処理

## メッセージ仕様

| 種別 | メッセージ | 表示タイミング |
|------|-----------|---------------|
| 情報 | Connect to Ghost Explore. | 画面ヘッドライン |
| 情報 | Allow read-only access to your site data to create a directory listing. | 許可説明1 |
| 情報 | You'll be able to choose what data is shown publicly or hidden. | 許可説明2 |
| 情報 | Your site will be promoted across the entire Ghost ecosystem. | 許可説明3 |

## 例外処理

| 例外状況 | 対応内容 |
|---------|---------|
| インテグレーション未設定 | エラー（ghost-exploreインテグレーションが必須） |
| 接続失敗 | Ghost Exploreサービス側のエラー処理に依存 |

## 備考

- ghost-exploreインテグレーションのadminKeyを使用して認証
- iframeモードと外部遷移モードの2つの動作パターンがある
- iframeモードでは500msの遅延後にiframeを表示（Exploreの読み込み待ち）
- 接続後はGhost Explore側でサイト情報の編集が可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、プログラム間で受け渡されるデータ構造を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | integration model | `ghost/admin/app/models/integration.js` | Integrationモデルの構造、api_keysプロパティ |

**読解のコツ**: `ghost-explore`スラッグを持つインテグレーションの`adminKey.secret`がトークンとして使用されます。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | connect.js (route) | `ghost/admin/app/routes/explore/connect.js` | ルート定義とbeforeModel |
| 2-2 | connect.hbs | `ghost/admin/app/templates/explore/connect.hbs` | テンプレート構造 |

**主要処理フロー**:
1. **connect.js L3-4**: ExploreRouteを継承、コントローラー名を'explore'に設定
2. **connect.js L6-8**: beforeModelでiframeを閉じる
3. **connect.hbs L3-6**: 閉じるボタン
4. **connect.hbs L9-28**: 接続説明とパーミッション表示
5. **connect.hbs L30-32**: 接続ボタン

#### Step 3: コントローラーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | explore.js (controller) | `ghost/admin/app/controllers/explore.js` | 接続処理の実装 |

**主要処理フロー**:
- **L11-16**: `exploreCredentials` - トークンの取得
- **L18-20**: `visibilityClass` - 表示状態クラスの決定
- **L22-29**: `closeConnect` - 画面クローズ処理
- **L31-57**: `submitExploreSite` - サイト接続処理

### プログラム呼び出し階層図

```
ExploreConnectRoute (Ember Route)
    |
    +-- beforeModel()
    |       +-- explore.toggleExploreWindow(false)
    |
    +-- ExploreController
            |
            +-- exploreCredentials (getter)
            |       +-- model.findBy('slug', 'ghost-explore')
            |       +-- explore.adminKey.secret
            |
            +-- closeConnect()
            |       +-- (iframe mode) explore.sendRouteUpdate({path: '/explore'})
            |       +-- (iframe mode) router.transitionTo('/explore')
            |       +-- (external mode) router.transitionTo('/stats-x')
            |
            +-- submitExploreSite()
                    +-- (build query params: token, url)
                    +-- (iframe mode) explore.sendRouteUpdate({path, queryParams})
                    +-- (iframe mode) setTimeout -> explore.toggleExploreWindow(true)
                    +-- (external mode) window.location = destination.toString()
```

### データフロー図

```
[入力]                    [処理]                              [出力]

/explore/connect アクセス
    |
    +-- ExploreRoute継承 --> model() (親から継承) -----> integrations取得
    |
    +-- beforeModel() ----> toggleExploreWindow(false) --> iframe非表示
                                 |
                                 +-- connect.hbs表示
                                        |
Connect ボタンクリック
    |
    +-- submitExploreSite() --> exploreCredentials -----> token取得
                                 |
                                 +-- URL構築 (token + apiUrl)
                                        |
                                        +-- (iframe) sendRouteUpdate + toggleWindow
                                        |
                                        +-- (external) window.location遷移
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| connect.js | `ghost/admin/app/routes/explore/connect.js` | ソース | 接続画面ルート定義 |
| connect.hbs | `ghost/admin/app/templates/explore/connect.hbs` | テンプレート | 接続画面テンプレート |
| explore.js (controller) | `ghost/admin/app/controllers/explore.js` | ソース | Exploreコントローラー（接続処理） |
| explore.js (route) | `ghost/admin/app/routes/explore.js` | ソース | 親ルート（モデル取得） |
| explore.js (service) | `ghost/admin/app/services/explore.js` | ソース | Exploreサービス（iframe制御） |
