# 画面設計書 77-Pro画面

## 概要

本ドキュメントは、Ghost Pro機能画面の設計書です。

### 本画面の処理概要

この画面は、Ghost Pro（マネージドホスティングサービス）の請求・アップグレード機能を提供します。外部の請求管理アプリケーション（Billing Management Application）をiframeで埋め込み、プラン変更、支払い情報管理、請求履歴の確認などを行います。

**業務上の目的・背景**：Ghost Proは、Ghostのマネージドホスティングサービスです。本画面は、Ghost Proユーザーが請求情報の確認、プランのアップグレード・ダウングレード、支払い方法の変更などを行うためのインターフェースを提供します。Force Upgrade状態（制限超過等）の場合、非オーナーユーザーもアクセス可能になり、アップグレードを促します。

**画面へのアクセス方法**：管理画面のメニューから「View Billing」を選択するか、URLに直接 `/pro` と入力してアクセスします。

**主要な操作・処理内容**：
1. 請求情報の確認
2. プランの変更（アップグレード/ダウングレード）
3. 支払い方法の管理
4. 請求履歴の確認
5. 使用量制限の更新

**画面遷移**：
- 遷移元：管理画面のナビゲーション、Force Upgrade通知
- 遷移先：各種管理画面（iframe内操作完了後）

**権限による表示制御**：通常はオーナーのみがアクセス可能です。ただし、Force Upgrade状態の場合は全ユーザーがアクセス可能になります。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 69 | 制限管理 | 主機能 | Ghost Pro機能の案内・アップグレード |

## 画面種別

iframe埋め込み（外部サービス連携）

## URL/ルーティング

- パス: `/pro`
- パス（アクション指定）: `/pro?action=checkout`
- ルート定義: `ghost/admin/app/routes/pro.js`

## 入出力項目

| 項目名 | 入出力 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| action | 入力 | string | - | 実行するアクション（checkout等） |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| billing-frame | iframe | 請求管理アプリケーション埋め込みiframe |

## イベント仕様

### 1-Pro画面表示

- トリガー: `/pro` ルートへのアクセス
- 前提条件: ユーザーがオーナー、またはForce Upgrade状態
- 処理:
  1. `beforeModel()` で権限チェック
  2. 条件を満たさない場合はホーム画面へリダイレクト
  3. `previousTransition` に遷移情報を保存
  4. `model()` でactionパラメータを処理
  5. `toggleProWindow(true)` でiframeを表示

### 2-ルート更新送信

- トリガー: actionパラメータ（例: checkout）が指定されている場合
- 処理:
  1. `billing.action` にアクションを設定
  2. `sendRouteUpdate()` でiframeにルート更新を送信
  3. checkoutアクションの場合、チェックアウトページへ遷移

### 3-画面遷移時のウィンドウ制御

- トリガー: 他のルートへの遷移
- 処理:
  1. `willTransition` アクションで遷移先を確認
  2. `/pro` への遷移でない場合は `toggleProWindow(false)` でiframeを非表示

### 4-iframe内ルート変更

- トリガー: iframe内でのナビゲーション（postMessage経由）
- 処理:
  1. `handleRouteChangeInIframe()` でルート情報を受信
  2. ブラウザの履歴を更新（`window.history.replaceState`）
  3. Ghost Admin側のURLを同期

### 5-使用量制限の更新

- トリガー: iframe内での操作完了後
- 処理:
  1. `sendUpdateLimits()` でiframeに制限更新リクエストを送信
  2. Billing appが最新の使用量を取得

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| オーナー情報取得 | users | SELECT | オーナーユーザー情報の取得 |

※ 実際の請求処理は外部のBilling Management Applicationで処理

## メッセージ仕様

本画面固有のメッセージはありません（iframeコンテンツはBilling Management Applicationが管理）。

## 例外処理

| 例外状況 | 対応内容 |
|---------|---------|
| 非オーナーかつForce Upgrade状態でない | ホーム画面へリダイレクト |
| Billing URL未設定 | 画面が正常に表示されない（設定エラー） |
| iframe読み込みエラー | Billing Management Application側のエラー処理に依存 |

## 備考

- Billing Management Application（BMA）は外部サービスとして動作
- postMessage APIを使用してiframeとの通信を実現
- ルーティングはGhost AdminとBMA間で同期される
- Force Upgrade状態では全ユーザーがアクセス可能（アップグレード促進のため）
- pageTitle は 'Ghost(Pro)' として設定

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、プログラム間で受け渡されるデータ構造を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | billing.js (service) | `ghost/admin/app/services/billing.js` | BillingServiceの状態管理プロパティ |

**読解のコツ**: `billingWindowOpen`, `action`, `previousRoute`, `ownerUser` の追跡プロパティが重要です。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | pro.js (route) | `ghost/admin/app/routes/pro.js` | ルート定義と権限チェック |

**主要処理フロー**:
1. **L12-14**: queryParamsの定義（action）
2. **L16-24**: beforeModelで権限チェック
3. **L26-32**: modelでアクション設定とウィンドウ表示
4. **L35-51**: willTransitionでウィンドウ制御
5. **L53-57**: buildRouteInfoMetadataでタイトル設定

#### Step 3: サービス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | billing.js (service) | `ghost/admin/app/services/billing.js` | 請求サービスの実装 |

**主要処理フロー**:
- **L12**: billingRouteRoot定義（'#/pro'）
- **L14-18**: 追跡プロパティ（billingWindowOpen, subscription, previousRoute, action, ownerUser）
- **L20-29**: postMessageリスナーの設定
- **L31-43**: handleRouteChangeInIframe - iframe内ルート変更ハンドラー
- **L50-65**: getIframeURL - iframe URL生成
- **L67-80**: getOwnerUser - オーナーユーザー取得
- **L82-97**: sendRouteUpdate - ルート更新送信
- **L99-108**: sendUpdateLimits - 使用量制限更新リクエスト
- **L110-122**: toggleProWindow - ウィンドウ表示制御
- **L124-147**: openBillingWindow - ウィンドウオープン処理

### プログラム呼び出し階層図

```
ProRoute (Ember Route)
    |
    +-- beforeModel()
    |       +-- session.user.isOwnerOnly check
    |       +-- config.hostSettings.forceUpgrade check
    |       +-- (if not authorized) transitionTo('home')
    |       +-- billing.previousTransition = transition
    |
    +-- model(params)
    |       +-- (if action) billing.action = params.action
    |       +-- billing.toggleProWindow(true)
    |
    +-- willTransition(transition)
    |       +-- check destination URL
    |       +-- (if not /pro) billing.toggleProWindow(false)
    |
    +-- BillingService
            |
            +-- getIframeURL()
            |       +-- getOwnerUser()
            |       +-- config.hostSettings.billing.url
            |
            +-- toggleProWindow(value)
            |       +-- sendRouteUpdate()
            |       +-- billingWindowOpen = value
            |
            +-- handleRouteChangeInIframe(route)
                    +-- window.history.replaceState()
```

### データフロー図

```
[入力]                    [処理]                              [出力]

/pro?action=checkout アクセス
    |
    +-- isOwnerOnly/forceUpgrade チェック --> (unauthorized) --> /home
    |
    +-- (authorized) --> model() -----------------------> action設定
                             |
                             +-- toggleProWindow(true) --> iframe表示
                                     |
                                     +-- sendRouteUpdate() --> checkout遷移
                                             |
                                             +-- postMessage <--> BMA
                                                     |
willTransition                                       |
    |                                               |
    +-- (not /pro) --> toggleProWindow(false) --> iframe非表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| pro.js | `ghost/admin/app/routes/pro.js` | ソース | Proルート定義 |
| billing.js | `ghost/admin/app/services/billing.js` | ソース | 請求サービス（iframe制御） |
