# 画面設計書 8-ホーム画面

## 概要

本ドキュメントは、Ghost管理画面のホーム画面の設計内容を記載する。

### 本画面の処理概要

ホーム画面は、Ghost管理画面のエントリーポイントとして機能するルーティング画面である。専用のUIは持たず、ログインユーザーのロールに応じて適切なダッシュボード画面へ自動的にリダイレクトする。

**業務上の目的・背景**：Ghostはユーザーのロール（Owner、Administrator、Editor、Author、Contributor）に応じて異なる権限と責務がある。ホーム画面はこれらのロールに適したデフォルト画面へユーザーを誘導し、効率的なワークフローを実現する。管理者は全体統計を、コントリビューターは投稿管理を、その他のユーザーはサイトプレビューを最初に見ることになる。

**画面へのアクセス方法**：
- ログイン成功後の自動遷移
- 管理画面ルート（`/ghost/`）への直接アクセス
- ナビゲーション内の「Home」リンク

**主要な操作・処理内容**：
1. ユーザーロールの判定
2. ロールに応じた適切な画面へのリダイレクト
3. firstStartパラメータがある場合はオンボーディングを開始

**画面遷移**：
- 遷移元：ログイン成功、直接アクセス
- 遷移先：
  - 管理者（Owner/Administrator）：統計画面（/ghost/stats-x）
  - コントリビューター：投稿一覧画面（/ghost/posts）
  - その他（Editor/Author）：サイト画面（/ghost/site）
  - firstStart=true：セットアップ完了画面（/ghost/setup/done）

**権限による表示制御**：認証済みユーザーのみアクセス可能。ロールに応じてリダイレクト先が異なる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 51 | サイト統計 | 主機能 | サイト全体の統計情報のダッシュボード表示 |
| 53 | メンバー分析 | 補助機能 | メンバー数・収益のサマリー表示 |
| 1 | 記事管理 | 遷移先機能 | 最新記事一覧へのナビゲーション |

## 画面種別

ルーティング（リダイレクト専用）

## URL/ルーティング

- **URL**: `/ghost/` または `/ghost/home`
- **Emberルート名**: `home`
- **ルートファイル**: `ghost/admin/app/routes/home.js`

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 入力/出力 | バリデーション | 備考 |
|--------|--------|-----|------|----------|---------------|------|
| 初回起動フラグ | firstStart | string | 任意 | URL Query | 'true'のみ有効 | オンボーディング開始トリガー |

## 表示項目

本画面は専用UIを持たず、即座にリダイレクトするため、表示項目は存在しない。

## イベント仕様

### 1-ルートアクセス時の自動リダイレクト

**トリガー**: `/ghost/`または`/ghost/home`へのアクセス

**処理フロー**:
1. `AuthenticatedRoute.beforeModel`で認証チェック
2. `firstStart=true`クエリパラメータがある場合、setup.doneへ遷移
3. ユーザーが管理者（isAdmin）の場合、stats-xへ遷移
4. ユーザーがコントリビューター（isContributor）の場合、postsへ遷移
5. その他のユーザーの場合、siteへ遷移

**遷移先**:
- firstStart=true: `/ghost/setup/done`
- 管理者: `/ghost/stats-x`
- コントリビューター: `/ghost/posts`
- その他: `/ghost/site`

## データベース更新仕様

本画面はリダイレクト専用のため、データベース更新は行わない。

## メッセージ仕様

本画面は専用UIを持たないため、メッセージは表示されない。

## 例外処理

| 例外ケース | 対応処理 | 表示内容 |
|-----------|----------|----------|
| 未認証状態でアクセス | サインイン画面へリダイレクト | - |
| セッション無効 | サインイン画面へリダイレクト | - |

## 備考

- ホーム画面はGhost管理画面のデフォルトランディングページ
- `/ghost/`へのアクセスは内部的にhomeルートとして処理される
- ユーザーロールによるリダイレクト先：
  - **Owner/Administrator (isAdmin=true)**: 統計画面 - サイト全体の分析が主な関心事
  - **Contributor (isContributor=true)**: 投稿一覧 - 記事執筆が主な関心事
  - **Editor/Author**: サイト画面 - コンテンツプレビューが主な関心事
- firstStartパラメータは初回セットアップ完了後にオンボーディングを開始するために使用

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: ルートの処理を理解する

ホームルートの実装を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | home.js | `ghost/admin/app/routes/home.js` | beforeModelでのロール判定とリダイレクト |

**主要処理フロー**:
- **15-17行目**: firstStartパラメータでsetup.doneへリダイレクト
- **19-20行目**: 管理者（isAdmin）でstats-xへリダイレクト
- **21-22行目**: コントリビューター（isContributor）でpostsへリダイレクト
- **23-25行目**: その他でsiteへリダイレクト

#### Step 2: ユーザーモデルのロール判定を理解する

ユーザーのロール判定プロパティを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | user.js | `ghost/admin/app/models/user.js` | isAdmin、isContributor等のcomputed property |

### プログラム呼び出し階層図

```
HomeRoute.beforeModel
    │
    ├─ AuthenticatedRoute.beforeModel (認証チェック)
    │
    ├─ [firstStart=true?]
    │      └─ router.transitionTo('setup.done')
    │
    ├─ [isAdmin?]
    │      └─ router.transitionTo('stats-x')
    │
    ├─ [isContributor?]
    │      └─ router.transitionTo('posts')
    │
    └─ [その他]
           └─ router.transitionTo('site')
```

### データフロー図

```
[入力]                      [処理]                              [出力]

/ghost/ ─────────────────▶ HomeRoute.beforeModel ──────────▶ リダイレクト
(+firstStart?)                  │
                               │
                    ┌──────────┼──────────┐
                    │          │          │
              firstStart    isAdmin   isContributor
                 =true        ?           ?
                    │          │          │
                    ▼          ▼          ▼
               setup/done   stats-x     posts
                                          │
                                    [その他]
                                          │
                                          ▼
                                        site
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| home.js | `ghost/admin/app/routes/home.js` | ルート | ホーム画面ルーティング |
| authenticated.js | `ghost/admin/app/routes/authenticated.js` | ルート（親） | 認証済みルートの基底クラス |
| user.js | `ghost/admin/app/models/user.js` | モデル | ユーザーモデル（ロール判定） |
| router.js | `ghost/admin/app/router.js` | ルーター | ルート定義 |
