# 画面設計書 80-アカウントホームページ

## 概要

本ドキュメントは、Portal（公開会員ポータル）におけるアカウントホームページの設計書です。

### 本画面の処理概要

この画面は、ログイン済み会員のアカウント管理ダッシュボードです。プロフィール情報の確認・編集、購読状態の確認、プラン変更、メール設定などへのアクセスを提供します。

**業務上の目的・背景**：Ghost Portalの会員向け中心画面として、本画面は会員が自身のアカウント情報を一元管理できるハブを提供します。無料・有料会員ともに、プロフィールの編集、購読状態の確認、メール配信設定の変更などを行えます。有料会員はさらにプランの変更やキャンセルなどの操作が可能です。

**画面へのアクセス方法**：ログイン後に自動遷移、またはPortalウィジェットで「Account」を選択してアクセスします。未ログイン時はサインインページへリダイレクトされます。

**主要な操作・処理内容**：
1. アカウント情報（名前、メールアドレス）の確認
2. プロフィール編集ページへの遷移
3. 購読状態の確認
4. プラン変更ページへの遷移（有料会員）
5. メール設定ページへの遷移
6. サインアウト
7. サポートへの問い合わせ

**画面遷移**：
- 遷移元：サインインページ、マジックリンクからのログイン
- 遷移先：プロフィール編集ページ、プラン選択ページ、メール設定ページ
- その他：サインアウト処理

**権限による表示制御**：メンバーシップ機能が無効の場合、自動的にサインアウトされます。ログインしていない場合はサインインページへリダイレクトされます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 10 | メンバープロフィール | 主機能 | 会員アカウント情報の表示 |
| 18 | サブスクリプション管理 | 補助機能 | 購読状態の表示 |
| 71 | Portal | 補助機能 | Portalウィジェット内でのUI表示 |

## 画面種別

ダッシュボード（会員アカウント管理）

## URL/ルーティング

- ページ識別子: `accountHome`
- Portal内パス: `#/portal/account`
- ルート定義: `apps/portal/src/pages.js`

## 入出力項目

該当なし（表示のみ、ナビゲーション画面）

## 表示項目

### ユーザーヘッダー

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| アバター | image | ユーザーのプロフィール画像 |
| 名前 | string | ユーザーの表示名 |
| メールアドレス | string | ユーザーのメールアドレス |

### アカウントウェルカム

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| ウェルカムメッセージ | string | 購読状態に応じたメッセージ |
| サブスクリプション情報 | - | 有料プランの場合はプラン詳細 |

### アカウントアクション

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| プロフィール編集 | link | プロフィール編集ページへのリンク |
| 購読継続ボタン | button | キャンセル済み購読の継続（該当時） |
| プラン変更 | link | プラン変更ページへのリンク（有料会員） |
| メール設定 | link | メール設定ページへのリンク |

### フッター

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| 閉じるボタン | button | Portalを閉じる |
| サインアウト | link | サインアウト処理 |
| サポートリンク | link | サポートへの問い合わせ |

## イベント仕様

### 1-ページ表示時チェック

- トリガー: `componentDidMount()`
- 処理:
  1. `isSigninAllowed({site})` でメンバーシップ確認
  2. 無効の場合は `doAction('signout')` を実行
  3. `member` が存在しない場合は `doAction('switchPage', {page: 'signin', ...})` を実行

### 2-プロフィール編集

- トリガー: 「Edit」ボタンクリック
- 処理:
  1. `doAction('switchPage', {page: 'accountProfile', lastPage: 'accountHome'})` を実行
  2. プロフィール編集ページへ遷移

### 3-プラン変更

- トリガー: プラン関連ボタンクリック
- 処理:
  1. `doAction('switchPage', {page: 'accountPlan', ...})` を実行
  2. プラン選択ページへ遷移

### 4-メール設定

- トリガー: メール設定リンククリック
- 処理:
  1. `doAction('switchPage', {page: 'accountEmail', ...})` を実行
  2. メール設定ページへ遷移

### 5-サインアウト

- トリガー: 「Sign out」リンククリック
- 処理:
  1. `handleSignout(e)` でイベントをキャンセル
  2. `doAction('signout')` を実行
  3. セッションを終了し、Portalを閉じる

### 6-Portalを閉じる

- トリガー: 閉じるボタンクリック
- 処理:
  1. `doAction('closePopup')` を実行
  2. Portalモーダルを非表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ページ表示 | - | SELECT | 会員情報の読み込み（AppContext経由） |
| サインアウト | sessions | DELETE | セッションの無効化 |

※ 実際のデータ操作はGhost Core Members APIで処理

## メッセージ仕様

| 種別 | メッセージ | 表示タイミング |
|------|-----------|---------------|
| ラベル | Account | 名前がない場合のデフォルト表示 |
| ボタン | Edit | プロフィール編集ボタン |
| リンク | Sign out | サインアウトリンク |

### サブコンポーネントのメッセージ

詳細なメッセージは各サブコンポーネント（AccountWelcome, PaidAccountActions, EmailPreferencesAction等）で定義されています。

## 例外処理

| 例外状況 | 対応内容 |
|---------|---------|
| 未ログイン | サインインページへリダイレクト（redirectパラメータ付き） |
| メンバーシップ無効 | 自動サインアウト |
| member情報なし | nullを返却（何も表示しない） |

## 備考

- AccountMain, AccountFooterのサブコンポーネントで構成
- UserHeader, AccountWelcome, ContinueSubscriptionButton, AccountActionsのサブコンポーネントで詳細表示
- サポートアドレスはサイト設定から取得（getSupportAddress）
- 複数ニュースレター対応：hasMultipleNewslettersでメール設定リンクを制御
- コメント機能有効時：hasCommentsEnabledでメール設定リンクを表示
- メール抑制状態：isEmailSuppressedでメール設定リンクを表示

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、プログラム間で受け渡されるデータ構造を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | app-context.js | `apps/portal/src/app-context.js` | AppContextの構造（site, member, action等） |
| 1-2 | helpers.js | `apps/portal/src/utils/helpers.js` | getSupportAddress, hasMultipleNewsletters等 |

**読解のコツ**: `member` オブジェクトには `name`, `email`, `subscriptions`, `newsletters` などが含まれます。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | account-home-page.js | `apps/portal/src/components/pages/AccountHomePage/account-home-page.js` | メインコンポーネント |
| 2-2 | pages.js | `apps/portal/src/pages.js` | ページマッピング |

**主要処理フロー**:
1. **L12-27**: componentDidMount - 認証チェックとリダイレクト
2. **L29-32**: handleSignout - サインアウト処理
3. **L34-52**: render - メイン描画

#### Step 3: サブコンポーネントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | account-main.js | `apps/portal/src/components/pages/AccountHomePage/components/account-main.js` | メインコンテンツ |
| 3-2 | account-actions.js | `apps/portal/src/components/pages/AccountHomePage/components/account-actions.js` | アクションリスト |
| 3-3 | account-footer.js | `apps/portal/src/components/pages/AccountHomePage/components/account-footer.js` | フッター |

**account-main.js の構成**:
- CloseButton
- UserHeader
- AccountWelcome
- ContinueSubscriptionButton
- AccountActions

**account-actions.js の構成**:
- プロフィール編集セクション
- PaidAccountActions（有料会員向け）
- EmailPreferencesAction / EmailNewsletterAction

### プログラム呼び出し階層図

```
AccountHomePage (React Component)
    |
    +-- componentDidMount()
    |       +-- isSigninAllowed({site})
    |       |       +-- (if not allowed) doAction('signout')
    |       |
    |       +-- (if no member) doAction('switchPage', {page: 'signin'})
    |
    +-- render()
            +-- AccountMain
            |       +-- CloseButton
            |       +-- UserHeader
            |       +-- AccountWelcome
            |       +-- ContinueSubscriptionButton
            |       +-- AccountActions
            |               +-- openEditProfile() --> doAction('switchPage', {page: 'accountProfile'})
            |               +-- PaidAccountActions
            |               +-- EmailPreferencesAction / EmailNewsletterAction
            |
            +-- AccountFooter
                    +-- onClose() --> doAction('closePopup')
                    +-- handleSignout() --> doAction('signout')
                    +-- supportAddress
```

### データフロー図

```
[入力]                    [処理]                              [出力]

ページ読み込み
    |
    +-- componentDidMount() --> isSigninAllowed?
                                    |
                                    +-- (false) --> signout
                                    |
                                    +-- (true) --> member存在?
                                                      |
                                                      +-- (false) --> signin遷移
                                                      |
                                                      +-- (true) --> 画面表示

Edit クリック
    |
    +-- openEditProfile() --> switchPage('accountProfile')

Sign out クリック
    |
    +-- handleSignout() --> doAction('signout')

Close クリック
    |
    +-- onClose() --> doAction('closePopup')
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| account-home-page.js | `apps/portal/src/components/pages/AccountHomePage/account-home-page.js` | ソース | メインコンポーネント |
| account-main.js | `apps/portal/src/components/pages/AccountHomePage/components/account-main.js` | ソース | メインコンテンツ |
| account-footer.js | `apps/portal/src/components/pages/AccountHomePage/components/account-footer.js` | ソース | フッター |
| account-actions.js | `apps/portal/src/components/pages/AccountHomePage/components/account-actions.js` | ソース | アクションリスト |
| account-welcome.js | `apps/portal/src/components/pages/AccountHomePage/components/account-welcome.js` | ソース | ウェルカムメッセージ |
| user-header.js | `apps/portal/src/components/pages/AccountHomePage/components/user-header.js` | ソース | ユーザーヘッダー |
| paid-account-actions.js | `apps/portal/src/components/pages/AccountHomePage/components/paid-account-actions.js` | ソース | 有料会員向けアクション |
| continue-subscription-button.js | `apps/portal/src/components/pages/AccountHomePage/components/continue-subscription-button.js` | ソース | 購読継続ボタン |
| email-preferences-action.js | `apps/portal/src/components/pages/AccountHomePage/components/email-preferences-action.js` | ソース | メール設定アクション |
| email-newsletter-action.js | `apps/portal/src/components/pages/AccountHomePage/components/email-newsletter-action.js` | ソース | ニュースレターアクション |
| pages.js | `apps/portal/src/pages.js` | ソース | ページマッピング定義 |
| app-context.js | `apps/portal/src/app-context.js` | ソース | Reactコンテキスト定義 |
| helpers.js | `apps/portal/src/utils/helpers.js` | ソース | ヘルパー関数 |
