# 画面設計書 92-ローディングページ

## 概要

本ドキュメントは、Ghost会員向け公開画面（Portal）における「ローディングページ」の画面設計書です。データ読み込み中や処理待ち状態を視覚的に示すローディングインジケータを表示するシンプルな画面です。

### 本画面の処理概要

ローディングページは、Portalウィジェット内で非同期処理の完了を待機している間に表示されるインジケータ画面です。

**業務上の目的・背景**：ユーザーがアクション（サインアップ、購読処理など）を実行した際に、処理が進行中であることを視覚的にフィードバックし、ユーザーエクスペリエンスを向上させます。処理完了まで待機状態であることを明示することで、ユーザーの操作ミス（二重送信など）を防止します。

**画面へのアクセス方法**：
- 内部的な状態遷移として自動表示（直接アクセスは想定されていない）
- Stripeチェックアウト開始時、オファー処理時などの非同期処理開始時
- アプリケーション初期化中（init:running状態）

**主要な操作・処理内容**：
1. 回転するローダーアイコンの表示
2. 他の操作はなく、処理完了を待機

**画面遷移**：
- 遷移元: 各種処理開始時（signup、checkoutPlan、handleOfferQuery等）
- 遷移先: 処理完了後の対象ページ（サインアップ成功、アカウントホーム等）

**権限による表示制御**：
- 権限に関わらず、処理待機中に全ユーザーに対して表示される

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 71 | Portal | 主機能 | 読み込み中状態の表示 |

## 画面種別

インジケータ（ステータス表示）

## URL/ルーティング

- ページ名: `loading`
- 直接URLアクセスは想定されていない（内部状態遷移のみ）

## 入出力項目

| 項目名 | 入出力 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| (なし) | - | - | - | 入出力項目なし |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| LoaderIcon | SVG | 回転するローディングアイコン |

## イベント仕様

### 1-自動遷移

ローディングページはユーザー操作を受け付けず、処理完了時に自動的に次の画面へ遷移します。

- 処理: 外部処理（API呼び出し、Stripe決済など）の完了を待機
- 完了時: `dispatchAction`により次のページへ状態遷移

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| (なし) | - | - | 本画面自体はデータベース操作を行わない |

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|---------|--------------|
| (なし) | - | - | メッセージ表示なし（アイコンのみ） |

## 例外処理

| 例外種別 | 発生条件 | 対応処理 |
|---------|---------|---------|
| タイムアウト | 処理が長時間完了しない | 親コンポーネントでのエラーハンドリングに委譲 |

## 備考

- 非常にシンプルなコンポーネントで、15行未満のReactクラスコンポーネントとして実装
- ローダーアイコンはSVGアニメーション（CSSアニメーション）を使用
- `data-testid="loaderIcon"` でテスト用の識別子が付与されている

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: コンポーネント構造を理解する

ローディングページは最もシンプルなコンポーネントの一つ。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | loading-page.js | `apps/portal/src/components/pages/loading-page.js` | 全15行のシンプルなコンポーネント |

**読解のコツ**: Reactクラスコンポーネントの最小実装例として参考になる。

#### Step 2: 呼び出し元を理解する

どのような状況でローディングページが表示されるかを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | pages.js | `apps/portal/src/pages.js` | ページマッピング（loading: LoadingPage） |
| 2-2 | App.js | `apps/portal/src/App.js` | loadingページの設定箇所（L56, L767, L807-809） |

**主要処理フロー**:
1. **56行目**: 初期状態で `page: 'loading'` が設定される
2. **767行目**: オファー処理開始時に `page: 'loading'` を表示
3. **807-809行目**: サインアップ処理開始時に `page: 'loading'` を表示

#### Step 3: アイコンリソースを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | loader.svg | `apps/portal/src/images/icons/loader.svg` | SVGアイコンの定義 |
| 3-2 | app.css | `apps/portal/src/app.css` | `.gh-portal-loadingicon` のCSSアニメーション定義 |

### プログラム呼び出し階層図

```
App.js (state.page)
    │
    ├─ 初期化時 (page: 'loading')
    │
    ├─ handleOfferQuery()
    │      └─ dispatchAction('openPopup', {page: 'loading'})
    │
    └─ handleSignupQuery()
           └─ dispatchAction('openPopup', {page: 'loading'})
                  │
                  └─ PopupModal
                         └─ LoadingPage
                                └─ LoaderIcon (SVG)
```

### データフロー図

```
[入力]                   [処理]                    [出力]

state.page === ────────▶ LoadingPage ─────────▶ LoaderIcon表示
'loading'               (renderのみ)              (CSSアニメーション)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| loading-page.js | `apps/portal/src/components/pages/loading-page.js` | ソース | メインコンポーネント |
| pages.js | `apps/portal/src/pages.js` | ソース | ページルーティング定義 |
| App.js | `apps/portal/src/App.js` | ソース | 状態管理、loadingページへの遷移制御 |
| loader.svg | `apps/portal/src/images/icons/loader.svg` | リソース | ローダーアイコンSVG |
| app.css | `apps/portal/src/app.css` | スタイル | アニメーション定義 |
