# 画面設計書 97-削除確認ポップアップ

## 概要

本ドキュメントは、Ghost公開画面における「削除確認ポップアップ」（DeletePopup）の画面設計書です。コメントを削除する前に確認ダイアログを表示し、誤削除を防止するためのポップアップコンポーネントです。

### 本画面の処理概要

削除確認ポップアップは、会員が自分のコメントを削除しようとした際に表示される確認ダイアログです。

**業務上の目的・背景**：コメントの誤削除を防止するために、削除前に確認を求めます。一度削除されたコメントは復元できないため、ユーザーに明確な警告を表示し、意図的な操作であることを確認します。

**画面へのアクセス方法**：
- 自分のコメントのメニュー（...）から「Delete」を選択
- ログイン中の会員が自分のコメントでのみ利用可能

**主要な操作・処理内容**：
1. 削除確認メッセージの表示
2. 「Delete」ボタンで削除を実行
3. 「Cancel」ボタンでキャンセル
4. 削除処理中のローディング表示
5. 削除完了後の自動クローズ

**画面遷移**：
- 削除後: ポップアップが閉じ、コメントがリストから削除される
- キャンセル: ポップアップが閉じ、元の画面に戻る

**権限による表示制御**：
- 自分が投稿したコメントでのみ削除可能
- 他のユーザーのコメントには削除オプションが表示されない

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 26 | コメントモデレーション | 主機能 | コメント削除の確認 |
| 72 | Comments UI | 補助機能 | コメントUIウィジェットの表示 |

## 画面種別

確認（ポップアップ/モーダル）

## URL/ルーティング

- ポップアップとして表示（独自URLなし）

## 入出力項目

| 項目名 | 入出力 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| comment | 入力 | Comment | 必須 | 削除対象のコメントオブジェクト |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| タイトル | string | "Are you sure?" |
| メッセージ | string | "Once deleted, this comment can't be recovered." |
| 削除ボタン | ReactNode | 状態に応じて変化（Delete/Deleting/Deleted） |
| キャンセルボタン | string | "Cancel" |

## イベント仕様

### 1-削除実行（submit）

「Delete」ボタンクリックでコメント削除を実行します。

- 処理フロー:
  1. `isSubmitting: true`に設定（二重送信防止）
  2. `progress: 'sending'`に設定（ローディング表示）
  3. 1000ms後に`progress: 'sent'`に設定
  4. `dispatchAction('deleteComment', comment)`を実行
  5. 750ms後に`close()`でポップアップを閉じる

### 2-キャンセル（close）

「Cancel」ボタンクリックまたは閉じるボタンでポップアップを閉じます。

- 処理: `dispatchAction('closePopup', {})`
- 結果: ポップアップが閉じ、コメントは削除されない

### 3-背景クリック防止（stopPropagation）

ポップアップ内のクリックが背景に伝播するのを防止します。

- 処理: `event.stopPropagation()`
- 用途: 意図しないポップアップクローズの防止

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除実行 | comments | DELETE/UPDATE | コメントの削除（または論理削除） |

### テーブル別更新項目詳細

#### comments

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE/UPDATE | id | 削除対象コメントのID | WHERE条件 |
| UPDATE | status | 'deleted' | 論理削除の場合 |

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|---------|--------------|
| MSG001 | タイトル | 常時 | "Are you sure?" |
| MSG002 | 警告 | 常時 | "Once deleted, this comment can't be recovered." |
| MSG003 | ボタン | デフォルト | "Delete" |
| MSG004 | ボタン | 送信中 | "Deleting" |
| MSG005 | ボタン | 完了 | "Deleted" |
| MSG006 | ボタン | 常時 | "Cancel" |

## 例外処理

| 例外種別 | 発生条件 | 対応処理 |
|---------|---------|---------|
| 二重送信 | 送信中に再度クリック | isSubmittingフラグで防止 |
| 権限エラー | 他人のコメントを削除しようとした | サーバー側でエラーを返す |

## 備考

- 削除ボタンの色は赤（bg-red-600）→緑（bg-green-600、完了時）に変化
- ローディング中はSpinnerIconを表示
- 完了時はSuccessIcon（チェックマーク）を表示
- レスポンシブ対応（モバイルではフルスクリーン、PCでは500pxの角丸モーダル）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: コンポーネント構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | delete-popup.tsx | `apps/comments-ui/src/components/popups/delete-popup.tsx` | 削除確認ポップアップコンポーネント（1-97行目） |

**主要処理フロー**:
1. **8行目**: Propsからcommentを受け取る
2. **9-11行目**: dispatchAction取得、progress/isSubmitting状態の初期化
3. **13-16行目**: 進行状態に応じたボタン色の切り替え
4. **18-25行目**: 進行状態に応じたボタンテキストの切り替え
5. **27-35行目**: 進行状態に応じたボタンアイコンの切り替え
6. **37-39行目**: stopPropagation関数
7. **41-43行目**: close関数（closePopupアクション）
8. **45-64行目**: submit関数（削除処理フロー）
9. **66-93行目**: JSXレンダリング

#### Step 2: 削除アクションを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | actions.ts | `apps/comments-ui/src/actions.ts` | deleteCommentアクションの実装 |

**読解のコツ**: deleteCommentアクションはAPIを呼び出し、成功時にcommentsリストから削除する。

#### Step 3: CloseButtonコンポーネントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | close-button.tsx | `apps/comments-ui/src/components/popups/close-button.tsx` | 閉じるボタンコンポーネント |

### プログラム呼び出し階層図

```
Comment (コメントコンポーネント)
    │
    └─ CommentMenu → Delete選択
           │
           └─ dispatchAction('openPopup', {type: 'deletePopup', ...})
                  │
                  └─ DeletePopup
                         │
                         ├─ submit()
                         │      ├─ setProgress('sending') - ローディング開始
                         │      ├─ setTimeout 1000ms
                         │      ├─ setProgress('sent') - 完了表示
                         │      ├─ dispatchAction('deleteComment', comment)
                         │      │      └─ API: DELETE /comments/{id}
                         │      └─ setTimeout 750ms → close()
                         │
                         ├─ close()
                         │      └─ dispatchAction('closePopup', {})
                         │
                         └─ CloseButton
                                └─ close()
```

### データフロー図

```
[入力]                    [処理]                       [出力]

comment ─────────────────▶ DeletePopup ─────────────▶ 確認ダイアログ表示
                           │
Deleteボタンクリック ─────│
                           │
                           ▼
                        submit()
                           │
                        progress: 'sending' ─────────▶ ローディング表示
                           │
                        setTimeout(1000)
                           │
                        progress: 'sent' ────────────▶ 完了アイコン表示
                           │
                   dispatchAction('deleteComment')
                           │
                           ▼
                   API: DELETE /comments/{id} ───────▶ コメント削除
                           │
                        setTimeout(750)
                           │
                        close() ─────────────────────▶ ポップアップ閉じる
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| delete-popup.tsx | `apps/comments-ui/src/components/popups/delete-popup.tsx` | ソース | 削除確認ポップアップコンポーネント |
| close-button.tsx | `apps/comments-ui/src/components/popups/close-button.tsx` | ソース | 閉じるボタンコンポーネント |
| spinner.svg | `apps/comments-ui/src/images/icons/spinner.svg` | リソース | ローディングアイコン |
| success.svg | `apps/comments-ui/src/images/icons/success.svg` | リソース | 完了チェックアイコン |
| app-context.ts | `apps/comments-ui/src/app-context.ts` | ソース | Comment型定義 |
| actions.ts | `apps/comments-ui/src/actions.ts` | ソース | deleteComment, closePopupアクション |
