# 画面設計書 98-通報ポップアップ

## 概要

本ドキュメントは、Ghost公開画面における「通報ポップアップ」（ReportPopup）の画面設計書です。不適切なコメントをサイト運営者に報告するためのポップアップコンポーネントです。

### 本画面の処理概要

通報ポップアップは、会員が他のユーザーの不適切なコメントを報告する際に表示される確認ダイアログです。

**業務上の目的・背景**：コミュニティの健全性を維持するために、会員がスパムや不適切なコメントを報告できる仕組みを提供します。報告はサイト運営者に送信され、モデレーション（コメント管理）の判断材料となります。

**画面へのアクセス方法**：
- 他のユーザーのコメントのメニュー（...）から「Report」を選択
- ログイン中の会員が他のユーザーのコメントでのみ利用可能

**主要な操作・処理内容**：
1. 通報確認メッセージの表示
2. 「Report」ボタンで通報を実行
3. 「Cancel」ボタンでキャンセル
4. 送信中のローディング表示
5. 送信完了後の自動クローズ

**画面遷移**：
- 通報後: ポップアップが閉じる
- キャンセル: ポップアップが閉じ、元の画面に戻る

**権限による表示制御**：
- ログイン中の会員のみが通報可能
- 自分のコメントには通報オプションが表示されない

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 28 | コメント報告 | 主機能 | 不適切なコメントの報告 |
| 72 | Comments UI | 補助機能 | コメントUIウィジェットの表示 |

## 画面種別

確認（ポップアップ/モーダル）

## URL/ルーティング

- ポップアップとして表示（独自URLなし）

## 入出力項目

| 項目名 | 入出力 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| comment | 入力 | Comment | 必須 | 通報対象のコメントオブジェクト |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| タイトル | string | "Report this comment?" |
| メッセージ | string | "Your request will be sent to the owner of this site." |
| 通報ボタン | ReactNode | 状態に応じて変化（Report/Sending/Sent） |
| キャンセルボタン | string | "Cancel" |

## イベント仕様

### 1-通報実行（submit）

「Report」ボタンクリックで通報を実行します。

- 処理フロー:
  1. `progress: 'sending'`に設定（ローディング表示）
  2. 1000ms後に`progress: 'sent'`に設定（UXのための意図的な遅延）
  3. `dispatchAction('reportComment', comment)`を実行
  4. 750ms後に`close()`でポップアップを閉じる

### 2-キャンセル（close）

「Cancel」ボタンクリックまたは閉じるボタンでポップアップを閉じます。

- 処理: `dispatchAction('closePopup', {})`
- 結果: ポップアップが閉じ、通報は送信されない

### 3-背景クリック防止（stopPropagation）

ポップアップ内のクリックが背景に伝播するのを防止します。

- 処理: `event.stopPropagation()`
- 用途: 意図しないポップアップクローズの防止

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 通報実行 | comment_reports | INSERT | 通報レコードの作成 |

### テーブル別更新項目詳細

#### comment_reports（推測）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | comment_id | 通報対象コメントのID | |
| INSERT | member_id | 通報者の会員ID | セッションから取得 |
| INSERT | created_at | 現在日時 | サーバー側で設定 |

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|---------|--------------|
| MSG001 | タイトル | 常時 | "Report this comment?" |
| MSG002 | 説明 | 常時 | "Your request will be sent to the owner of this site." |
| MSG003 | ボタン | デフォルト | "Report" |
| MSG004 | ボタン | 送信中 | "Sending" |
| MSG005 | ボタン | 完了 | "Sent" |
| MSG006 | ボタン | 常時 | "Cancel" |

## 例外処理

| 例外種別 | 発生条件 | 対応処理 |
|---------|---------|---------|
| 通報エラー | API呼び出し失敗 | エラーハンドリング（アクション内） |
| 重複通報 | 同一コメントを再度通報 | サーバー側で処理（重複防止） |

## 備考

- 削除確認ポップアップ（DeletePopup）と非常に類似した構造
- 通報ボタンの色は赤（bg-red-600）→緑（bg-green-600、完了時）に変化
- 通報の詳細理由を入力するフィールドは設けられていない（ワンクリック通報）
- UXのため、送信処理に意図的な遅延（1000ms）が設定されている

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: コンポーネント構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | report-popup.tsx | `apps/comments-ui/src/components/popups/report-popup.tsx` | 通報ポップアップコンポーネント（1-91行目） |

**主要処理フロー**:
1. **8行目**: Propsからcommentを受け取る
2. **9-10行目**: dispatchAction取得、progress状態の初期化
3. **12-15行目**: 進行状態に応じたボタン色の切り替え
4. **17-24行目**: 進行状態に応じたボタンテキストの切り替え
5. **26-34行目**: 進行状態に応じたボタンアイコンの切り替え
6. **36-38行目**: stopPropagation関数
7. **40-42行目**: close関数（closePopupアクション）
8. **44-58行目**: submit関数（通報処理フロー）
9. **60-87行目**: JSXレンダリング

#### Step 2: 通報アクションを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | actions.ts | `apps/comments-ui/src/actions.ts` | reportCommentアクションの実装 |

**読解のコツ**: reportCommentアクションはAPIを呼び出し、サイト運営者に通知を送信する。

### プログラム呼び出し階層図

```
Comment (コメントコンポーネント)
    │
    └─ CommentMenu → Report選択
           │
           └─ dispatchAction('openPopup', {type: 'reportPopup', ...})
                  │
                  └─ ReportPopup
                         │
                         ├─ submit()
                         │      ├─ setProgress('sending') - ローディング開始
                         │      ├─ setTimeout 1000ms
                         │      ├─ setProgress('sent') - 完了表示
                         │      ├─ dispatchAction('reportComment', comment)
                         │      │      └─ API: POST /comments/{id}/report
                         │      └─ setTimeout 750ms → close()
                         │
                         ├─ close()
                         │      └─ dispatchAction('closePopup', {})
                         │
                         └─ CloseButton
                                └─ close()
```

### データフロー図

```
[入力]                    [処理]                       [出力]

comment ─────────────────▶ ReportPopup ─────────────▶ 確認ダイアログ表示
                           │
Reportボタンクリック ─────│
                           │
                           ▼
                        submit()
                           │
                        progress: 'sending' ─────────▶ ローディング表示
                           │
                        setTimeout(1000)
                           │
                        progress: 'sent' ────────────▶ 完了アイコン表示
                           │
                   dispatchAction('reportComment')
                           │
                           ▼
                   API: POST /comments/{id}/report ──▶ 通報作成
                           │                          運営者に通知
                        setTimeout(750)
                           │
                        close() ─────────────────────▶ ポップアップ閉じる
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| report-popup.tsx | `apps/comments-ui/src/components/popups/report-popup.tsx` | ソース | 通報ポップアップコンポーネント |
| close-button.tsx | `apps/comments-ui/src/components/popups/close-button.tsx` | ソース | 閉じるボタンコンポーネント |
| spinner.svg | `apps/comments-ui/src/images/icons/spinner.svg` | リソース | ローディングアイコン |
| success.svg | `apps/comments-ui/src/images/icons/success.svg` | リソース | 完了チェックアイコン |
| app-context.ts | `apps/comments-ui/src/app-context.ts` | ソース | Comment型定義 |
| actions.ts | `apps/comments-ui/src/actions.ts` | ソース | reportComment, closePopupアクション |
