---
generated_at: 2026-01-29 20:30:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：1-サインイン画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **C-28**：ブルートフォース対策の詳細動作（brute.reset）

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/admin/app/templates/signin.hbs` - サインインフォームテンプレート
- E-02: `ghost/admin/app/routes/signin.js` - サインインルート定義
- E-03: `ghost/admin/app/controllers/signin.js` - サインインコントローラー
- E-04: `ghost/admin/app/validators/signin.js` - サインインバリデータ
- E-05: `ghost/admin/app/routes/unauthenticated.js` - 未認証ルート基底クラス
- E-06: `ghost/admin/app/authenticators/cookie.js` - Cookie認証実装
- E-07: `ghost/core/core/server/api/endpoints/session.js` - セッションAPIエンドポイント
- E-08: `ghost/core/core/server/models/user.js` - ユーザーモデル
- E-09: `ghost/core/core/server/services/auth/session/index.js` - セッションサービス
- E-10: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-11: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | メールアドレスとパスワードによる認証機能を提供 | E-01 (15-76行目), E-03 | ○ |
| C-02 | 未認証状態でアクセスすると本画面にリダイレクト | E-05 (19行目: prohibitAuthentication) | ○ |
| C-03 | セットアップ未完了時はセットアップ画面にリダイレクト | E-05 (16-17行目) | ○ |
| C-04 | 認証成功時はホーム画面へ遷移 | E-03 (56行目), E-05 (19行目: 'home') | ○ |
| C-05 | 2FA要求時はサインイン確認画面へ遷移 | E-03 (59-64行目: isTwoFactorTokenRequiredError) | ○ |
| C-06 | Forgot?リンクでパスワードリセットメール送信 | E-03 (130-172行目), E-01 (55-64行目) | ○ |
| C-07 | URL: /ghost/signin | E-02, E-10 | ○ |
| C-08 | メールアドレスは必須、メール形式バリデーション | E-04 (9-15行目, 24-27行目) | ○ |
| C-09 | パスワードは必須バリデーション | E-04 (34-37行目) | ○ |
| C-10 | サイトアイコンとブログタイトル表示 | E-01 (7行目, 17-18行目) | ○ |
| C-11 | エラー/通知メッセージ表示領域 | E-01 (78行目) | ○ |
| C-12 | パスワードリセット必須時は専用画面表示 | E-01 (4-13行目), E-03 (87-88行目) | ○ |
| C-13 | validateAndAuthenticateTaskでバリデーション後認証 | E-03 (111-128行目) | ○ |
| C-14 | POST /ghost/api/admin/session で認証 | E-06 (48行目: sessionEndpoint), E-07 | ○ |
| C-15 | last_seenカラムを更新 | E-08 (1002行目: updateLastSeen) | ○ |
| C-16 | statusをactiveに更新 | E-08 (1005-1006行目) | ○ |
| C-17 | 「Email address is not valid」エラー | E-04 (7行目) | ○ |
| C-18 | 「Please enter an email」エラー | E-04 (25行目) | ○ |
| C-19 | 「Please enter a password」エラー | E-04 (36行目) | ○ |
| C-20 | 「There is no user with that email address.」エラー | E-08 (32行目, 986行目) | ○ |
| C-21 | 「Your password is incorrect.」エラー | E-08 (35行目), E-03 (95行目) | ○ |
| C-22 | 「Your account was suspended.」エラー | E-08 (33行目, 994-997行目) | ○ |
| C-23 | locked状態でパスワードリセットメール自動送信 | E-07 (53-58行目), E-08 (990-991行目) | ○ |
| C-24 | TooManyRequestsError対応 | E-03 (82-85行目) | ○ |
| C-25 | ember-simple-authによるCookieベース認証 | E-06 (1行目: ember-simple-auth) | ○ |
| C-26 | フォーカスアウト時のバリデーション | E-01 (35行目: on "blur") | ○ |
| C-27 | 入力欄にエラーマーク表示 | E-03 (91-97行目), E-01 (20-38行目: GhFormGroup) | ○ |
| C-28 | brute.resetによるブルートフォース対策 | E-07 (35-38行目) | △ |

## 4) 不足情報（Unknown / Missing）

- **C-28 ブルートフォース対策**：brute.reset()の呼び出しはsession.jsで確認できるが、bruteミドルウェアの設定・実装詳細は別ファイルにあり完全な動作確認には追加調査が必要
  - 候補：`ghost/core/core/server/web/shared/middleware/brute.js` / Express-bruteの設定

## 5) リスクフラグ（レビュー観点）

- **0（低リスク）**：入出力項目・バリデーション - コードから明確に確認可能
- **0（低リスク）**：画面遷移 - ルート定義・コントローラーから確認可能
- **0（低リスク）**：エラーメッセージ - バリデータ・モデルから確認可能
- **1（中リスク）**：ブルートフォース対策詳細 - 別モジュールの調査が必要
- **0（低リスク）**：DB更新仕様 - モデルコードから確認可能

## 6) レビュアーチェックリスト（最小）

- [ ] セットアップ未完了時のリダイレクト動作が実環境で期待通りか確認
- [ ] 2FA有効時の遷移フローが正しく動作するか確認
- [ ] ブルートフォース対策（レート制限）の閾値・動作を確認
- [ ] パスワードリセット必須状態（locked）時の自動メール送信を確認
- [ ] セッションの有効期限設定を確認
