---
generated_at: 2026-01-29 21:50:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：100-検索モーダル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `apps/sodo-search/src/components/popup-modal.js` (1-695行目)
- E-02: `apps/sodo-search/src/app.js` (1-213行目)
- E-03: `apps/sodo-search/src/search-index.js` (1-228行目)
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (160-161行目)
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` (101行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PopupModalが検索UIを担当 | E-01, E-05 | ○ |
| C-02 | Flexsearchを使用したクライアントサイド検索 | E-03 (L1, L67-98) | ○ |
| C-03 | posts, authors, tagsの3つのインデックス | E-03 (L67-98) | ○ |
| C-04 | CJK対応のカスタムエンコーダー | E-03 (L3-52) | ○ |
| C-05 | URLハッシュ #/search でアクセス可能 | E-02 (L157-165) | ○ |
| C-06 | data-ghost-search属性でトリガー | E-02 (L152-154) | ○ |
| C-07 | Cmd+Kキーボードショートカット | E-02 (L167-183) | ○ |
| C-08 | 検索インデックスは遅延ロード | E-02 (L74-77, L79-87) | ○ |
| C-09 | DEFAULT_MAX_POSTS = 10 | E-01 (L8) | ○ |
| C-10 | STEP_MAX_POSTS = 10 | E-01 (L9) | ○ |
| C-11 | SearchBoxコンポーネントで入力フィールド | E-01 (L73-126) | ○ |
| C-12 | ESCキーでモーダルを閉じる | E-01 (L81-87) | ○ |
| C-13 | 上下矢印キーで結果選択 | E-01 (L530-548) | ○ |
| C-14 | Enterキーで選択結果へ遷移 | E-01 (L542-547) | ○ |
| C-15 | HighlightedSectionでキーワードハイライト | E-01 (L309-342) | ○ |
| C-16 | NoResultsBoxで "No matches found" 表示 | E-01 (L583-589) | ○ |
| C-17 | ShowMoreButtonで追加結果表示 | E-01 (L359-376) | ○ |
| C-18 | 404ページのURLをフィルタリング | E-01 (L485-493) | ○ |
| C-19 | backdrop-blur効果 | E-01 (L680) | ○ |
| C-20 | 機能No.49 サイト内検索が主機能 | E-04 (L160) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] Content APIのエンドポイント（search-index/posts, authors, tags）の存在確認
- [ ] Flexsearchライブラリのバージョンを確認
- [ ] CJK対応が期待通りに動作するかテスト
- [ ] 検索インデックスのパフォーマンスを確認（大量コンテンツ時）
