---
generated_at: 2026-01-29 20:50:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：101-サインアップフォーム

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **バックエンドでのDB更新処理**：フロントエンドコードからは確認不可
  2. **複数フォーム設置時の動作**：index.tsxのコメントのみ
  3. **スパムフィルター連携**：設定による制限の詳細

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `apps/signup-form/src/components/pages/form-page.tsx` (1-56行目)
- E-02: `apps/signup-form/src/components/pages/form-view.tsx` (1-93行目)
- E-03: `apps/signup-form/src/utils/api.tsx` (1-60行目)
- E-04: `apps/signup-form/src/utils/options.tsx` (1-45行目)
- E-05: `apps/signup-form/src/utils/validator.tsx` (1-4行目)
- E-06: `apps/signup-form/src/utils/helpers.tsx` (1-69行目)
- E-07: `apps/signup-form/src/app-context.ts` (1-35行目)
- E-08: `apps/signup-form/src/App.tsx` (1-60行目)
- E-09: `apps/signup-form/src/index.tsx` (1-55行目)
- E-10: `apps/signup-form/src/pages.tsx` (1-22行目)
- E-11: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (162-163行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 埋め込み用サインアップフォームである | E-09 (scriptタグからの初期化) | ○ |
| C-02 | メールアドレスを入力して購読登録する | E-01 (submit関数), E-02 (Form) | ○ |
| C-03 | isValidEmailでメールアドレスをバリデーション | E-05 (正規表現パターン), E-01 (15-18行目) | ○ |
| C-04 | integrity-tokenエンドポイントからトークン取得 | E-03 (15-30行目) | ○ |
| C-05 | send-magic-linkエンドポイントにPOST送信 | E-03 (31-55行目) | ○ |
| C-06 | ミニマルモードはtitleが設定されていない場合に有効 | E-06 (12-14行目 isMinimal) | ○ |
| C-07 | 成功時にSuccessPageへ遷移（通常モード） | E-01 (32-34行目) | ○ |
| C-08 | 成功時に「Email sent」表示（ミニマルモード） | E-01 (27-30行目), E-02 (86行目) | ○ |
| C-09 | data属性からオプションを読み取る | E-04 (5-24行目 buildOptions) | ○ |
| C-10 | MutationObserverで属性変更を監視 | E-04 (28-42行目) | ○ |
| C-11 | labels配列はdata-label-1, data-label-2...から取得 | E-04 (6-10行目) | ○ |
| C-12 | urlHistoryをsessionStorageから取得 | E-06 (19-38行目, 40-69行目) | ○ |
| C-13 | 埋め込み先が別ドメインの場合Embedミディアムとして記録 | E-06 (61-66行目) | ○ |
| C-14 | SignupFormOptions型にtitle,description等が定義 | E-07 (6-17行目) | ○ |
| C-15 | AppContextProviderでコンテキストを提供 | E-08 (48行目) | ○ |
| C-16 | i18nLib使用で多言語対応 | E-08 (33行目) | ○ |
| C-17 | FormPage -> FormViewの構成 | E-01, E-02 | ○ |
| C-18 | エラーメッセージ「Please enter a valid email address」 | E-01 (16行目) | ○ |
| C-19 | エラーメッセージ「Something went wrong, please try again.」 | E-01 (38行目) | ○ |
| C-20 | input disabled状態がloading/success時に適用 | E-02 (72行目) | ○ |
| C-21 | buttonにbuttonColor, buttonTextColorスタイル適用 | E-02 (82行目) | ○ |
| C-22 | LoadingIconコンポーネントでスピナー表示 | E-02 (87行目) | ○ |
| C-23 | 複数フォームを1ページに設置可能 | E-09 (コメント26-27行目) | ○ |
| C-24 | 機能マッピングで主機能:メンバー登録と定義 | E-11 | ○ |
| C-25 | DB更新はmembers, members_labels等に対して行われる | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- バックエンドでのデータベース更新処理の詳細
  - フロントエンドコードからはAPI呼び出しのみ確認可能
  - 候補：`ghost/core/core/server/services/members/api.js` / `ghost/core/core/server/api/endpoints/members.js`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - フロントエンド実装は明確に確認可能
- 1: 中リスク - バックエンドDB処理の詳細は別途確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] メールアドレスバリデーションの正規表現が要件を満たしているか確認
- [ ] integrity-token取得の目的とスパム対策の効果を確認
- [ ] ミニマルモードとフルモードの切り替え条件が適切か確認
- [ ] URLヒストリーのsessionStorage利用がプライバシー要件を満たすか確認
- [ ] バックエンドでの実際のDB更新処理を別途確認
