---
generated_at: 2026-01-29 20:54:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：103-アナウンスバー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `apps/announcement-bar/src/index.js` (1-60行目)
- E-02: `apps/announcement-bar/src/App.js` (1-13行目)
- E-03: `apps/announcement-bar/src/components/main.js` (1-27行目)
- E-04: `apps/announcement-bar/src/components/preview.js` (1-9行目)
- E-05: `apps/announcement-bar/src/components/announcement-bar.js` (1-83行目)
- E-06: `apps/announcement-bar/src/utils/api.js` (1-41行目)
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (166-167行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | bodyの先頭にルートdivを挿入 | E-01 (8-16行目 addRootDiv, 15行目 prepend) | ○ |
| C-02 | scriptタグからdata-announcement-bar属性でデータ取得 | E-01 (22行目 querySelector) | ○ |
| C-03 | data-api-urlからAPIのURLを取得 | E-01 (24行目) | ○ |
| C-04 | data-previewでプレビューモード判定 | E-01 (31-38行目 getPreviewData) | ○ |
| C-05 | プレビュー時はPreviewコンポーネントを使用 | E-02 (6-8行目) | ○ |
| C-06 | 通常時はMainコンポーネントを使用 | E-02 (9-11行目) | ○ |
| C-07 | MainコンポーネントでAPI初期化と設定取得 | E-03 (9-19行目 useEffect) | ○ |
| C-08 | api.init()でannouncement[0]を取得 | E-06 (32-35行目) | ○ |
| C-09 | AnnouncementBarにsettingsを渡す | E-03 (24行目), E-04 (6行目) | ○ |
| C-10 | visible状態をuseStateで管理 | E-05 (7行目) | ○ |
| C-11 | shouldShowBarで初期表示判定 | E-05 (7行目, 46-58行目) | ○ |
| C-12 | isContentChangedでコンテンツ変更を検知 | E-05 (64-71行目) | ○ |
| C-13 | sessionStorageにコンテンツを保存 | E-05 (60-62行目 setContent) | ○ |
| C-14 | handleButtonClickで閉じる処理 | E-05 (19-22行目) | ○ |
| C-15 | setBarVisibility(false)で表示フラグ削除 | E-05 (72-78行目) | ○ |
| C-16 | visible=falseまたはannouncement無しでnullを返す | E-05 (24-30行目) | ○ |
| C-17 | dangerouslySetInnerHTMLでHTMLコンテンツ表示 | E-05 (35行目) | ○ |
| C-18 | CloseIconで閉じるボタン表示 | E-05 (36-38行目) | ○ |
| C-19 | announcement_backgroundクラスを適用 | E-05 (32行目) | ○ |
| C-20 | sessionStorageのキーはBAR_VISIBILITY_STORAGE_KEY | E-05 (43行目) | ○ |
| C-21 | sessionStorageのキーはBAR_CONTENT_STORAGE_KEY | E-05 (44行目) | ○ |
| C-22 | 機能マッピングで主機能:アナウンスメントバーと定義 | E-07 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠がある）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - シンプルな実装で全て確認可能
- 1: 中リスク - dangerouslySetInnerHTMLを使用しているため、XSSリスクに注意（ただしadmin設定のみ）

## 6) レビュアーチェックリスト（最小）
- [ ] dangerouslySetInnerHTMLのセキュリティリスクが許容範囲か確認（admin設定のみのため低リスク）
- [ ] sessionStorageの利用がプライバシー要件を満たすか確認
- [ ] コンテンツ変更時の再表示ロジックが意図通りか確認
- [ ] プレビューモードの動作が正しいか確認
