---
generated_at: 2026-01-29 20:56:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：104-404エラー画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `ghost/admin/app/routes/error404.js` (1-38行目)
- E-02: `ghost/admin/app/controllers/error.js` (1-22行目)
- E-03: `ghost/admin/app/templates/error.hbs` (1-33行目)
- E-04: `ghost/admin/app/router.js` (91行目)
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (168行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | error404ルートは/*pathでワイルドカードマッチ | E-04 (91行目) | ○ |
| C-02 | controllerName = 'error'を設定 | E-01 (5行目) | ○ |
| C-03 | templateName = 'error'を設定 | E-01 (6行目) | ○ |
| C-04 | beforeModelでeditor-betaからのリダイレクト | E-01 (10-24行目) | ○ |
| C-05 | editor-beta/typeでlexical-editor.newへ遷移 | E-01 (15-16, 21行目) | ○ |
| C-06 | editor-beta/type/postIdでlexical-editor.editへ遷移 | E-01 (15, 17-19, 22行目) | ○ |
| C-07 | modelで{status:404}を返す | E-01 (26-29行目) | ○ |
| C-08 | buildRouteInfoMetadataでtitleToken:'Error'設定 | E-01 (32-35行目) | ○ |
| C-09 | ErrorControllerのstackプロパティはfalse | E-02 (4行目) | ○ |
| C-10 | errorゲッターはthis.modelを返す | E-02 (6-8行目) | ○ |
| C-11 | codeゲッターはstatus>200ならstatusを、それ以外は500 | E-02 (10-12行目) | ○ |
| C-12 | code===404なら'Page not found' | E-02 (15-16行目) | ○ |
| C-13 | statusText!=='error'ならstatusTextを返す | E-02 (18-19行目) | ○ |
| C-14 | テンプレートでthis.codeを表示 | E-03 (6行目) | ○ |
| C-15 | テンプレートでthis.messageを表示 | E-03 (10-12行目) | ○ |
| C-16 | this.stackが存在する場合にスタックトレース表示 | E-03 (17-31行目) | ○ |
| C-17 | スタック項目のfunctionとatを表示 | E-03 (23-27行目) | ○ |
| C-18 | 機能マッピングで主機能:Ghost Adminと定義 | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠がある）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - シンプルなエラー表示画面

## 6) レビュアーチェックリスト（最小）
- [ ] editor-betaからのリダイレクトが正しく動作するか確認
- [ ] スタックトレースが本番環境で表示されないことを確認
- [ ] エラーメッセージがユーザーにとって分かりやすいか確認
- [ ] ワイルドカードルートが他のルートより後に定義されているか確認
