---
generated_at: 2026-01-29 20:58:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：105-デザインサンドボックス

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `ghost/admin/app/routes/designsandbox.js` (1-21行目)
- E-02: `ghost/admin/app/templates/designsandbox.hbs` (1-137行目)
- E-03: `ghost/admin/app/router.js` (93行目)
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (169行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | designsandboxルートが定義されている | E-03 (93行目) | ○ |
| C-02 | @service storeを使用 | E-01 (6行目) | ○ |
| C-03 | @inject configを使用 | E-01 (8行目) | ○ |
| C-04 | beforeModelでenableDeveloperExperimentsをチェック | E-01 (10-15行目) | ○ |
| C-05 | 無効時はhomeへリダイレクト | E-01 (13行目) | ○ |
| C-06 | modelで最新投稿を取得 | E-01 (17-19行目) | ○ |
| C-07 | limit:1, order:'published_at DESC'で取得 | E-01 (18行目) | ○ |
| C-08 | GhCanvasHeaderでタイトル「Components」表示 | E-02 (2-6行目) | ○ |
| C-09 | GhPostBookmarkコンポーネントを表示 | E-02 (9-10行目) | ○ |
| C-10 | Buttonsセクションで各種ボタンスタイル表示 | E-02 (12-21行目) | ○ |
| C-11 | gh-btn-primary, gh-btn-blue等のクラス使用 | E-02 (14-20行目) | ○ |
| C-12 | Listsセクションでgh-listクラス使用 | E-02 (23-64行目) | ○ |
| C-13 | Sectionsセクションでcolumns-2レイアウト | E-02 (77-85行目, 87-96行目) | ○ |
| C-14 | Setting areaでgh-expandableクラス使用 | E-02 (100-134行目) | ○ |
| C-15 | gh-expandable-block, gh-expandable-header使用 | E-02 (103-133行目) | ○ |
| C-16 | 機能マッピングで主機能:Shadeと定義 | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠がある）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 開発者向けツールであり、本番環境では通常無効

## 6) レビュアーチェックリスト（最小）
- [ ] enableDeveloperExperimentsが本番環境でfalseになっているか確認
- [ ] 表示されるコンポーネントが最新のデザインシステムを反映しているか確認
- [ ] 投稿が存在しない場合のGhPostBookmarkの表示を確認
- [ ] CSSクラス名が他の画面と一貫しているか確認
