---
generated_at: 2026-01-29 20:35:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：11-投稿一覧画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **メッセージ仕様のMSG-03/MSG-04**：成功モーダルの具体的テキスト未確認
  2. **データベーステーブル名**：Ember Data経由のため実テーブル名は推測

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/admin/app/routes/posts.js`（255行）
- E-02: `ghost/admin/app/controllers/posts.js`（231行）
- E-03: `ghost/admin/app/templates/posts.hbs`（80行）
- E-04: `ghost/admin/app/models/post.js`（455行）
- E-05: `ghost/admin/app/components/posts-list/list.js`（66行）
- E-06: `ghost/admin/app/components/posts-list/list.hbs`（45行）
- E-07: `ghost/admin/app/components/posts-list/list-item.js`（73行）
- E-08: `ghost/admin/app/components/posts-list/list-item.hbs`（285行）
- E-09: `ghost/admin/app/components/posts-list/content-filter.hbs`（126行）
- E-10: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-11: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL: /ghost/#/posts | E-01（43行目 routeName） | ○ |
| C-02 | queryParams: type, visibility, author, tag, order | E-01（50-56行目）, E-02（66行目） | ○ |
| C-03 | ページサイズ30件 | E-01（59行目 perPage = 30） | ○ |
| C-04 | InfinityModel 3分割（scheduled, draft, published/sent） | E-01（114-130行目） | ○ |
| C-05 | フィルタ選択肢TYPES定義 | E-02（11-29行目） | ○ |
| C-06 | フィルタ選択肢VISIBILITIES定義 | E-02（31-43行目） | ○ |
| C-07 | フィルタ選択肢ORDERS定義 | E-02（45-54行目） | ○ |
| C-08 | 空状態メッセージ「Start creating content.」 | E-03（43行目） | ○ |
| C-09 | 空状態メッセージ「No posts match the current filter」 | E-03（48行目） | ○ |
| C-10 | InfinityLoaderのtriggerOffset=1000 | E-03（62, 68, 74行目） | ○ |
| C-11 | Postモデル属性（title, status, visibility等） | E-04（83-118行目） | ○ |
| C-12 | Postリレーション（authors, tags, email） | E-04（124-129行目） | ○ |
| C-13 | ステータス判定computed（isPublished, isDraft等） | E-04（161-165行目） | ○ |
| C-14 | hasAnalyticsPage判定条件 | E-04（220-228行目） | ○ |
| C-15 | 公開成功モーダル表示（localStorage使用） | E-05（22-40行目） | ○ |
| C-16 | リスト表示順序（scheduled → draft → published） | E-06（3-33行目） | ○ |
| C-17 | Contributor公開済みは外部リンク | E-08（9-48行目） | ○ |
| C-18 | 通常ユーザーはエディタリンク | E-08（50行目 LinkTo lexical-editor.edit） | ○ |
| C-19 | メトリクス表示（開封率、クリック率） | E-08（151-203行目） | ○ |
| C-20 | 訪問者数表示（webAnalyticsEnabled条件） | E-08（206-228行目） | ○ |
| C-21 | メンバー獲得数表示（membersTrackSources条件） | E-08（231-257行目） | ○ |
| C-22 | アナリティクスボタン遷移先posts-x | E-08（263行目） | ○ |
| C-23 | ContentFilterにPowerSelect5つ | E-09（4-99行目） | ○ |
| C-24 | Author/ContributorはauthorsFilterでフィルタ | E-01（99-106行目） | ○ |
| C-25 | Contributorは選択リスト無効 | E-01（150-151行目） | ○ |
| C-26 | 関連機能No.1,3,40,52 | E-11 | ○ |
| C-27 | 成功モーダルの具体的テキスト内容 | **根拠なし** | △ |
| C-28 | データベーステーブル名posts/users/tags/emails | **根拠なし（推測）** | △ |

## 4) 不足情報（Unknown / Missing）
- **成功モーダルのテキスト内容**
  - modal-post-success.jsの詳細を確認する必要あり
  - 候補：`ghost/admin/app/components/modal-post-success.js` / 関連テンプレート
- **データベーススキーマ**
  - Ember DataモデルからRDBテーブル名への変換は推測
  - 候補：`ghost/core/core/server/data/schema/` / `ghost/core/core/server/models/`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - UI構造・フィルタ仕様は十分な根拠あり
- 1: 中リスク - メッセージ仕様の一部は詳細確認推奨
- 0: 低リスク - コードリーディングガイドは正確

## 6) レビュアーチェックリスト（最小）
- [ ] フィルタ選択肢の表示名が実装と一致しているか確認
- [ ] Contributor権限時の動作制限が網羅されているか確認
- [ ] アナリティクス表示の条件分岐が正確か確認
- [ ] 成功モーダルの実際のメッセージテキストを確認
