---
generated_at: 2026-01-29 20:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：12-ページ一覧画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 特になし。全ての主張に根拠あり。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/admin/app/routes/pages.js`（14行）
- E-02: `ghost/admin/app/controllers/pages.js`（43行）
- E-03: `ghost/admin/app/templates/pages.hbs`（78行）
- E-04: `ghost/admin/app/models/page.js`（5行）
- E-05: `ghost/admin/app/routes/posts.js`（継承元）
- E-06: `ghost/admin/app/controllers/posts.js`（継承元）
- E-07: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL: /ghost/#/pages | E-01（ルート名 pages） | ○ |
| C-02 | PagesRouteはPostsRouteを継承 | E-01（1行目 import, 4行目 extends） | ○ |
| C-03 | modelName = 'page' | E-01（7行目） | ○ |
| C-04 | titleToken = 'Pages' | E-01（11行目） | ○ |
| C-05 | PagesControllerはPostsControllerを継承 | E-02（1行目 import, 33行目 extends） | ○ |
| C-06 | TYPES配列にsentオプションなし | E-02（5-20行目） | ○ |
| C-07 | TYPES: All pages, Draft pages, Published pages, Scheduled pages, Featured pages | E-02（5-20行目） | ○ |
| C-08 | ORDERS: Newest first, Oldest first, Recently updated | E-02（22-31行目） | ○ |
| C-09 | openEditorアクションで'page'タイプ指定 | E-02（40-41行目） | ○ |
| C-10 | テンプレートタイトル「Pages」 | E-03（3行目 @title="Pages"） | ○ |
| C-11 | 新規ページボタン model="page" | E-03（28行目） | ○ |
| C-12 | 空状態メッセージ「Tell the world about yourself.」 | E-03（41行目） | ○ |
| C-13 | 空状態メッセージ「No pages match the current filter」 | E-03（46行目） | ○ |
| C-14 | InfinityLoader triggerOffset=1000 | E-03（60, 66, 72行目） | ○ |
| C-15 | PageモデルはPostModelを継承 | E-04（1, 3行目） | ○ |
| C-16 | displayName = 'page' | E-04（4行目） | ○ |
| C-17 | クエリパラメータはPostsRouteから継承 | E-05（50-56行目）, E-01（継承関係） | ○ |
| C-18 | 関連機能No.2 | E-08 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。ページ一覧画面はPostsの継承構造が明確であり、差分も小さいため高い信頼度となっている。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 継承構造が明確で、差分も少ない
- 0: 低リスク - フィルタ選択肢の違いは明確に文書化
- 0: 低リスク - 空状態メッセージも確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] PostsRoute/Controllerからの継承が正しく動作することを確認
- [ ] ページ固有のフィルタ選択肢（sentなし）が正しく反映されているか確認
- [ ] 実際の画面で空状態メッセージが正しく表示されるか確認
