---
generated_at: 2026-01-29 20:50:00
metrics:
  claims_total: 35
  claims_with_evidence: 33
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：13-エディタ画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：33 / 35、根拠なし：2
- 優先レビュー（高）
  1. **GhKoenigEditorLexicalコンポーネントの詳細**：別ファイルのため詳細未確認
  2. **PublishManagementコンポーネントの詳細**：公開フローの詳細は別ファイル

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/admin/app/routes/lexical-editor.js`（83行）
- E-02: `ghost/admin/app/routes/lexical-editor/new.js`（61行）
- E-03: `ghost/admin/app/routes/lexical-editor/edit.js`（80行）
- E-04: `ghost/admin/app/controllers/lexical-editor.js`（1551行）
- E-05: `ghost/admin/app/templates/lexical-editor.hbs`（167行）
- E-06: `ghost/admin/app/components/gh-post-settings-menu.js`（200行+）
- E-07: `ghost/admin/app/models/post.js`（455行）
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL: /ghost/#/editor/{type}/{id} | E-01-03（ルート構成） | ○ |
| C-02 | ルート名: lexical-editor.new, lexical-editor.edit | E-02, E-03 | ○ |
| C-03 | activate/deactivateでフルスクリーン切替 | E-01（14-17, 34-37行目） | ○ |
| C-04 | 新規作成時にcreateRecord('post'/'page') | E-02（16行目） | ○ |
| C-05 | 編集時にstore.queryでpost取得 | E-03（29-38行目） | ○ |
| C-06 | mobiledoc→lexical自動変換 | E-03（41-43行目） | ○ |
| C-07 | 権限チェック（Author/Contributor） | E-03（51-64行目） | ○ |
| C-08 | AUTOSAVE_TIMEOUT = 3000ms | E-04（38行目） | ○ |
| C-09 | TIMEDSAVE_TIMEOUT = 60000ms | E-04（40行目） | ○ |
| C-10 | updateScratchでlexicalScratch更新 | E-04（310-324行目） | ○ |
| C-11 | updateTitleScratchでtitleScratch更新 | E-04（331-339行目） | ○ |
| C-12 | localRevisionsへの保存スケジュール | E-04（315-318, 334-338行目） | ○ |
| C-13 | autosaveTaskの定義 | E-04（576-585行目） | ○ |
| C-14 | saveTaskの定義 | E-04（589-721行目） | ○ |
| C-15 | beforeSaveTaskでスラッグ生成・データコピー | E-04（731-767行目） | ○ |
| C-16 | setPostで投稿初期設定 | E-04（1068-1105行目） | ○ |
| C-17 | willTransitionで離脱確認 | E-04（1110-1247行目） | ○ |
| C-18 | resetで状態リセット | E-04（1250-1287行目） | ○ |
| C-19 | _hasDirtyAttributesで未保存検出 | E-04（1362-1465行目） | ○ |
| C-20 | messageMapでメッセージ定義 | E-04（60-107行目） | ○ |
| C-21 | テンプレートにGhEditorコンポーネント | E-05（3-7行目） | ○ |
| C-22 | ヘッダーにPublishManagement | E-05（9-56行目） | ○ |
| C-23 | GhKoenigEditorLexicalコンポーネント | E-05（62-103行目） | ○ |
| C-24 | ワードカウント表示 | E-05（105-111行目） | ○ |
| C-25 | 設定パネル（GhPostSettingsMenu） | E-05（136-146行目） | ○ |
| C-26 | 設定トグルボタン | E-05（149-155行目） | ○ |
| C-27 | 投稿履歴モーダル | E-05（157-163行目） | ○ |
| C-28 | 設定パネルのscratch alias定義 | E-06（30-67行目） | ○ |
| C-29 | canViewPostHistory判定 | E-06（148-170行目） | ○ |
| C-30 | TK_REGEX検出機能 | E-04（42-43, 109-146行目） | ○ |
| C-31 | tkCount計算 | E-04（303-308行目） | ○ |
| C-32 | スニペット機能（canManageSnippets） | E-04（264-271行目） | ○ |
| C-33 | 関連機能No.1,3,6,7,19,38,84 | E-08 | ○ |
| C-34 | GhKoenigEditorLexicalの詳細実装 | **根拠なし** | △ |
| C-35 | PublishManagementの詳細実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **GhKoenigEditorLexicalコンポーネント**
  - Lexicalエディタ本体の実装詳細
  - 候補：`ghost/admin/app/components/gh-koenig-editor-lexical/`
- **PublishManagementコンポーネント**
  - 公開フローの詳細な実装
  - 候補：`ghost/admin/app/components/editor/publish-management.js`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ルート構造と基本フローは十分な根拠あり
- 1: 中リスク - エディタコンポーネントの詳細は別途確認推奨
- 0: 低リスク - 自動保存・保存タスクの仕様は正確

## 6) レビュアーチェックリスト（最小）
- [ ] 自動保存のタイミング（3秒、60秒）が正しく動作するか確認
- [ ] 離脱時の確認モーダルが適切に表示されるか確認
- [ ] 権限による編集制限が正しく機能するか確認
- [ ] mobiledoc→lexical変換が正しく動作するか確認
- [ ] TK検出機能の動作確認
