---
generated_at: 2026-01-29 20:55:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：14-投稿復元画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 特になし。全ての主張に根拠あり。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/admin/app/routes/restore-posts.js`（10行）
- E-02: `ghost/admin/app/controllers/restore-posts.js`（22行）
- E-03: `ghost/admin/app/templates/restore-posts.hbs`（50行）
- E-04: `ghost/admin/app/services/local-revisions.js`（280行）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL: /ghost/#/restore-posts | E-01（ルート名） | ○ |
| C-02 | model()でlocalRevisions.findAll()呼び出し | E-01（7-9行目） | ○ |
| C-03 | restorePostTaskの定義 | E-02（9-21行目） | ○ |
| C-04 | 成功通知「Post restored successfully」 | E-02（13行目） | ○ |
| C-05 | エラー通知「Failed to restore post」 | E-02（16行目） | ○ |
| C-06 | ヘッダータイトル「Restore Posts」 | E-03（4-6行目） | ○ |
| C-07 | 説明文の内容 | E-03（10行目） | ○ |
| C-08 | VerticalCollection使用 | E-03（18行目） | ○ |
| C-09 | estimateHeight=60、bufferSize=20 | E-03（18行目） | ○ |
| C-10 | タイトル表示（空の場合「(no title)」） | E-03（21行目） | ○ |
| C-11 | 抜粋表示（100文字まで） | E-03（22行目） | ○ |
| C-12 | 日時表示形式「MMM D, YYYY HH:mm」 | E-03（25行目） | ○ |
| C-13 | 空状態メッセージ「No local revisions found.」 | E-03（44行目） | ○ |
| C-14 | MIN_REVISION_TIME = 60000ms | E-04（15行目） | ○ |
| C-15 | キー形式: post-revision-{id}-{timestamp} | E-04（31-33行目） | ○ |
| C-16 | findAll()でソート（新しい順） | E-04（137行目） | ○ |
| C-17 | restore()の実装 | E-04（231-261行目） | ○ |
| C-18 | 復元時タイトルに「(Restored)」プレフィックス | E-04（242行目） | ○ |
| C-19 | 復元は必ずdraftステータス | E-04（247行目） | ○ |
| C-20 | filterRevisions()で5件制限 | E-04（267-279行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。ローカルリビジョン機能はシンプルな構造で、全ての主張に根拠が存在する。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - localStorage操作は明確に実装されている
- 0: 低リスク - 復元フローは単純で理解しやすい
- 0: 低リスク - エラーハンドリングも適切に実装

## 6) レビュアーチェックリスト（最小）
- [ ] localStorageにリビジョンが保存されることを確認
- [ ] 復元した投稿がエディタで開けることを確認
- [ ] 5件制限が正しく動作することを確認
- [ ] localStorage容量超過時の挙動を確認
