---
generated_at: 2026-01-29 21:05:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：15-タグ一覧画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 特になし。全ての主張に根拠あり。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/admin/app/routes/tags.js`（22行）
- E-02: `ghost/admin/app/templates/tags.hbs`（5行）
- E-03: `ghost/admin/app/models/tag.js`（62行）
- E-04: `apps/posts/src/views/Tags/tags.tsx`（75行）
- E-05: `apps/posts/src/views/Tags/components/tags-header.tsx`（42行）
- E-06: `apps/posts/src/views/Tags/components/tags-list.tsx`（152行）
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL: /ghost/#/tags | E-01（ルート名） | ○ |
| C-02 | Author/Contributorはホームへリダイレクト | E-01（5-10行目） | ○ |
| C-03 | model()でnullを返す | E-01（13-15行目） | ○ |
| C-04 | titleToken = 'Tags' | E-01（17-20行目） | ○ |
| C-05 | AdminX::Postsコンポーネント使用 | E-02（4行目） | ○ |
| C-06 | タグモデル属性（name, slug, description等） | E-03（11-31行目） | ○ |
| C-07 | isInternal/isPublic computed | E-03（33-34行目） | ○ |
| C-08 | #で始まる名前は内部タグ | E-03（38-41行目） | ○ |
| C-09 | typeパラメータのデフォルト値 'public' | E-04（13行目） | ○ |
| C-10 | useBrowseTags使用 | E-04（15-26行目） | ○ |
| C-11 | ローディング/エラー/空状態の分岐 | E-04（32-68行目） | ○ |
| C-12 | 空状態メッセージ「Start organizing your content」 | E-04（56行目） | ○ |
| C-13 | エラーメッセージ「Error loading tags」 | E-04（39行目） | ○ |
| C-14 | ヘッダータイトル「Tags」 | E-05（13行目） | ○ |
| C-15 | タブ「Public tags」「Internal tags」 | E-05（18-27行目） | ○ |
| C-16 | 新規タグボタン「New tag」 | E-05（31-35行目） | ○ |
| C-17 | テーブルヘッダー（Tag, Slug, No. of posts） | E-06（72-80行目） | ○ |
| C-18 | タグ詳細リンク #/tags/{slug} | E-06（102行目） | ○ |
| C-19 | 投稿一覧リンク #/posts?tag={slug} | E-06（121行目） | ○ |
| C-20 | useInfiniteVirtualScroll使用 | E-06（55-62行目） | ○ |
| C-21 | 投稿数表示 | E-06（118-129行目） | ○ |
| C-22 | 関連機能No.3 | E-07 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。ReactコンポーネントとEmberルートの両方を確認し、全ての主張に根拠が存在する。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Ember/React連携構造は明確
- 0: 低リスク - API呼び出しロジックは確認済み
- 0: 低リスク - 権限チェックロジックは確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 公開タグ/内部タグのタブ切り替えが正しく動作するか確認
- [ ] 仮想スクロールで大量のタグが正しく表示されるか確認
- [ ] 投稿数リンクが正しいフィルタで投稿一覧に遷移するか確認
