---
generated_at: 2026-01-29 21:10:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：16-タグ編集画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - 特になし。全ての主張に根拠あり。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/admin/app/routes/tag.js`（93行）
- E-02: `ghost/admin/app/controllers/tag.js`（64行）
- E-03: `ghost/admin/app/templates/tag.hbs`（40行）
- E-04: `ghost/admin/app/models/tag.js`（62行）
- E-05: `ghost/admin/app/components/tags/tag-form.hbs`（100行+）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL: /ghost/#/tags/{slug} | E-01（ルート名、serialize） | ○ |
| C-02 | Author/Contributorはホームへリダイレクト | E-01（16-21行目） | ○ |
| C-03 | model()でqueryRecordまたはcreateRecord | E-01（24-32行目） | ○ |
| C-04 | willTransitionで未保存確認 | E-01（54-77行目） | ○ |
| C-05 | confirmUnsavedChangesモーダル | E-01（79-92行目） | ○ |
| C-06 | tagURL getter | E-02（20-31行目） | ○ |
| C-07 | confirmDeleteTag アクション | E-02（33-38行目） | ○ |
| C-08 | saveTask 定義 | E-02（40-63行目） | ○ |
| C-09 | 新規作成時にInfinityModelに追加 | E-02（51-53行目） | ○ |
| C-10 | replaceRouteで編集URLに遷移 | E-02（55行目） | ○ |
| C-11 | パンくずリスト表示 | E-03（5-10行目） | ○ |
| C-12 | タイトル（新規/編集で分岐） | E-03（11-13行目） | ○ |
| C-13 | Viewボタン | E-03（18行目） | ○ |
| C-14 | 保存ボタン（Cmd+S対応） | E-03（19-25行目） | ○ |
| C-15 | Tags::TagFormコンポーネント | E-03（30行目） | ○ |
| C-16 | 削除ボタン（既存タグのみ） | E-03（33-39行目） | ○ |
| C-17 | タグモデル属性定義 | E-04（11-31行目） | ○ |
| C-18 | updateVisibility処理 | E-04（38-41行目） | ○ |
| C-19 | saveフックでsearch.expireContent | E-04（43-61行目） | ○ |
| C-20 | 名前入力フォーム | E-05（5-25行目） | ○ |
| C-21 | カラー入力（HEXとピッカー） | E-05（27-57行目） | ○ |
| C-22 | スラッグ入力とURLプレビュー | E-05（60-74行目） | ○ |
| C-23 | 説明入力と文字カウント | E-05（76-89行目） | ○ |
| C-24 | 関連機能No.3, 38 | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。ルート、コントローラー、テンプレート、フォームコンポーネントすべてを確認済み。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - CRUD操作は明確に実装されている
- 0: 低リスク - 未保存確認の仕組みは確認済み
- 0: 低リスク - バリデーションは標準的な実装

## 6) レビュアーチェックリスト（最小）
- [ ] 名前が#で始まる場合に内部タグになるか確認
- [ ] 保存後に編集URLにリダイレクトされるか確認
- [ ] 未保存変更がある状態で離脱時に確認モーダルが表示されるか確認
- [ ] 削除確認モーダルの動作確認
