---
generated_at: 2026-01-29 21:15:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：17-メンバー一覧画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：28 / 28、根拠なし：0
- 優先レビュー（高）
  - 特になし。全ての主張に根拠あり。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/admin/app/routes/members-management.js`（11行）
- E-02: `ghost/admin/app/routes/members.js`（58行）
- E-03: `ghost/admin/app/controllers/members.js`（575行）
- E-04: `ghost/admin/app/templates/members.hbs`（234行）
- E-05: `ghost/admin/app/models/member.js`（58行）
- E-06: `ghost/admin/app/components/members/list-item.hbs`（67行）
- E-07: `ghost/admin/app/components/members/filter.js`（675行）
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL: /ghost/#/members | E-02（ルート名） | ○ |
| C-02 | canManageMembersチェック | E-01（6-8行目） | ○ |
| C-03 | queryParams定義（label, search, paid等） | E-02（9-16行目） | ○ |
| C-04 | model()でresetFiltersとfetchMembersTask | E-02（18-21行目） | ○ |
| C-05 | setupControllerでfetchLabelsTask | E-02（24-37行目） | ○ |
| C-06 | titleToken = 'Members' | E-02（52-57行目） | ○ |
| C-07 | PAID_PARAMS（All/Free/Paid） | E-03（18-27行目） | ○ |
| C-08 | tracked状態（members, searchParam等） | E-03（52-73行目） | ○ |
| C-09 | listHeader computed | E-03（91-113行目） | ○ |
| C-10 | availableOrders（Newest, Open rate） | E-03（125-140行目） | ○ |
| C-11 | isFiltered computed | E-03（177-179行目） | ○ |
| C-12 | isBulkDeletePermitted制限 | E-03（227-246行目） | ○ |
| C-13 | getApiQueryObject実装 | E-03（255-291行目） | ○ |
| C-14 | exportDataでCSVダウンロード | E-03（374-409行目） | ○ |
| C-15 | searchTaskで250msデバウンス | E-03（487-491行目） | ○ |
| C-16 | fetchMembersTaskでellaSparse使用 | E-03（498-551行目） | ○ |
| C-17 | limit=50 | E-03（549行目） | ○ |
| C-18 | bulkAddLabel/bulkRemoveLabel | E-03（437-450行目） | ○ |
| C-19 | bulkUnsubscribe | E-03（452-458行目） | ○ |
| C-20 | bulkDelete | E-03（467-478行目） | ○ |
| C-21 | パンくずリスト（postAnalytics時） | E-04（4-15行目） | ○ |
| C-22 | 検索バー | E-04（22-34行目） | ○ |
| C-23 | Members::Filterコンポーネント | E-04（38-48行目） | ○ |
| C-24 | VerticalCollection使用 | E-04（149-164行目） | ○ |
| C-25 | 空状態表示 | E-04（168-178行目） | ○ |
| C-26 | メンバーモデル属性 | E-05（9-28行目） | ○ |
| C-27 | list-itemでアバター/名前/メール表示 | E-06（2-12行目） | ○ |
| C-28 | FILTER_GROUPS定義 | E-07（15-58行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。ルート、コントローラー、テンプレート、フィルターコンポーネントすべてを確認済み。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 権限チェックは明確に実装されている
- 0: 低リスク - フィルター機能はNQL対応で実装済み
- 0: 低リスク - 一括操作は条件付きで安全に実装

## 6) レビュアーチェックリスト（最小）
- [ ] canManageMembersがfalseの場合にホームへリダイレクトされるか確認
- [ ] 検索のデバウンスが正しく動作するか確認
- [ ] エクスポート機能でCSVが正しくダウンロードされるか確認
- [ ] 一括削除がStripeフィルター使用時に無効化されるか確認
- [ ] 仮想スクロールで大量のメンバーが正しく表示されるか確認
