---
generated_at: 2026-01-29 21:25:00
metrics:
  claims_total: 30
  claims_with_evidence: 30
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：18-メンバー詳細画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：30 / 30、根拠なし：0
- 優先レビュー（高）
  - 特になし。全ての主張に根拠あり。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/admin/app/routes/member.js`（123行）
- E-02: `ghost/admin/app/controllers/member.js`（284行）
- E-03: `ghost/admin/app/templates/member.hbs`（129行）
- E-04: `ghost/admin/app/models/member.js`（58行）
- E-05: `ghost/admin/app/components/gh-member-settings-form.hbs`（296行）
- E-06: `ghost/admin/app/components/gh-member-settings-form.js`（242行）
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL: /ghost/#/members/{member_id} | E-01（ルート名） | ○ |
| C-02 | model()でqueryRecordまたはcreateRecord | E-01（25-33行目） | ○ |
| C-03 | setupControllerでsetInitialRelationshipValues | E-01（35-48行目） | ○ |
| C-04 | willTransitionで未保存確認 | E-01（72-97行目） | ○ |
| C-05 | confirmUnsavedChangesでモーダル表示 | E-01（99-108行目） | ○ |
| C-06 | titleToken()でメンバー名を返す | E-01（120-122行目） | ○ |
| C-07 | SCRATCH_PROPS定義 | E-02（11行目） | ○ |
| C-08 | dirtyAttributes getter | E-02（61-63行目） | ○ |
| C-09 | scratchMember computed | E-02（95-99行目） | ○ |
| C-10 | subscribedAt computed | E-02（101-105行目） | ○ |
| C-11 | confirmDeleteMember | E-02（137-147行目） | ○ |
| C-12 | confirmLogoutMember | E-02（149-157行目） | ○ |
| C-13 | toggleImpersonateMemberModal | E-02（159-162行目） | ○ |
| C-14 | saveTask実装 | E-02（176-220行目） | ○ |
| C-15 | fetchMemberTask実装 | E-02（222-234行目） | ○ |
| C-16 | _hasDirtyAttributes実装 | E-02（253-283行目） | ○ |
| C-17 | パンくずリスト（postAnalytics対応） | E-03（4-30行目） | ○ |
| C-18 | タイトル（新規/既存分岐） | E-03（31-37行目） | ○ |
| C-19 | アクションメニュー | E-03（41-94行目） | ○ |
| C-20 | GhTaskButton保存ボタン | E-03（96行目） | ○ |
| C-21 | GhMemberSettingsFormコンポーネント | E-03（102-109行目） | ○ |
| C-22 | impersonate-memberモーダル | E-03（114-120行目） | ○ |
| C-23 | members-label-formモーダル | E-03（122-129行目） | ○ |
| C-24 | 名前・メールアドレス入力 | E-05（8-40行目） | ○ |
| C-25 | ラベル選択（GhMemberLabelInput） | E-05（42-54行目） | ○ |
| C-26 | メモ入力（500文字制限） | E-05（56-70行目） | ○ |
| C-27 | サブスクリプション情報表示 | E-05（82-280行目） | ○ |
| C-28 | isAddComplimentaryAllowed | E-06（27-46行目） | ○ |
| C-29 | cancelSubscriptionTask | E-06（164-180行目） | ○ |
| C-30 | continueSubscriptionTask | E-06（209-225行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。ルート、コントローラー、テンプレート、フォームコンポーネントすべてを確認済み。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 未保存変更の検出ロジックは明確
- 0: 低リスク - サブスクリプション操作はStripe連携で実装済み
- 0: 低リスク - 権限チェックは基底クラスで実装

## 6) レビュアーチェックリスト（最小）
- [ ] 新規メンバー作成時に名前フィールドがフォーカスされるか確認
- [ ] 未保存変更がある状態で離脱時に確認モーダルが表示されるか確認
- [ ] サブスクリプションのキャンセル/継続が正しく動作するか確認
- [ ] Impersonateでサインインリンクが生成されるか確認
- [ ] 削除後にメンバー一覧画面へ遷移するか確認
