---
generated_at: 2026-01-29 21:35:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：19-メンバーインポート画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - 特になし。全ての主張に根拠あり。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/admin/app/routes/members/import.js`（3行）
- E-02: `ghost/admin/app/controllers/members/import.js`（27行）
- E-03: `ghost/admin/app/templates/members/import.hbs`（4行）
- E-04: `ghost/admin/app/components/modal-import-members.js`（236行）
- E-05: `ghost/admin/app/components/modal-import-members.hbs`（190行）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL: /ghost/#/members/import | E-01（ルート名） | ○ |
| C-02 | MembersManagementRoute継承 | E-01（1-3行目） | ○ |
| C-03 | refreshMembersでラベルフィルター適用 | E-02（10-17行目） | ○ |
| C-04 | closeでmembersへ遷移 | E-02（19-26行目） | ○ |
| C-05 | GhFullscreenModal呼び出し | E-03（1-4行目） | ○ |
| C-06 | state初期値 'INIT' | E-04（23行目） | ○ |
| C-07 | uploadUrl = /members/upload/ | E-04（40-42行目） | ○ |
| C-08 | formData computed（file, labels, mapping） | E-04（44-63行目） | ○ |
| C-09 | setFileでstate=MAPPING | E-04（66-69行目） | ○ |
| C-10 | setMappingResult | E-04（71-73行目） | ○ |
| C-11 | upload()でgenerateRequest | E-04（79-86行目） | ○ |
| C-12 | reset()で状態初期化 | E-04（88-96行目） | ○ |
| C-13 | closeModalでUPLOADING中は閉じない | E-04（98-102行目） | ○ |
| C-14 | generateRequestでajax.post | E-04（108-130行目） | ○ |
| C-15 | AcceptedResponseでPROCESSING | E-04（120-121行目） | ○ |
| C-16 | _uploadSuccessでエラーCSV生成 | E-04（132-200行目） | ○ |
| C-17 | import_labelをstoreに保存 | E-04（191-195行目） | ○ |
| C-18 | _uploadErrorでエラー種別判定 | E-04（202-235行目） | ○ |
| C-19 | INIT状態のUI | E-05（2-7行目） | ○ |
| C-20 | MAPPING状態のUI | E-05（9-13行目、53-61行目） | ○ |
| C-21 | PROCESSING状態のUI | E-05（15-20行目、63-69行目） | ○ |
| C-22 | COMPLETE状態のUI | E-05（22-35行目、71-98行目） | ○ |
| C-23 | ERROR状態のUI | E-05（37-41行目、100-105行目） | ○ |
| C-24 | エラーファイルダウンロードリンク | E-05（139-141行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。ルート、コントローラー、モーダルコンポーネントすべてを確認済み。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 状態遷移は明確に実装されている
- 0: 低リスク - エラーハンドリングは種別ごとに実装済み
- 0: 低リスク - エラーCSV生成ロジックは確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] CSVファイル選択後にカラムマッピング画面に遷移するか確認
- [ ] emailカラムなしでインポートするとエラーになるか確認
- [ ] 大量インポート時にPROCESSING状態になるか確認
- [ ] エラーがある場合にエラーCSVがダウンロードできるか確認
- [ ] インポート完了後にimport_labelでフィルターされるか確認
