---
generated_at: 2026-01-29 20:35:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：2-サインイン確認画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/admin/app/templates/signin-verify.hbs` - 検証フォームテンプレート
- E-02: `ghost/admin/app/routes/signin-verify.js` - 検証ルート定義
- E-03: `ghost/admin/app/controllers/signin-verify.js` - 検証コントローラー
- E-04: `ghost/admin/app/authenticators/cookie.js` - Cookie認証実装
- E-05: `ghost/core/core/server/api/endpoints/session.js` - セッションAPIエンドポイント
- E-06: `ghost/core/core/server/services/auth/session/middleware.js` - セッションミドルウェア
- E-07: `ghost/core/core/server/services/auth/session/session-service.js` - セッションサービス
- E-08: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-09: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 6桁の検証コードを入力して認証 | E-01 (21-34行目), E-03 (34-38行目) | ○ |
| C-02 | 2FA必須時と新規デバイス時でヘッダーが異なる | E-01 (7行目: twoFactorRequired条件分岐) | ○ |
| C-03 | 説明文も条件で異なる | E-01 (11-15行目) | ○ |
| C-04 | サインイン画面から遷移 | E-03 (72-77行目: session.errorCodeチェック) | ○ |
| C-05 | 検証成功時ホーム画面へ遷移 | E-03 (105-106行目: session.authenticate) | ○ |
| C-06 | URL: /ghost/signin-verify | E-02, E-08 | ○ |
| C-07 | 検証コードは必須バリデーション | E-03 (28-31行目) | ○ |
| C-08 | 検証コードは6桁数字のみ | E-03 (34-38行目: /^\d{6}$/) | ○ |
| C-09 | Verifyボタンでverify処理実行 | E-01 (55-62行目), E-03 (96-117行目) | ○ |
| C-10 | PUT /session/verifyで検証 | E-04 (23-32行目) | ○ |
| C-11 | 再送信ボタンで新コード送信 | E-01 (36-51行目), E-03 (119-139行目) | ○ |
| C-12 | POST /session/verifyで再送信 | E-03 (121行目) | ○ |
| C-13 | 15秒のクールダウン | E-03 (16行目, 141-148行目) | ○ |
| C-14 | sessions.verified更新 | E-06 (75-77行目), E-07 (297-300行目) | ○ |
| C-15 | "Verification code is required"エラー | E-03 (29行目) | ○ |
| C-16 | "Verification code must be 6 numbers"エラー | E-03 (35行目) | ○ |
| C-17 | "Your verification code is incorrect."エラー | E-03 (109行目) | ○ |
| C-18 | OTP検証にadmin_session_secret使用 | E-07 (127-128行目, 173-174行目) | ○ |
| C-19 | 検証メールにデバイス情報含む | E-07 (222-236行目, 273行目) | ○ |
| C-20 | 位置情報をIPから取得 | E-07 (192-220行目: getGeolocationFromIP) | ○ |
| C-21 | staffDeviceVerificationで無効化可能 | E-07 (133-135行目) | ○ |
| C-22 | require_email_mfa設定で2FA必須判定 | E-07 (99-101行目) | ○ |
| C-23 | セッションにuser_id、origin、user_agent、ip保存 | E-07 (120-123行目) | ○ |
| C-24 | CSRF保護あり | E-07 (78-92行目: cookieCsrfProtection) | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし。全ての主張に対して十分な根拠が確認できた。

## 5) リスクフラグ（レビュー観点）

- **0（低リスク）**：入出力項目・バリデーション - コードから明確に確認可能
- **0（低リスク）**：画面遷移 - コントローラー・authenticatorから確認可能
- **0（低リスク）**：エラーメッセージ - コントローラーから確認可能
- **0（低リスク）**：セッション更新仕様 - session-serviceから確認可能
- **0（低リスク）**：OTP検証ロジック - otpライブラリ使用が確認可能

## 6) レビュアーチェックリスト（最小）

- [ ] 2FA必須設定（require_email_mfa）のON/OFFでの動作確認
- [ ] 新規デバイス検出のロジックが期待通りか確認
- [ ] OTPトークンの有効期限設定を確認
- [ ] 再送信クールダウン（15秒）が正しく動作するか確認
- [ ] メール送信失敗時のエラーハンドリングを確認
