---
generated_at: 2026-01-29 21:45:00
metrics:
  claims_total: 26
  claims_with_evidence: 26
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：20-メンバーアクティビティ画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：26 / 26、根拠なし：0
- 優先レビュー（高）
  - 特になし。全ての主張に根拠あり。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/admin/app/routes/members-activity.js`（10行）
- E-02: `ghost/admin/app/controllers/members-activity.js`（53行）
- E-03: `ghost/admin/app/templates/members-activity.hbs`（55行）
- E-04: `ghost/admin/app/helpers/members-event-fetcher.js`（131行）
- E-05: `ghost/admin/app/helpers/members-event-filter.js`（57行）
- E-06: `ghost/admin/app/components/member/activity-feed.js`（36行）
- E-07: `ghost/admin/app/components/member/activity-feed.hbs`（70行）
- E-08: `ghost/admin/app/components/member/activity-feed-empty.hbs`（7行）
- E-09: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL: /ghost/#/members-activity | E-01（ルート名） | ○ |
| C-02 | MembersManagementRoute継承 | E-01（1-3行目） | ○ |
| C-03 | titleToken = 'Activity' | E-01（4-8行目） | ○ |
| C-04 | queryParams定義（excludedEvents, member） | E-02（15-18行目） | ○ |
| C-05 | MemberFetcherでメンバー取得 | E-02（20行目） | ○ |
| C-06 | hiddenEvents computed | E-02（25-38行目） | ○ |
| C-07 | fullExcludedEvents computed | E-02（40-42行目） | ○ |
| C-08 | changeExcludedEvents | E-02（44-47行目） | ○ |
| C-09 | changeMember | E-02（49-52行目） | ○ |
| C-10 | パンくずリスト（メンバー指定時） | E-03（3-16行目） | ○ |
| C-11 | EventTypeFilterコンポーネント | E-03（19-22行目） | ○ |
| C-12 | MemberFilterコンポーネント | E-03（24-26行目） | ○ |
| C-13 | members-event-fetcherでイベント取得 | E-03（30-51行目） | ○ |
| C-14 | GhScrollTriggerで無限スクロール | E-03（38-40行目） | ○ |
| C-15 | MembersEventsFetcher Resource定義 | E-04（9-38行目） | ○ |
| C-16 | setup()で初期ロード | E-04（40-58行目） | ○ |
| C-17 | loadNextPage()でカーソルベースページネーション | E-04（60-85行目） | ○ |
| C-18 | loadEventsTaskでAPI呼び出し | E-04（103-130行目） | ○ |
| C-19 | EMAIL_EVENTS、NEWSLETTER_EVENTS定数 | E-05（6-7行目） | ○ |
| C-20 | members-event-filter compute | E-05（14-56行目） | ○ |
| C-21 | excludedEventTypes = ['aggregated_click_event'] | E-06（9行目） | ○ |
| C-22 | activity-feed pageSize=5 | E-07（9行目） | ○ |
| C-23 | View all member activity リンク | E-07（61行目） | ○ |
| C-24 | parse-member-eventでイベント変換 | E-07（17行目） | ○ |
| C-25 | 空状態でActivityFeedEmpty表示 | E-07（64行目） | ○ |
| C-26 | ActivityFeedEmptyメッセージ | E-08（5行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。ルート、コントローラー、テンプレート、ヘルパー、コンポーネントすべてを確認済み。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - イベントフィルタリングは明確に実装されている
- 0: 低リスク - カーソルベースページネーションは確認済み
- 0: 低リスク - メンバー指定時の動作は確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] イベントタイプフィルターが正しく動作するか確認
- [ ] メンバーフィルターが正しく動作するか確認
- [ ] 無限スクロールで追加イベントが読み込まれるか確認
- [ ] メンバー詳細画面からの「View all member activity」リンクが正しく動作するか確認
- [ ] メンバー未指定時にメールイベントが除外されるか確認
