---
generated_at: 2026-01-29 20:30:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：21-統計（Analytics）画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **権限による表示制御**：具体的なロールチェックコードの確認が必要
  2. **Ember側のURL**：stats-x.hbsとEmberルートの関係確認

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/stats/src/app.tsx` - Appコンポーネント定義
- E-02: `apps/stats/src/routes.tsx` - ルーティング定義（10-32行目）
- E-03: `apps/stats/src/providers/global-data-provider.tsx` - GlobalDataProvider実装
- E-04: `apps/stats/src/views/Stats/Overview/overview.tsx` - Overview画面実装
- E-05: `apps/stats/src/views/Stats/Web/web.tsx` - Web画面実装（176-179行目でWebアナリティクス無効時リダイレクト）
- E-06: `apps/stats/src/views/Stats/Growth/growth.tsx` - Growth画面実装
- E-07: `apps/stats/src/views/Stats/Newsletters/newsletters.tsx` - Newsletters画面実装（367-370行目でニュースレター無効時リダイレクト）
- E-08: `apps/stats/src/views/Stats/layout/stats-layout.tsx` - レイアウトコンポーネント
- E-09: `ghost/admin/app/templates/stats-x.hbs` - Ember側テンプレート
- E-10: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（21行目）
- E-11: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング（42行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 統計画面はReactアプリ（apps/stats）で構成される | E-01, E-02 | ○ |
| C-02 | URLは/ghost/analyticsでアクセス可能 | E-02, E-09 | ○ |
| C-03 | 日付範囲選択機能がある | E-03, E-04 | ○ |
| C-04 | Overview/Web/Growth/Newslettersの4タブ構成 | E-02 | ○ |
| C-05 | Tinybirdと連携してデータ取得 | E-03, E-04, E-05 | ○ |
| C-06 | useTinybirdQueryフックでAPI呼び出し | E-04, E-05 | ○ |
| C-07 | api_kpis, api_top_sources, api_top_locationsエンドポイント使用 | E-04, E-05 | ○ |
| C-08 | GlobalDataProviderでグローバルstate管理 | E-03 | ○ |
| C-09 | StatsErrorBoundaryでエラーハンドリング | E-01 | ○ |
| C-10 | ShadeAppでUIコンポーネント提供 | E-01 | ○ |
| C-11 | Webアナリティクス無効時はリダイレクト | E-05 | ○ |
| C-12 | ニュースレター無効時はリダイレクト | E-07 | ○ |
| C-13 | 訪問者数KPIを表示 | E-04 | ○ |
| C-14 | メンバー数KPIを表示 | E-04 | ○ |
| C-15 | MRR KPIを表示 | E-04 | ○ |
| C-16 | トップコンテンツ一覧を表示 | E-04, E-05 | ○ |
| C-17 | トップソース一覧を表示 | E-05 | ○ |
| C-18 | 投稿分析画面への遷移が可能 | E-04 | ○ |
| C-19 | useGrowthStatsフックで成長データ取得 | E-04, E-06 | ○ |
| C-20 | useLatestPostStatsフックで最新投稿取得 | E-04 | ○ |
| C-21 | useBrowseNewslettersでニュースレター一覧取得 | E-07 | ○ |
| C-22 | useSubscriberCountWithRangeで購読者数取得 | E-07 | ○ |
| C-23 | StatsLayoutコンポーネントで共通レイアウト | E-08 | ○ |
| C-24 | STATS_RANGE_OPTIONSで期間オプション定義 | E-03 | ○ |
| C-25 | selectedNewsletterIdでニュースレター選択管理 | E-03 | ○ |
| C-26 | inAdminForward機能フラグでEmber/React切替 | E-09 | ○ |
| C-27 | 管理者・編集者ロールのみアクセス可能 | **根拠なし** | △ |
| C-28 | /ghost/#/stats-xがEmber側URL | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-27（権限制御）：具体的なロールチェックはEmber側のルートまたはサーバー側で実装されている可能性があるが、apps/stats内では確認できなかった
  - 候補：`ghost/admin/app/routes/stats-x.js` / `ghost/core/core/server/api/` / `ghost/admin/app/abilities/`
- C-28（Ember側URL）：stats-x.hbsの存在は確認したが、Ember側のルート定義ファイルは未確認
  - 候補：`ghost/admin/app/router.js` / `ghost/admin/app/routes/stats-x.js`

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: Reactコンポーネント構造、データフロー、API連携
- **1（中リスク）**: Ember-React連携の詳細、URL構造の正確性
- **2（高リスク）**: 権限制御の実装詳細（セキュリティ関連）

## 6) レビュアーチェックリスト（最小）
- [ ] 権限制御の実装箇所を確認（Ember側ルートまたはサーバーAPI）
- [ ] stats-x.hbsとEmberルーターの関係を確認
- [ ] Tinybird APIのエンドポイント仕様との整合性確認
- [ ] 日付範囲オプションの値（7, 30, 90等）が正確か確認
