---
generated_at: 2026-01-29 20:32:00
metrics:
  claims_total: 25
  claims_with_evidence: 25
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：22-統計概要画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：25 / 25、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠が確認できたため、特記事項なし

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/stats/src/views/Stats/Overview/overview.tsx` - Overviewコンポーネント（全247行）
- E-02: `apps/stats/src/routes.tsx` - ルーティング定義（15-17行目: indexルート）
- E-03: `apps/stats/src/providers/global-data-provider.tsx` - GlobalDataProvider
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（22行目）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング（43-44行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | /analyticsがインデックスルート | E-02（15-17行目） | ○ |
| C-02 | useGlobalDataでstatsConfig/range取得 | E-01（68行目）, E-03 | ○ |
| C-03 | useGrowthStatsでchartData/totals取得 | E-01（70行目） | ○ |
| C-04 | useLatestPostStatsで最新投稿取得 | E-01（71行目） | ○ |
| C-05 | useTopPostsViewsでTop5投稿取得 | E-01（72-79行目） | ○ |
| C-06 | useTinybirdQueryでapi_kpis呼び出し | E-01（91-95行目） | ○ |
| C-07 | visitorsParamsにsite_uuid/date_from/date_to/timezone含む | E-01（83-89行目） | ○ |
| C-08 | visitorsChartDataをsanitizeChartDataで正規化 | E-01（97-108行目） | ○ |
| C-09 | membersChartDataでfree+paidの合計を計算 | E-01（143-147行目） | ○ |
| C-10 | mrrChartDataでcentsToDollars変換 | E-01（168行目） | ○ |
| C-11 | paidMembersEnabled判定でMRR表示制御 | E-01（156行目） | ○ |
| C-12 | OverviewKPIsコンポーネントにチャートデータ渡す | E-01（204-213行目） | ○ |
| C-13 | LatestPostコンポーネントで最新投稿表示 | E-01（214-217行目） | ○ |
| C-14 | TopPostsコンポーネントで人気投稿表示 | E-01（218-221行目） | ○ |
| C-15 | HelpCardで外部ヘルプリンク表示 | E-01（224-239行目） | ○ |
| C-16 | ghost.org/help/native-analyticsへリンク | E-01（227行目） | ○ |
| C-17 | ghost.org/resources/content-distributionへリンク | E-01（235行目） | ○ |
| C-18 | DateRangeSelectでexcludeRanges=['today']指定 | E-01（200行目） | ○ |
| C-19 | StatsLayoutでレイアウトラップ | E-01（197行目） | ○ |
| C-20 | StatsHeaderでヘッダー表示 | E-01（198-201行目） | ○ |
| C-21 | StatsViewでローディング制御 | E-01（203行目） | ○ |
| C-22 | visitorsYRangeで負の値除外 | E-01（116-118行目） | ○ |
| C-23 | kpiValuesで総訪問者数計算 | E-01（178-192行目） | ○ |
| C-24 | isPageLoading = isConfigLoading | E-01（194行目） | ○ |
| C-25 | 機能No.51サイト統計、52記事分析と関連 | E-05（43-44行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] sanitizeChartDataのデータ正規化ロジックが要件通りか確認
- [ ] centsToDollarsの変換精度確認
- [ ] OverviewKPIsコンポーネントのチャート表示が期待通りか確認
