---
generated_at: 2026-01-29 20:35:00
metrics:
  claims_total: 30
  claims_with_evidence: 30
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：23-Webトラフィック画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：30 / 30、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠が確認できたため、特記事項なし

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/stats/src/views/Stats/Web/web.tsx` - Webコンポーネント（全241行）
- E-02: `apps/stats/src/routes.tsx` - ルーティング定義（18-21行目）
- E-03: `apps/stats/src/hooks/use-filter-params.ts` - フィルタURL同期フック
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（23行目）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング（45-46行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | /analytics/webがルートパス | E-02（18-21行目） | ○ |
| C-02 | webAnalytics無効時は/analyticsにリダイレクト | E-01（176-179行目） | ○ |
| C-03 | useFilterParamsでフィルタURL同期 | E-01（59行目）, E-03 | ○ |
| C-04 | KPI_METRICSでvisits/views/bounce-rate/visit-duration定義 | E-01（26-51行目） | ○ |
| C-05 | formatNumber/formatPercentage/formatDurationフォーマッター使用 | E-01（31, 38, 44, 50行目） | ○ |
| C-06 | オーディエンスフィルタでall/free/paid絞り込み | E-01（62-65行目） | ○ |
| C-07 | filterParamsでsource/location/post/utm_*パラメータ構築 | E-01（81-118行目） | ○ |
| C-08 | post_uuidとpathnameの判定（'/'で始まるか） | E-01（103-111行目） | ○ |
| C-09 | handleFilterClickでクリックフィルタリング | E-01（121-134行目） | ○ |
| C-10 | handleLocationClickでロケーションフィルタ | E-01（136行目） | ○ |
| C-11 | handleSourceClickでソースフィルタ | E-01（137行目） | ○ |
| C-12 | scrollToTopでフィルタ適用後ページ先頭へ | E-01（72-77行目, 133行目） | ○ |
| C-13 | useTinybirdQueryでapi_kpis呼び出し | E-01（150-154行目） | ○ |
| C-14 | useTinybirdQueryでapi_top_sources呼び出し | E-01（157-161行目） | ○ |
| C-15 | useTinybirdQueryでapi_top_locations呼び出し | E-01（164-168行目） | ○ |
| C-16 | paramsにsite_uuid/date_from/date_to/timezone/member_status含む | E-01（140-147行目） | ○ |
| C-17 | totalVisitorsはkpiDataから集計 | E-01（171行目） | ○ |
| C-18 | WebKPIsコンポーネントにkpiData渡す | E-01（204-208行目） | ○ |
| C-19 | TopContentコンポーネント表示 | E-01（212-217行目） | ○ |
| C-20 | SourcesCardコンポーネント表示 | E-01（218-227行目） | ○ |
| C-21 | LocationsCardコンポーネント表示 | E-01（229-234行目） | ○ |
| C-22 | siteUrl/siteIconをglobalDataから取得 | E-01（68-69行目） | ○ |
| C-23 | STATS_DEFAULT_SOURCE_ICON_URLをSourcesCardに渡す | E-01（220行目） | ○ |
| C-24 | hasFiltersでフィルタ適用状態判定 | E-01（183行目） | ○ |
| C-25 | フィルタ適用時はDateRangeSelectの位置が変わる | E-01（188-199行目） | ○ |
| C-26 | StatsLayoutでレイアウトラップ | E-01（186行目） | ○ |
| C-27 | StatsHeaderでヘッダー表示 | E-01（187-200行目） | ○ |
| C-28 | StatsViewでローディング制御 | E-01（201行目） | ○ |
| C-29 | Cardコンポーネント内にWebKPIs配置 | E-01（202-210行目） | ○ |
| C-30 | 機能No.51サイト統計、55Tinybird連携と関連 | E-05（45-46行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] フィルタパラメータのURLエンコーディングが正しいか確認
- [ ] "Direct"トラフィック（source=""）のフィルタリングが正常に動作するか確認
- [ ] Unknown地域の集約ロジックが期待通りか確認
