---
generated_at: 2026-01-29 20:38:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：24-成長分析画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：28 / 28、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠が確認できたため、特記事項なし

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/stats/src/views/Stats/Growth/growth.tsx` - Growthコンポーネント（全281行）
- E-02: `apps/stats/src/routes.tsx` - ルーティング定義（22-25行目）
- E-03: `apps/stats/src/hooks/use-growth-stats.ts` - 成長統計フック
- E-04: `apps/stats/src/hooks/use-top-posts-stats-with-range.ts` - トップ投稿フック
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（24行目）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング（47-48行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | /analytics/growthがルートパス | E-02（22-25行目） | ○ |
| C-02 | useGrowthStatsでchartData/totals/currencySymbol取得 | E-01（57行目）, E-03 | ○ |
| C-03 | useTopPostsStatsWithRangeでトップ投稿取得 | E-01（60-64行目）, E-04 | ○ |
| C-04 | sortByのデフォルトは'free_members desc' | E-01（48行目） | ○ |
| C-05 | selectedContentTypeのデフォルトはposts_and_pages | E-01（49行目） | ○ |
| C-06 | initialTabはURLのtabパラメータから取得 | E-01（54行目） | ○ |
| C-07 | CONTENT_TYPES定数でposts_and_pages/posts/pages/sources定義 | E-01（11, 49, 163-166行目） | ○ |
| C-08 | transformedTopPostsで重複排除（post_id/titleキー） | E-01（69-91行目） | ○ |
| C-09 | パーセンテージ計算はsortByに依存 | E-01（100-108行目） | ○ |
| C-10 | paidMembersEnabledでPaid/MRRカラム表示制御 | E-01（171, 179-192行目） | ○ |
| C-11 | membersTrackSources無効時はDisabledSourcesIndicator表示 | E-01（212-217行目） | ○ |
| C-12 | SortButtonでfree_members/paid_members/mrr descのソート | E-01（172-189行目） | ○ |
| C-13 | Sourcesタブ選択時はGrowthSourcesコンポーネント表示 | E-01（195-202行目） | ○ |
| C-14 | getClickHandlerで投稿分析画面へ遷移 | E-01（228行目） | ○ |
| C-15 | centsToDollarsでMRRをドル変換 | E-01（10, 251行目） | ○ |
| C-16 | formatDisplayDateでpublished_at表示 | E-01（237-238行目） | ○ |
| C-17 | siteTimezoneはsettingsから取得 | E-01（46行目） | ○ |
| C-18 | GrowthKPIsにchartData/totals/currencySymbol/subscriptionData渡す | E-01（139-146行目） | ○ |
| C-19 | CardでTotal members表示 | E-01（137-148行目） | ○ |
| C-20 | CardでTop content表示 | E-01（149-274行目） | ○ |
| C-21 | CardHeaderにgetContentTitle結果表示 | E-01（151行目） | ○ |
| C-22 | CardDescriptionにgetGrowthContentDescription表示 | E-01（152行目） | ○ |
| C-23 | TableでPosts & pages/Posts/Pages/Sourcesタブ切り替え | E-01（159-168行目） | ○ |
| C-24 | データなし時はEmptyIndicator表示 | E-01（257-266行目） | ○ |
| C-25 | StatsLayoutでレイアウトラップ | E-01（130行目） | ○ |
| C-26 | StatsHeaderでヘッダー表示 | E-01（131-134行目） | ○ |
| C-27 | StatsViewでローディング制御 | E-01（136行目） | ○ |
| C-28 | 機能No.53メンバー分析、92メンバー属性と関連 | E-06（47-48行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 重複排除ロジック（post_id/titleキー）が期待通りか確認
- [ ] パーセンテージ計算のsortBy依存ロジックが正しいか確認
- [ ] GrowthSourcesコンポーネントのソート・表示が正常か確認
