---
generated_at: 2026-01-29 20:41:00
metrics:
  claims_total: 30
  claims_with_evidence: 30
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：25-ニュースレター分析画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：30 / 30、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠が確認できたため、特記事項なし

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/stats/src/views/Stats/Newsletters/newsletters.tsx` - Newslettersコンポーネント（全408行）
- E-02: `apps/stats/src/routes.tsx` - ルーティング定義（26-29行目）
- E-03: `apps/stats/src/hooks/use-newsletter-stats-with-range.ts` - ニュースレター統計フック
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（25行目）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング（49行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | /analytics/newslettersがルートパス | E-02（26-29行目） | ○ |
| C-02 | newslettersEnabled無効時は/analyticsにリダイレクト | E-01（367-370行目） | ○ |
| C-03 | useGlobalDataでrange/selectedNewsletterId取得 | E-01（226行目） | ○ |
| C-04 | initialTabはURLのtabパラメータから取得 | E-01（231行目） | ○ |
| C-05 | useBrowseNewslettersでニュースレター一覧取得（limit:50） | E-01（234-238行目） | ○ |
| C-06 | shouldFetchStatsでデータ取得条件判定 | E-01（244行目） | ○ |
| C-07 | useSubscriberCountWithRangeで購読者推移取得 | E-01（247-251行目）, E-03 | ○ |
| C-08 | useNewsletterStatsWithRangeSplitで統計取得 | E-01（255-260行目）, E-03 | ○ |
| C-09 | isClicksLoadingでクリックデータ遅延ローディング | E-01（255行目, 106-113行目） | ○ |
| C-10 | selectedNewsletterをニュースレター一覧から検索 | E-01（263-268行目） | ○ |
| C-11 | totalsで購読者数/平均開封率/平均クリック率計算 | E-01（271-295行目） | ○ |
| C-12 | newsletter.count.active_membersから購読者数取得 | E-01（273-274行目） | ○ |
| C-13 | 平均開封率は全statsのopen_rate合計/件数 | E-01（283-284行目） | ○ |
| C-14 | 平均クリック率は全statsのclick_rate合計/件数 | E-01（285行目） | ○ |
| C-15 | subscribersDataでチャート用時系列データ作成 | E-01（298-340行目） | ○ |
| C-16 | データなし時は日別0ポイント生成 | E-01（300-315行目） | ○ |
| C-17 | avgsDataでバーチャート用データ作成 | E-01（343-358行目） | ○ |
| C-18 | NewsletterKPIsにsubscribersData/totals/avgsData渡す | E-01（385-392行目） | ○ |
| C-19 | TopNewslettersTableでテーブル表示 | E-01（395-399行目） | ○ |
| C-20 | NewsletterTableRowsはReact.memoで最適化 | E-01（139, 141行目） | ○ |
| C-21 | NewsletterTableHeaderはReact.memoで最適化 | E-01（193, 194行目） | ○ |
| C-22 | TopNewslettersTableはReact.memoで最適化 | E-01（221, 223行目） | ○ |
| C-23 | sortByデフォルトは'open_rate desc' | E-01（202行目） | ○ |
| C-24 | SortButtonでdate/sent_to/open_rate/click_rateソート | E-01（166-188行目） | ○ |
| C-25 | emailTrackOpensEnabled/emailTrackClicksEnabledでカラム表示制御 | E-01（51, 97-98, 104-105, 175-188行目） | ○ |
| C-26 | ホバー時にrate -> count表示切替 | E-01（99-101, 109-112行目） | ○ |
| C-27 | 投稿クリックで/posts/analytics/:postIdに遷移 | E-01（79-81行目） | ○ |
| C-28 | データなし時はEmptyIndicator表示 | E-01（120-129行目） | ○ |
| C-29 | StatsLayoutでレイアウトラップ | E-01（373行目） | ○ |
| C-30 | 機能No.22メール分析と関連 | E-05（49行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 購読者数計算（active_members vs subscriberStatsData）の優先順位確認
- [ ] クリックデータの遅延ローディングが正常に動作するか確認
- [ ] 複数ニュースレター選択時のデータ統合ロジック確認
