---
generated_at: 2026-01-29 20:44:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：26-投稿分析画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：28 / 28、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠が確認できたため、特記事項なし

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/posts/src/routes.tsx` - ルーティング定義（全81行）
- E-02: `apps/posts/src/views/PostAnalytics/post-analytics.tsx` - PostAnalyticsコンポーネント（全19行）
- E-03: `apps/posts/src/providers/post-analytics-context.tsx` - PostAnalyticsProvider（全128行）
- E-04: `ghost/admin/app/templates/posts-x.hbs` - Ember側テンプレート
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（26行目）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング（50行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | /posts/analytics/:postIdがルートパス | E-01（19行目） | ○ |
| C-02 | PostAnalyticsProviderとPostAnalyticsを動的インポート | E-01（20-34行目） | ○ |
| C-03 | 子ルートにOverview/Web/Growth/Newsletter | E-01（36-53行目） | ○ |
| C-04 | PostAnalyticsLayoutでラップ | E-02（10行目） | ○ |
| C-05 | Outletで子ルート表示 | E-02（11行目） | ○ |
| C-06 | usePostSuccessModalでシェアモーダル制御 | E-02（7行目） | ○ |
| C-07 | PostShareModalを条件付き表示 | E-02（12-14行目） | ○ |
| C-08 | Post型がPostBaseを拡張 | E-03（11行目） | ○ |
| C-09 | Post型にemail/newsletter/count/authors/tags含む | E-03（14-34行目） | ○ |
| C-10 | PostAnalyticsContextTypeにpostId/post/isPostLoading含む | E-03（36-52行目） | ○ |
| C-11 | useParamsでpostId取得 | E-03（65行目） | ○ |
| C-12 | postIdなしでエラーthrow | E-03（68-70行目） | ○ |
| C-13 | useBrowseConfigで設定取得 | E-03（72行目） | ○ |
| C-14 | useBrowseSiteでサイト情報取得 | E-03（73行目） | ○ |
| C-15 | useBrowseSettingsで設定取得 | E-03（75行目） | ○ |
| C-16 | useTinybirdTokenでトークン取得 | E-03（79行目） | ○ |
| C-17 | useBrowsePostsで投稿詳細取得 | E-03（82-87行目） | ○ |
| C-18 | filter:id:${postId}で投稿検索 | E-03（84行目） | ○ |
| C-19 | include:email,authors,tags,tiers,count.*で関連データ取得 | E-03（85行目） | ○ |
| C-20 | STATS_RANGES.LAST_30_DAYS.valueがデフォルトrange | E-03（74行目） | ○ |
| C-21 | statsConfigはconfig.data.config.statsから取得 | E-03（113行目） | ○ |
| C-22 | Contextでdata/site/statsConfig/tinybirdToken/post等を提供 | E-03（110-122行目） | ○ |
| C-23 | エラー時はthrowでエラーバウンダリへ | E-03（100-102行目） | ○ |
| C-24 | siteDataにurl/icon/title含む | E-03（104-108行目） | ○ |
| C-25 | inAdminForward機能フラグでEmber/React切替 | E-04 | ○ |
| C-26 | 機能No.52記事分析と関連 | E-06（50行目） | ○ |
| C-27 | ErrorPageを/posts/*で表示 | E-01（74-77行目） | ○ |
| C-28 | lazyComponentで各ビュー遅延ロード | E-01（39, 43, 47, 51行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] postIdなし時のエラーハンドリングが適切か確認
- [ ] useBrowsePostsのincludeパラメータが必要十分か確認
- [ ] Ember-React連携（posts-x.hbs, inAdminForward）の動作確認
