---
generated_at: 2026-01-29 20:47:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：27-投稿分析概要画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：28 / 28、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠が確認できたため、特記事項なし

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/posts/src/views/PostAnalytics/Overview/overview.tsx` - Overviewコンポーネント（全195行）
- E-02: `apps/posts/src/routes.tsx` - ルーティング定義（37-40行目）
- E-03: `apps/posts/src/hooks/use-post-referrers.ts` - リファラーフック
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（27行目）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング（51行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ''パスでOverviewを遅延ロード | E-02（37-40行目） | ○ |
| C-02 | useGlobalDataでstatsConfig/post/postId取得 | E-01（19行目） | ○ |
| C-03 | usePostReferrersでtotals/currencySymbol取得 | E-01（20行目）, E-03 | ○ |
| C-04 | useAppContextでappSettings取得 | E-01（21行目） | ○ |
| C-05 | emailTrackClicks/emailTrackOpensをappSettingsから取得 | E-01（22行目） | ○ |
| C-06 | chartRangeをgetRangeForStartDateで計算 | E-01（25-31行目） | ○ |
| C-07 | STATS_RANGES.ALL_TIME.valueがフォールバック | E-01（28行目） | ○ |
| C-08 | paramsにsite_uuid/post_uuid/date_from/date_to/timezone含む | E-01（36-53行目） | ○ |
| C-09 | isPostLoading && post?.uuidで条件分岐 | E-01（45-52行目） | ○ |
| C-10 | useTinybirdQueryでapi_kpis呼び出し | E-01（55-59行目） | ○ |
| C-11 | totalVisitorsをchartData.reduce計算 | E-01（62-70行目） | ○ |
| C-12 | processedChartDataをsanitizeChartDataで作成 | E-01（73-82行目） | ○ |
| C-13 | KPI_METRICS.visitsでフォーマッター取得 | E-01（73行目） | ○ |
| C-14 | useTinybirdQueryでapi_top_sources呼び出し | E-01（85-89行目） | ○ |
| C-15 | showNewsletterSection = hasBeenEmailed && emailTrackOpensEnabled && emailTrackClicksEnabled | E-01（95行目） | ○ |
| C-16 | showWebSection = !post?.email_only && webAnalytics | E-01（96行目） | ○ |
| C-17 | webAnalytics無効 && isPublishedOnly時にGrowthへリダイレクト | E-01（99-103行目） | ○ |
| C-18 | isPostLoading時はBarChartLoadingIndicator表示 | E-01（106-110行目） | ○ |
| C-19 | PostAnalyticsHeaderにcurrentTab='Overview'渡す | E-01（114行目） | ○ |
| C-20 | PostAnalyticsContentで子コンポーネントラップ | E-01（115行目） | ○ |
| C-21 | WebOverviewをshowWebSection時に表示 | E-01（117-126行目） | ○ |
| C-22 | NewsletterOverviewをshowNewsletterSection時に表示 | E-01（127-133行目） | ○ |
| C-23 | Growth Cardはcol-span-2で横幅いっぱい | E-01（134行目） | ○ |
| C-24 | Growthカード「View more」でgrowthへ遷移 | E-01（142-144行目） | ○ |
| C-25 | free_membersをKpiCardで表示 | E-01（156-163行目） | ○ |
| C-26 | paid_members/mrrはpaidMembersEnabled時のみ表示 | E-01（164-183行目） | ○ |
| C-27 | centsToDollarsでMRR変換 | E-01（179行目） | ○ |
| C-28 | 機能No.52記事分析と関連 | E-05（51行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] getRangeForStartDateの計算ロジックが期待通りか確認
- [ ] hasBeenEmailed/isPublishedOnlyの判定ロジック確認
- [ ] WebOverview/NewsletterOverviewコンポーネントの表示内容確認
