---
generated_at: 2026-01-29 20:50:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：28-投稿Webトラフィック画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：28 / 28、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠が確認できたため、特記事項なし

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/posts/src/views/PostAnalytics/Web/web.tsx` - Webコンポーネント（全271行）
- E-02: `apps/posts/src/routes.tsx` - ルーティング定義（41-44行目）
- E-03: `apps/posts/src/hooks/use-filter-params.ts` - フィルタURL同期フック
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（28行目）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング（52-53行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | /posts/analytics/:postId/webがルートパス | E-02（41-44行目） | ○ |
| C-02 | useNavigate/useParams/useGlobalDataでデータ取得 | E-01（28-30行目） | ○ |
| C-03 | useFilterParamsでフィルタ状態取得 | E-01（33行目）, E-03 | ○ |
| C-04 | audienceをフィルタから導出（getAudienceFromFilterValues） | E-01（36-39行目） | ○ |
| C-05 | email_only投稿時はOverviewにリダイレクト | E-01（42-46行目） | ○ |
| C-06 | chartRangeを公開日とrangeから計算 | E-01（49-58行目） | ○ |
| C-07 | getRangeForStartDateでcalculatedRange取得 | E-01（53行目） | ○ |
| C-08 | range > calculatedRange時はcalculatedRange使用 | E-01（54-56行目） | ○ |
| C-09 | scrollToTopでフィルタ適用後ページ先頭へ | E-01（63-68行目, 111行目） | ○ |
| C-10 | filterParamsでsource/location等パラメータ構築 | E-01（72-96行目） | ○ |
| C-11 | handleFilterClickでcreateFilter使用 | E-01（99-112行目） | ○ |
| C-12 | handleLocationClick/handleSourceClickの定義 | E-01（114-115行目） | ○ |
| C-13 | paramsにpost_uuid含む | E-01（126, 131行目） | ○ |
| C-14 | isPostLoading && post?.uuidで条件分岐 | E-01（129-136行目） | ○ |
| C-15 | useTinybirdQueryでapi_kpis呼び出し | E-01（140-144行目） | ○ |
| C-16 | useTinybirdQueryでapi_top_locations呼び出し | E-01（147-151行目） | ○ |
| C-17 | useTinybirdQueryでapi_top_sources呼び出し | E-01（154-158行目） | ○ |
| C-18 | totalVisits/totalSourcesVisits計算 | E-01（161-171行目） | ○ |
| C-19 | siteUrl/siteIconをglobalDataから取得 | E-01（174-175行目） | ○ |
| C-20 | processedLocationsDataでUnknown集約 | E-01（178-199行目） | ○ |
| C-21 | UNKNOWN_LOCATION_VALUESに含まれる値を集約 | E-01（183-184行目） | ○ |
| C-22 | kpiValuesをgetWebKpiValuesで取得 | E-01（203行目） | ○ |
| C-23 | hasFiltersでフィルタ適用状態判定 | E-01（206行目） | ○ |
| C-24 | hasFilters時にDateRangeSelect位置変更 | E-01（211-222行目） | ○ |
| C-25 | isPageLoading時はBarChartLoadingIndicator表示 | E-01（226-230行目） | ○ |
| C-26 | kpiValues.visits === '0'時はEmptyIndicator表示 | E-01（232, 254-263行目） | ○ |
| C-27 | Kpis/Locations/Sourcesコンポーネント表示 | E-01（234-252行目） | ○ |
| C-28 | 機能No.52記事分析、54リンクトラッキングと関連 | E-05（52-53行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] chartRangeの計算ロジック（range vs calculatedRange）が期待通りか確認
- [ ] Unknown地域の集約ロジックが正しいか確認
- [ ] フィルタパラメータのURL同期が正常に動作するか確認
