---
generated_at: 2026-01-29 20:53:00
metrics:
  claims_total: 25
  claims_with_evidence: 25
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：29-投稿成長分析画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：25 / 25、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠が確認できたため、特記事項なし

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/posts/src/views/PostAnalytics/Growth/growth.tsx` - Growthコンポーネント（全142行）
- E-02: `apps/posts/src/routes.tsx` - ルーティング定義（45-48行目）
- E-03: `apps/posts/src/hooks/use-post-referrers.ts` - リファラーフック
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（29行目）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング（54-55行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | /posts/analytics/:postId/growthがルートパス | E-02（45-48行目） | ○ |
| C-02 | useGlobalDataでglobalData取得 | E-01（20行目） | ○ |
| C-03 | useParamsでpostId取得 | E-01（21行目） | ○ |
| C-04 | usePostReferrersでstats/totals/isLoading/currencySymbol取得 | E-01（22行目）, E-03 | ○ |
| C-05 | useAppContextでappSettings取得 | E-01（23行目） | ○ |
| C-06 | siteUrl/siteIconをglobalDataから取得 | E-01（27-28行目） | ○ |
| C-07 | paidMembersEnabledでコンテナクラス切り替え | E-01（30-35行目） | ○ |
| C-08 | ローディング時はSkeleton表示 | E-01（41-65行目） | ○ |
| C-09 | centsToDollars関数でセント->ドル変換 | E-01（12-14行目, 118行目） | ○ |
| C-10 | Free members KPIカード表示 | E-01（74-91行目） | ○ |
| C-11 | Free membersのfilterParam = `signup:'${postId}'+conversion:-'${postId}'` | E-01（76行目） | ○ |
| C-12 | KpiCardMoreButtonのonClickで/membersに遷移 | E-01（77行目） | ○ |
| C-13 | KpiCardLabelのonClickで/membersに遷移 | E-01（81-84行目） | ○ |
| C-14 | Paid members KPIカードはpaidMembersEnabled時のみ表示 | E-01（92-122行目） | ○ |
| C-15 | Paid membersのfilterParam = `conversion:'${postId}'` | E-01（96行目） | ○ |
| C-16 | MRR KPIカードはpaidMembersEnabled時のみ表示 | E-01（112-121行目） | ○ |
| C-17 | MRRはCoinsアイコン使用 | E-01（114行目） | ○ |
| C-18 | Separatorはpaid無効時のみ表示 | E-01（126行目） | ○ |
| C-19 | GrowthSourcesコンポーネントでトップソース表示 | E-01（127-133行目） | ○ |
| C-20 | GrowthSourcesにdata(stats)/siteUrl/siteIcon/mode渡す | E-01（128-132行目） | ○ |
| C-21 | mode="growth"で成長モード指定 | E-01（131行目） | ○ |
| C-22 | navigate関数にcrossApp: true指定 | E-01（77, 97行目） | ○ |
| C-23 | filterParamはencodeURIComponentでエンコード | E-01（76, 96行目） | ○ |
| C-24 | totals?.free_members || 0でnullセーフ | E-01（89行目） | ○ |
| C-25 | 機能No.52記事分析、92メンバー属性と関連 | E-05（54-55行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] filterParamの構文がメンバー一覧画面で正しくパースされるか確認
- [ ] centsToDollarsの計算精度確認（Math.roundの使用）
- [ ] GrowthSourcesコンポーネントのmode="growth"時の挙動確認
