---
generated_at: 2026-01-29 20:45:00
metrics:
  claims_total: 26
  claims_with_evidence: 26
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-サインアップ画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：26 / 26、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/admin/app/templates/signup.hbs` - サインアップフォームテンプレート
- E-02: `ghost/admin/app/routes/signup.js` - サインアップルート定義
- E-03: `ghost/admin/app/controllers/signup.js` - サインアップコントローラー
- E-04: `ghost/admin/app/validators/signup.js` - サインアップバリデータ
- E-05: `ghost/admin/app/validators/new-user.js` - 新規ユーザーバリデータ
- E-06: `ghost/admin/app/validators/mixins/password.js` - パスワードバリデーションミックスイン
- E-07: `ghost/core/core/server/api/endpoints/authentication.js` - 認証APIエンドポイント
- E-08: `ghost/core/core/server/services/invitations/accept.js` - 招待受諾サービス
- E-09: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-10: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 招待トークンを使用して新規ユーザー登録 | E-02 (38-84行目), E-08 (16-48行目) | ○ |
| C-02 | 招待メールリンク経由でアクセス | E-02 (38行目: params.token) | ○ |
| C-03 | URL: /ghost/signup/:token | E-02, E-09 | ○ |
| C-04 | フルネーム必須、1文字以上 | E-05 (12-19行目) | ○ |
| C-05 | メールアドレス必須、形式チェック | E-05 (22-34行目) | ○ |
| C-06 | パスワード10文字以上 | E-06 (67-70行目) | ○ |
| C-07 | パスワード禁止リストチェック | E-06 (4-13行目, 75-80行目) | ○ |
| C-08 | パスワードにghost/password/passw0rd含まない | E-06 (14行目, 89-94行目) | ○ |
| C-09 | パスワードとメール同一チェック | E-06 (83-86行目) | ○ |
| C-10 | パスワードとブログタイトル同一チェック | E-06 (97-100行目) | ○ |
| C-11 | パスワード同一文字50%以上チェック | E-06 (23-49行目, 109-112行目) | ○ |
| C-12 | 登録成功後に自動ログイン | E-03 (60-68行目) | ○ |
| C-13 | 2FA必要時にサインイン確認画面遷移 | E-03 (63-66行目) | ○ |
| C-14 | トークン形式不正時にサインイン画面遷移 | E-02 (45-50行目) | ○ |
| C-15 | 招待無効時にサインイン画面遷移 | E-02 (69-74行目) | ○ |
| C-16 | ログイン済み時に警告表示 | E-02 (31-33行目) | ○ |
| C-17 | usersテーブルにINSERT | E-08 (40-45行目) | ○ |
| C-18 | roles_usersにロール割り当て | E-08 (44行目: roles: [invite.toJSON().role_id]) | ○ |
| C-19 | invitesテーブルから招待削除 | E-08 (47行目: invite.destroy) | ○ |
| C-20 | 招待有効期限チェック | E-08 (27-29行目) | ○ |
| C-21 | メールアドレス重複チェック | E-08 (31-38行目) | ○ |
| C-22 | POST /authentication/invitationで招待受諾 | E-07 (174-186行目), E-03 (92-105行目) | ○ |
| C-23 | GET /authentication/invitationで招待有効性確認 | E-07 (188-200行目), E-02 (61-74行目) | ○ |
| C-24 | トークンはBase64デコード | E-02 (52行目: atob), E-08 (18行目: decodeBase64) | ○ |
| C-25 | deactivateで機密情報クリア | E-02 (86-94行目) | ○ |
| C-26 | blogTitleをパスワードバリデーションに使用 | E-02 (77行目), E-06 (53行目) | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし。全ての主張に対して十分な根拠が確認できた。

## 5) リスクフラグ（レビュー観点）

- **0（低リスク）**：入出力項目・バリデーション - コードから明確に確認可能
- **0（低リスク）**：画面遷移 - ルート・コントローラーから確認可能
- **0（低リスク）**：エラーメッセージ - バリデータ・サービスから確認可能
- **0（低リスク）**：DB更新仕様 - accept.jsから確認可能
- **0（低リスク）**：トークン処理 - ルート・サービスから確認可能

## 6) レビュアーチェックリスト（最小）

- [ ] 招待トークンの有効期限設定を確認
- [ ] パスワード複雑性チェックの全条件が期待通りか確認
- [ ] 招待メール未受信時のユーザー体験を確認
- [ ] 招待レコード削除後の再登録可否を確認
- [ ] 自動ログイン失敗時のエラーハンドリングを確認
