---
generated_at: 2026-01-29 20:58:00
metrics:
  claims_total: 35
  claims_with_evidence: 35
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：30-投稿ニュースレター分析画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：35 / 35、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠が確認できたため、特記事項なし

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/posts/src/views/PostAnalytics/Newsletter/newsletter.tsx` - Newsletterコンポーネント（全554行）
- E-02: `apps/posts/src/routes.tsx` - ルーティング定義（49-52行目）
- E-03: `apps/posts/src/hooks/use-post-newsletter-stats.ts` - ニュースレター統計フック（全183行）
- E-04: `apps/posts/src/views/PostAnalytics/Newsletter/components/feedback.tsx` - Feedbackコンポーネント（全142行）
- E-05: `apps/posts/src/views/PostAnalytics/Newsletter/components/newsletter-radial-chart.tsx` - ラジアルチャート（全186行）
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（30行目）
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング（56-57行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | /posts/analytics/:postId/newsletterがルートパス | E-02（49-52行目） | ○ |
| C-02 | useNavigateでnavigate関数取得 | E-01（67行目） | ○ |
| C-03 | useState x 2でeditingLinkId/editedUrl管理 | E-01（68-69行目） | ○ |
| C-04 | useRef x 2でinputRef/containerRef定義 | E-01（70-71行目） | ○ |
| C-05 | ITEMS_PER_PAGE = 10 | E-01（72行目） | ○ |
| C-06 | useResponsiveChartSizeでchartSize取得 | E-01（73行目） | ○ |
| C-07 | useAppContextでappSettings取得 | E-01（74行目） | ○ |
| C-08 | emailTrackClicks/emailTrackOpensをappSettingsから取得 | E-01（75行目） | ○ |
| C-09 | useGlobalDataでpost/isPostLoading/postId取得 | E-01（78行目） | ○ |
| C-10 | hasBeenEmailedでshowNewsletterSection判定 | E-01（81行目） | ○ |
| C-11 | 非ニュースレター投稿時にリダイレクト | E-01（83-88行目） | ○ |
| C-12 | usePostNewsletterStatsでstats/averageStats/topLinks取得 | E-01（90行目）, E-03 | ○ |
| C-13 | useEditLinksでeditLinks取得 | E-01（91行目） | ○ |
| C-14 | feedbackStatsをuseMemoで計算 | E-01（94-112行目） | ○ |
| C-15 | shouldShowFeedbackの条件判定 | E-01（120-128行目） | ○ |
| C-16 | handleEdit関数でリンク編集開始 | E-01（130-136行目） | ○ |
| C-17 | handleUpdate関数でリンクURL更新 | E-01（138-163行目） | ○ |
| C-18 | useSimplePaginationでトップリンクページネーション | E-01（166-176行目） | ○ |
| C-19 | sentChartData = value: 1固定 | E-01（202-204行目） | ○ |
| C-20 | openedChartDataにaverageStats.openedRate含む | E-01（219-222行目） | ○ |
| C-21 | clickedChartDataにaverageStats.clickedRate含む | E-01（237-240行目） | ○ |
| C-22 | chartHeaderClassが設定により動的変化 | E-01（254-264行目） | ○ |
| C-23 | Sent KPIカードのfilterParam = emails.post_id | E-01（285-290行目） | ○ |
| C-24 | Opened KPIカードのfilterParam = opened_emails.post_id | E-01（311-316行目） | ○ |
| C-25 | Clicked KPIカードのfilterParam = clicked_links.post_id | E-01（338-343行目） | ○ |
| C-26 | emailTrackOpensEnabledでOpened表示制御 | E-01（309, 379行目） | ○ |
| C-27 | emailTrackClicksEnabledでClicked表示制御 | E-01（336, 401行目） | ○ |
| C-28 | shouldShowFeedbackでFeedback表示制御 | E-01（424行目） | ○ |
| C-29 | NewsletterRadialChartにconfig/data/percentageValue渡す | E-01（365-373, 386-394, 408-416行目）, E-05 | ○ |
| C-30 | FeedbackコンポーネントにfeedbackStats渡す | E-01（424行目）, E-04 | ○ |
| C-31 | トップリンク一覧でリンク編集機能あり | E-01（462-486行目） | ○ |
| C-32 | リンク外部クリック検知でeditingLinkIdリセット | E-01（178-196行目） | ○ |
| C-33 | トップリンクで(edited)表示 | E-01（496-498行目） | ○ |
| C-34 | Feedbackでタブ切り替え（positive/negative） | E-04（17, 21-22, 48行目） | ○ |
| C-35 | 機能No.22メール分析、56オーディエンスフィードバックと関連 | E-07（56-57行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] hasBeenEmailedの判定ロジックがadmin-x-frameworkの実装と一致するか確認
- [ ] editLinks APIのエラーハンドリング確認
- [ ] ニュースレター平均値算出ロジック（過去20件）の確認
- [ ] feedbackのスコア（1=positive, 0=negative）の確認
