---
generated_at: 2026-01-29 20:35:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：31-メンション画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **C-27 業務目的の記載**：コードから直接推測できない業務要件
  2. **C-28 IndieWeb運動への言及**：Webmention仕様に関する外部知識

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/admin/app/templates/mentions.hbs` - テンプレートファイル
- E-02: `ghost/admin/app/routes/mentions.js` - ルートファイル
- E-03: `ghost/admin/app/controllers/mentions.js` - コントローラーファイル
- E-04: `ghost/admin/app/models/mention.js` - Ember Dataモデル
- E-05: `ghost/admin/app/adapters/mention.js` - APIアダプター
- E-06: `ghost/admin/app/services/mention-utils.js` - ユーティリティサービス
- E-07: `ghost/admin/app/router.js` - ルーター定義
- E-08: `ghost/core/core/server/data/schema/schema.js` - DBスキーマ
- E-09: `ghost/core/core/server/services/mentions/mentions-api.js` - サーバーサイドAPI
- E-10: `ghost/core/core/server/web/webmentions/routes.js` - Webmentionルート
- E-11: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL `/ghost/mentions` で全メンション一覧にアクセス | E-07 (L95) | ○ |
| C-02 | URL `/ghost/posts/analytics/:post_id/mentions` で投稿別メンション | E-07 (L37) | ○ |
| C-03 | Webmentions機能フラグが無効時はposts-xにリダイレクト | E-02 (L28-30) | ○ |
| C-04 | perPageのデフォルト値は10 | E-02 (L23) | ○ |
| C-05 | メンションはcreated_at descでソート | E-02 (L41) | ○ |
| C-06 | post_id指定時はresource_id+resource_typeでフィルタ | E-02 (L45) | ○ |
| C-07 | post_id未指定時はunique=trueでグループ化 | E-02 (L48-49) | ○ |
| C-08 | mentionsInfinityModelはmodel.mentionsを返す | E-03 (L4-6) | ○ |
| C-09 | パンくずリストは投稿指定時/未指定時で分岐 | E-01 (L4-22) | ○ |
| C-10 | メンションカードは外部リンクとして開く | E-01 (L45) | ○ |
| C-11 | rel="noreferrer noopener"属性が設定される | E-01 (L45) | ○ |
| C-12 | 複数リンク時はEmberPopoverでポップオーバー表示 | E-01 (L59-65) | ○ |
| C-13 | 無限スクロールのtriggerOffsetは1000px | E-01 (L107) | ○ |
| C-14 | メンションが存在しない場合は空状態表示 | E-01 (L98-104) | ○ |
| C-15 | 空状態メッセージ "No mentions yet" | E-01 (L100) | ○ |
| C-16 | mentionモデルにsource, target, timestamp等の属性 | E-04 (L3-15) | ○ |
| C-17 | mentionsテーブルのスキーマ定義 | E-08 (L1059-1075) | ○ |
| C-18 | sourceカラムは最大2000文字 | E-08 (L1061) | ○ |
| C-19 | deleted, verifiedはbooleanでデフォルトfalse | E-08 (L1073-1074) | ○ |
| C-20 | loadGroupedMentionsで同一ソースをグループ化 | E-06 (L6-18) | ○ |
| C-21 | MentionsAPIのlistMentionsでページネーション処理 | E-09 (L140-164) | ○ |
| C-22 | Webmention受信は/webmentions/receiveエンドポイント | E-10 (L21) | ○ |
| C-23 | 認証必須（AuthenticatedRoute継承） | E-02 (L1, L17) | ○ |
| C-24 | 関連機能No.58 Webmention | E-11 (L58) | ○ |
| C-25 | サイドバーにMentions機能の説明テキスト表示 | E-01 (L111-117) | ○ |
| C-26 | タイムスタンプはmoment-from-nowで相対時間表示 | E-01 (L75) | ○ |
| C-27 | 業務目的：コンテンツマーケティングでの被リンク把握 | **根拠なし** | △ |
| C-28 | IndieWeb運動の一環としての役割 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- **業務目的・背景の記載（C-27, C-28）**
  - コードからは機能の技術的な実装は確認できるが、ビジネス上の目的は明示されていない
  - 候補となる情報源：製品ドキュメント / PRD / ユーザーガイド / Webmention仕様書（W3C）

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク** - 技術仕様（URL、パラメータ、データ構造）はコードから直接確認済み
- **1: 中リスク** - 業務目的の記載は推測に基づく。ただし、Webmention機能の一般的な用途としては妥当
- **0: 低リスク** - フィーチャーフラグの動作はコードで明確に確認

## 6) レビュアーチェックリスト（最小）

- [ ] パンくずリストの遷移先（Posts, Analytics, Dashboard）が正しいか実機確認
- [ ] Webmentions機能フラグ無効時のリダイレクト動作を確認
- [ ] 無限スクロールが正常に動作するか確認
- [ ] 複数リンク時のポップオーバー表示を確認
- [ ] 空状態表示のメッセージが正しいか確認
