---
generated_at: 2026-01-29 20:45:00
metrics:
  claims_total: 32
  claims_with_evidence: 30
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：32-設定画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：30 / 32、根拠なし：2
- 優先レビュー（高）
  1. **C-31 権限による表示制御**：Admin権限以上の制限はコードから明示的に確認できない
  2. **C-32 Ownerのみ編集可能な設定**：危険ゾーンのOwner制限は推測

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/admin/app/templates/settings-x.hbs` - Emberテンプレート
- E-02: `apps/admin-x-settings/src/app.tsx` - Reactアプリルート
- E-03: `apps/admin-x-settings/src/components/settings.tsx` - 設定メイン
- E-04: `apps/admin-x-settings/src/components/settings/general/general-settings.tsx` - General設定
- E-05: `apps/admin-x-settings/src/components/settings/site/site-settings.tsx` - Site設定
- E-06: `apps/admin-x-settings/src/components/settings/membership/membership-settings.tsx` - Membership設定
- E-07: `apps/admin-x-settings/src/components/settings/email/email-settings.tsx` - Email設定
- E-08: `apps/admin-x-settings/src/components/settings/growth/growth-settings.tsx` - Growth設定
- E-09: `apps/admin-x-settings/src/components/settings/advanced/advanced-settings.tsx` - Advanced設定
- E-10: `apps/admin-x-settings/src/components/providers/settings-router.tsx` - ルーター
- E-11: `ghost/admin/app/router.js` - Emberルーター
- E-12: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL `/ghost/settings` で設定画面にアクセス | E-11 (L60-62) | ○ |
| C-02 | inAdminForwardフラグでレンダリング方法が分岐 | E-01 (L2) | ○ |
| C-03 | AdminX::Settingsコンポーネントを使用 | E-01 (L3) | ○ |
| C-04 | 6つの設定セクションを表示 | E-03 (L14-19) | ○ |
| C-05 | GeneralSettings, SiteSettings等のセクション構成 | E-03 (L3-8) | ○ |
| C-06 | RoutingProviderでbasePath='settings'を設定 | E-02 (L21) | ○ |
| C-07 | NiceModal.Providerでモーダル管理 | E-02 (L20) | ○ |
| C-08 | General設定に8つのサブコンポーネント | E-04 (L29-36) | ○ |
| C-09 | searchKeywordsで検索キーワードを定義 | E-04 (L13-22) | ○ |
| C-10 | Site設定に4つのサブコンポーネント | E-05 (L19-22) | ○ |
| C-11 | Membership設定の条件付き表示（welcomeEmails） | E-06 (L25, L33) | ○ |
| C-12 | Membership設定の条件付き表示（Stripe） | E-06 (L24, L34) | ○ |
| C-13 | Email設定でnewslettersEnabled判定 | E-07 (L20, L25) | ○ |
| C-14 | Mailgun未設定時のみMailgun設定を表示 | E-07 (L29) | ○ |
| C-15 | Growth設定でStripe有効時のみOffers表示 | E-08 (L21, L29) | ○ |
| C-16 | Advanced設定に6つのサブコンポーネント | E-09 (L22-27) | ○ |
| C-17 | modalPathsでURL→モーダル名マッピング | E-10 (L6-41) | ○ |
| C-18 | design/change-theme → DesignAndThemeModal | E-10 (L7) | ○ |
| C-19 | staff/invite → InviteUserModal | E-10 (L11) | ○ |
| C-20 | staff/:slug → UserDetailModal | E-10 (L15) | ○ |
| C-21 | portal/edit → PortalModal | E-10 (L16) | ○ |
| C-22 | tiers/add → TierDetailModal | E-10 (L17) | ○ |
| C-23 | newsletters/:id → NewsletterDetailModal | E-10 (L21) | ○ |
| C-24 | integrations/zapier → ZapierModal | E-10 (L24) | ○ |
| C-25 | recommendations/add → AddRecommendationModal | E-10 (L32) | ○ |
| C-26 | loadModals()で遅延ロード | E-10 (L43) | ○ |
| C-27 | useRouteChangeCallbackでスクロール制御 | E-10 (L49-53) | ○ |
| C-28 | SearchableSectionでキーワード検索 | E-04 (L28) | ○ |
| C-29 | 関連機能No.35 一般設定 | E-12 (L59) | ○ |
| C-30 | 画面種別は設定ハブ | E-03 全体構造 | ○ |
| C-31 | Admin権限以上のみアクセス可能 | **根拠なし** | △ |
| C-32 | 危険ゾーンはOwnerのみ編集可能 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- **権限による表示制御（C-31, C-32）**
  - 設定画面の権限チェックはコンポーネント内部で行われている可能性があるが、明示的なコードは確認できていない
  - 候補となる情報源：認証・認可ミドルウェア / ロールベースのアクセス制御ロジック / API側の権限チェック

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク** - 画面構成、セクション、モーダルパスはコードから直接確認済み
- **0: 低リスク** - 条件付き表示（フィーチャーフラグ、Stripe有効）はコードで明確
- **1: 中リスク** - 権限制御の詳細は追加調査が必要

## 6) レビュアーチェックリスト（最小）

- [ ] 各設定セクションが正しく表示されるか実機確認
- [ ] welcomeEmailsフラグ無効時にMember emailsが非表示になるか確認
- [ ] Stripe未連携時にOffers, Tips and donationsが非表示になるか確認
- [ ] Mailgun設定済み時にMailgun設定項目が非表示になるか確認
- [ ] 設定検索機能が正常に動作するか確認
- [ ] 各モーダルパスへの遷移が正しく動作するか確認
- [ ] Admin未満の権限でアクセスした場合の挙動を確認
