---
generated_at: 2026-01-29 21:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：35-言語設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/admin-x-settings/src/components/settings/general/publication-language.tsx` - メインコンポーネント
- E-02: `apps/admin-x-settings/src/components/settings/general/general-settings.tsx` - 親コンポーネント
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コンポーネント名は PublicationLanguage | E-01 (L10) | ○ |
| C-02 | LOCALE_DATAを@tryghost/i18nからインポート | E-01 (L1) | ○ |
| C-03 | useSettingGroupフックを使用 | E-01 (L11-31) | ○ |
| C-04 | onValidateでvalidateLocaleを呼び出し | E-01 (L21-30) | ○ |
| C-05 | getSettingValuesで'locale'を取得 | E-01 (L33) | ○ |
| C-06 | useMemoでlocaleOptionsを生成 | E-01 (L35-42) | ○ |
| C-07 | handleLanguageChangeでロケール更新 | E-01 (L44-49) | ○ |
| C-08 | updateSetting('locale', value)を呼び出し | E-01 (L45) | ○ |
| C-09 | ヒントにドキュメントリンクを含む | E-01 (L51-56) | ○ |
| C-10 | https://ghost.org/docs/faq/translation/へのリンク | E-01 (L54) | ○ |
| C-11 | TopLevelGroupでラップ | E-01 (L58-89) | ○ |
| C-12 | hideEditButton プロパティあり | E-01 (L67) | ○ |
| C-13 | navid='publication-language' | E-01 (L63) | ○ |
| C-14 | title="Publication Language" | E-01 (L66) | ○ |
| C-15 | SelectWithOtherコンポーネントを使用 | E-01 (L73) | ○ |
| C-16 | defaultListValue="en" | E-01 (L74) | ○ |
| C-17 | otherPlaceholder="e.g. pt-BR, sr-Cyrl, en" | E-01 (L79) | ○ |
| C-18 | isSearchable プロパティあり | E-01 (L84) | ○ |
| C-19 | validateLocaleをvalidateプロパティに渡す | E-01 (L83) | ○ |
| C-20 | 関連機能No.37 多言語対応 | E-03 (L62) | ○ |

## 4) 不足情報（Unknown / Missing）

- なし（全ての主張がソースコードから確認可能）

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク** - 全ての技術仕様がソースコードから直接確認済み
- **0: 低リスク** - ロケールデータは公式パッケージから提供される

## 6) レビュアーチェックリスト（最小）

- [ ] 言語選択時に正しくロケールコードが設定されることを確認
- [ ] カスタムロケール入力が正常に機能することを確認
- [ ] 無効なロケールコード入力時にエラーが表示されることを確認
- [ ] 保存成功時にロケールが反映されることを確認
