---
generated_at: 2026-01-29 21:05:00
metrics:
  claims_total: 30
  claims_with_evidence: 30
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：36-ユーザー・権限設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：30 / 30、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/admin-x-settings/src/components/settings/general/users.tsx` - メインコンポーネント
- E-02: `apps/admin-x-settings/src/components/settings/general/general-settings.tsx` - 親コンポーネント
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コンポーネント名は Users | E-01 (L205) | ○ |
| C-02 | useStaffUsersフックを使用 | E-01 (L206-220) | ○ |
| C-03 | useRoutingでルート更新 | E-01 (L221) | ○ |
| C-04 | useGlobalDataでsettings, config, currentUser取得 | E-01 (L222) | ○ |
| C-05 | Ownerコンポーネントでオーナー表示 | E-01 (L31-54, L295) | ○ |
| C-06 | hasAdminAccess判定でView profile表示 | E-01 (L36, L46, L49) | ○ |
| C-07 | TabViewで5つのタブを表示 | E-01 (L249-280, L296) | ○ |
| C-08 | administratorsタブ | E-01 (L250-255) | ○ |
| C-09 | editorsタブ | E-01 (L256-261) | ○ |
| C-10 | authorsタブ | E-01 (L262-267) | ○ |
| C-11 | contributorsタブ | E-01 (L268-273) | ○ |
| C-12 | invitedタブ | E-01 (L274-279) | ○ |
| C-13 | UsersListコンポーネントでユーザー一覧 | E-01 (L56-102) | ○ |
| C-14 | canEdit判定ロジック | E-01 (L80-82) | ○ |
| C-15 | Suspended状態の表示 | E-01 (L76-78) | ○ |
| C-16 | UserInviteActionsでRevoke/Resendボタン | E-01 (L104-169) | ○ |
| C-17 | deleteInviteで招待取り消し | E-01 (L108, L129) | ○ |
| C-18 | addInviteで招待再作成 | E-01 (L109, L151-154) | ○ |
| C-19 | showToastで成功メッセージ | E-01 (L130-134, L155-159) | ○ |
| C-20 | InvitesUserListで招待一覧 | E-01 (L171-203) | ○ |
| C-21 | "Invite people"ボタン | E-01 (L228-232) | ○ |
| C-22 | showInviteModal → updateRoute('staff/invite') | E-01 (L224-226) | ○ |
| C-23 | タブ切り替えでURL更新 | E-01 (L244-247) | ○ |
| C-24 | useQueryParamsでtabパラメータ取得 | E-01 (L234) | ○ |
| C-25 | Load moreボタン (users) | E-01 (L298-302) | ○ |
| C-26 | Load moreボタン (invites) | E-01 (L303-307) | ○ |
| C-27 | Security settings (2FA Toggle) | E-01 (L309-334) | ○ |
| C-28 | config.security.staffDeviceVerification条件 | E-01 (L309) | ○ |
| C-29 | editSettingsで'require_email_mfa'更新 | E-01 (L324-327) | ○ |
| C-30 | 関連機能No.40, 41, 43 | E-03 (L63-65) | ○ |

## 4) 不足情報（Unknown / Missing）

- なし（全ての主張がソースコードから確認可能）

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク** - 全ての技術仕様がソースコードから直接確認済み
- **0: 低リスク** - 権限判定ロジックが明確にコード化されている

## 6) レビュアーチェックリスト（最小）

- [ ] オーナーのプロフィールクリックでモーダルが開くことを確認
- [ ] 各ロールタブでユーザーが正しく分類されていることを確認
- [ ] 招待の取り消し・再送信が正常に動作することを確認
- [ ] 2FA設定トグルが正常に動作することを確認
- [ ] Editor権限でContributor以外のユーザーが編集できないことを確認
- [ ] Load moreでページネーションが動作することを確認
